<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pengaturan_umum_m extends CI_Model {
    var $table = 'master_company';
    public function __construct(){
        parent::__construct();
    }

    public function getData(){
        $select = $this->db->select("lock_device, lock_lokasi, lock_facerecognition")
                            ->from($this->table)
                            ->where("id_company",$this->id_company)
                            ->get()
                            ->row();
        return $select;
    }

    public function save($master_company = null, $data_karyawan = null, $data_users = null){
        if($master_company == null){
            return __response_update(false);
        }else{

            $this->db->trans_start();

            # Update Master Company
            $this->db->where(array('id_company'=>$this->id_company));
            $this->db->update($this->table,$master_company);

            # Update Data Karyawan
            if($data_karyawan != null){
                $this->db->where(array('id_company'=>$this->id_company));
                $this->db->update('data_karyawan',$data_karyawan);
            }

            # Update Data Users
            if($data_users != null){
                $this->db->where(array('id_company'=>$this->id_company));
                $this->db->update('users',$data_users);
            }

            $this->db->trans_complete();

            /*Optional*/
            if($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
                return  __response_update(false);
            }else{
                $this->db->trans_commit();
                return  __response_update(true);
            }
        }
    }

    public function reset_cuti($status=null, $option=null, $jml_cuti=null){
        $tahun = date('Y');
        $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXY';
        $kode_reset = $this->id_company.$tahun;
        for ($i = 0; $i < 5; $i++){
                $kode_reset .= $characters[mt_rand(0, 35)];
        }

        $this->db->trans_start();

        $this->db->query("INSERT h_cuti(tahun,id_karyawan,nama_karyawan,jml_cuti,kode_reset,user_reset,id_company)
                            SELECT '$tahun',id_karyawan,nama_lengkap,jatah_cuti,'$kode_reset','$this->id_karyawan',id_company FROM data_karyawan WHERE id_company='".$this->id_company."'");

        if($status == "reset"){
            $this->db->where('id_company',$this->id_company);
            $this->db->set('jatah_cuti',$jml_cuti);
            $this->db->update('data_karyawan');
            $message = ['message'=>'<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Jumlah cuti karyawan berhasil direset</font>'];
        }else{
            $this->db->where('id_company',$this->id_company);
            if($option == 'tambah'){
                $message = ['message'=>'<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Jumlah cuti karyawan berhasil ditambah</font>'];
                $this->db->set('jatah_cuti', 'jatah_cuti+'.$jml_cuti, FALSE);
            }else if($option == 'kurang'){
                $message = ['message'=>'<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Jumlah cuti karyawan berhasil dikurangi</font>'];
                $this->db->set('jatah_cuti', 'jatah_cuti-'.$jml_cuti, FALSE);
            }else{
                $message = ['message'=>'<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Tidak Ada perubahan</font>'];
                $this->db->set('jatah_cuti', 'jatah_cuti', FALSE);
            }
            $this->db->update('data_karyawan');
        }

        $this->db->trans_complete();

        if($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            $message = ['message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal disimpan</font>'];
            return  __response_update(false,$message);
        }else{
            $this->db->trans_commit();
            return  __response_update(true,$message);
        }
    }
}