<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quick_setup_departemen extends MY_Controller{

  public function __construct()
  {
    parent::__construct();
    $this->load->model('Quick_setup_departemen_m', 'q_departemen_m');
  }

  function index()
  {
    $data['aktif'] = 'kelola_mudah';
    $data['judul'] = 'Quick Setup Departemen';
    $data['jenis'] = 'departemen';
    $data['menu'] = $this->load->view('main_menu', $data, true);
    $data['menu_quick_setup'] = $this->load->view('quick_setup/menu', $data, true);
    $data['main'] = $this->load->view('quick_setup/departemen/main', $data, true);
    $data['table'] = $this->load->view('quick_setup/departemen/table', $data, true);
    $data['content'] = $this->load->view('quick_setup/main', $data, true);
    $this->load->view('main_template', $data, false);
  }

  public function list_data(){
		$list = $this->q_departemen_m->get_datatables();
		$data = array();
    $no = $_POST['start'];
		foreach ($list as $field) {
      $no++;
			$row = array();
      $row[] = $no;
			$row[] = $field->kode;
			$row[] = $field->nama;
      $row[] = '<a href="#" data-target="tooltip" title="Edit" style="color:#434343;" class="text-warning"
                  onclick="edit(\''.$field->id_departemen.'\')">
                  <i id="" class="btn_edit fa fa-edit"></i>
                </a>&nbsp;
                <a href="#" data-target="tooltip" title="Delete" style="color:#434343;" class="text-danger"
                  onclick="hapus(\''.$field->id_departemen.'\')">
                    <i id="" class="btn_delete fa fa-trash"></i>
                </a>';

			$data[] = $row;
		}

		$output = array("draw"    => $_POST['draw'],
						"recordsTotal"    => $this->q_departemen_m->count_all(),
						"recordsFiltered" => $this->q_departemen_m->count_filtered(),
						"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

  function save() {
    $kode = $this->input->post('kode');
    $cek  = $this->q_departemen_m->cek_kode($kode);
    if($cek > 0) {
      return __response_save(false, array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode departemen sudah digunakan</font>'));
    } else {
      $nama = $this->input->post('nama');
      $cek_nama = $this->q_departemen_m->cek_nama($nama);
      if($cek_nama > 0) {
        return __response_save(false, array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Nama departemen sudah digunakan</font>'));
      } else {
        $this->q_departemen_m->save();
      }
    }
  }

  function update() {
    $kode_temp  = $this->input->post('kode_temp');
    $kode       = $this->input->post('kode');
    $nama_temp  = $this->input->post('nama_temp');
    $nama       = $this->input->post('nama');
    $equal      = strcasecmp($kode_temp, $kode);
    $equal_nama = strcasecmp($nama_temp, $nama);

    //cek kode temp dan kode sekarang sama
    //nama temp dan nama sekarang sama
    if($equal == 0 and $equal_nama == 0) {
      $this->q_departemen_m->update();
    } elseif($equal != 0 and $equal_nama == 0) {
      $cek  = $this->q_departemen_m->cek_kode($kode);
      if($cek > 0) {
        return __response_update(false, array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode departemen sudah digunakan</font>'));
      } else {
        $this->q_departemen_m->update();
      }
    } elseif($equal == 0 and $equal_nama != 0) {
      $cek_nama = $this->q_departemen_m->cek_nama($nama);
      if($cek_nama > 0) {
        return __response_update(false, array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Nama departemen sudah digunakan</font>'));
      } else {
        $this->q_departemen_m->update();
      }
    } else {
      $cek  = $this->q_departemen_m->cek_kode($kode);
      if($cek > 0) {
        return __response_update(false, array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode departemen sudah digunakan</font>'));
      } else {
        $cek_nama = $this->q_departemen_m->cek_nama($nama);
        if($cek_nama > 0) {
          return __response_update(false, array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Nama departemen sudah digunakan</font>'));
        } else {
          $this->q_departemen_m->update();
        }
      }
    }

  }

  function delete() {
    $cek_karyawan = $this->q_departemen_m->cek_karyawan();
    if($cek_karyawan > 0) {
      return __response_delete(false, array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Gagal, terdapat karyawan didepartemen ini</font>'));
    } else {
      $this->q_departemen_m->delete();
    }
  }

  function detail($id_departemen) {
    $detail = $this->q_departemen_m->detail($id_departemen);
    $data['kode']           = $detail->kode;
    $data['nama']           = $detail->nama;
    $data['id_departemen']  = $detail->id_departemen;
    echo json_encode($data);
  }
}
