<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kepegawaian extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Db_model', 'db_model');
        $this->load->model('Kepegawaian_m', 'kepegawaian');
	}
	
	public function index(){
		$data['judul'] = 'Kepegawaian';
		$data['aktif'] = 'kepegawaian';
        $data['status_karyawan'] = $this->kepegawaian->getStatusKaryawan();
        $data['pendidikan'] = $this->kepegawaian->getDataPendidikan();
        $data['data_karyawan'] = $this->kepegawaian->get_datatables();
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('kepegawaian/home', $data, true);
        $this->load->view('main_template', $data, false);
	}

    function data_kepegawaian($id_cabang = 0){
        $status_karyawan =  $this->kepegawaian->getStatusKaryawan($id_cabang);
        echo json_encode($status_karyawan);
	}

    public function data_pendidikan($id_cabang = 0){
        $data_pendidikan =  $this->kepegawaian->getDataPendidikan($id_cabang);
        echo json_encode($data_pendidikan);
    }

    public function daftar_kontrak(){
        $data['judul'] = 'Daftar Karyawan Kontrak';
        $data['aktif'] = 'kepegawaian';
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('kepegawaian/daftar_kontrak', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data(){
        $list = $this->kepegawaian->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $field) {
            $no++;
            $row = array();
            $row[] = $no;
            $row[] = $field->nama_lengkap.'<br>'.$field->nik;
            $row[] = $field->kode_cabang.' - '.$field->nama_cabang;
            $row[] = $field->kode_departemen.' - '.$field->nama_departemen;
            $row[] = $field->kode_jabatan.' - '.$field->nama_jabatan;
            $row[] = $this->fungsi->format_date_strip($field->tgl_aktif_bekerja);
            $row[] = $this->fungsi->format_date_strip($field->tgl_berhenti_bekerja);
            if($field->jml_hari < 0){
                $row[] = '<div class="badge badge-danger" style="color: white;">Kontrak Sudah Berakhir</div>';
            }else{
                $row[] = $field->jml_hari.' Hari lagi';
            }
            $row[] = '<a href="'.site_url('master/karyawan/detail').'/'.md5($field->id_karyawan).'" class="text-info" title="DETAIL">
                            <i id="'.md5($field->id_karyawan).'" class="fa fa-info-circle"> </i></a>';
    
            $data[] = $row;
        }
    
        $output = array("draw"            => $_POST['draw'],
                        "recordsTotal"    => $this->kepegawaian->count_all(),
                        "recordsFiltered" => $this->kepegawaian->count_filtered(),
                        "data"            => $data);

        $output = __response($this->MY_response, $output);
                
        echo json_encode($output);
    }

    function download() {
        $file_name      = "DAFTAR PEGAWAI KONTRAK YANG AKAN BERAKHIR DAN SUDAH BERAKHIR";
        $data['title']  = $file_name;
        $data['data']   = $this->kepegawaian->get_datatables();
        $output         = true;
        $sb_view        = $this->load->view('kepegawaian/download', $data, $output);

        $param = [
            'download'      => true,
            'cLength'       => 8,
            'file_name'     => $file_name,
            'paper_size'    => 'LEGAL',
            'font-size'		=> 9,
            // 'pagebreak'		=> true,
            'page_margin'	=> ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation'	=> 'landscape',
            'header'        => [
                                    '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                                    '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                                ],
            // 'freezecolumn'  => ['O6'],
            'thead'         => ['3'],
            'tbody'         => [
                                'start' => '3',
                                'height'	=> 13,
                                'wrap' => ['B', 'C'],
                                'column' => [
                                    'A'    => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
                                    'B'    => ['width' => 10, 'align' => 'center', 'valign' => 'middle'],
                                    'C'    => ['width' => 40],
                                    'G'    => ['align' => 'center'],
                                    'H'    => ['align' => 'center'],
                                    'I'    => ['align' => 'center'],
                                ],
            ],
        ];

        if($output) {
            $this->load->library('PHPExcel/Excel');
            $this->excel->generateExcel($sb_view, $param);
        }
    }

}
