<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Jenis_izin extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Jenis_izin_m');

        check_login();
    }

	public function index(){
		$data['judul'] = 'Jenis Izin';
		$data['aktif'] = 'jenis_izin';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('jenis_izin/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
		$list = $this->Jenis_izin_m->get_datatables();
		$data = array();
		$no = $_POST['start'];

		foreach ($list as $field) {
			$no++;

			if($field->flag == '0'){
				$flag = '<span class="badge badge-danger">Tidak</span>';
			}else{
				$flag = '<span class="badge badge-success">Ya</span>';
			}

			$row = array();
			$row[] = $no;
			$row[] = $field->kode_izin;
			$row[] = $field->nama;
			$row[] = $field->jenis_izin;
			$row[] = $field->max_izin;
			$row[] = $flag;

			if(in_array($this->session->userdata('level_user'), array("1"))) {

			$row[] = '<a href="#" class="text-warning" title="EDIT">
							<i id="'.md5($field->id_jenis_izin).'" class="btn_edit fa fa-edit (alias) "> </i></a>&nbsp;
						<a href="#" class="text-danger" title="HAPUS">
							<i id="'.md5($field->id_jenis_izin).'" class="btn_delete fa fa-trash"></i>
						</a>';
			}

			$data[] = $row;
		}

			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $this->Jenis_izin_m->count_all(),
							"recordsFiltered" => $this->Jenis_izin_m->count_filtered(),
							"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function form($id=null){
		if($id==null){
			$this->load->view('jenis_izin/form');
		}else{
			$data['data'] = $this->Jenis_izin_m->getDataById($id);
			$this->load->view('jenis_izin/form',$data);
		}

	}

	public function save(){
		$id = $this->input->post('id_jenis_izin');
		$kd_jenis_izin_old = $this->input->post('kd_jenis_izin_old');
		$id_company = $this->session->userdata('id_company');

		$data = array('kode_izin'	=>$this->input->post('kd_jenis_izin'),
					'nama'			=>$this->input->post('nm_jenis_izin'),
					'jenis_izin'	=>$this->input->post('jenis_izin'),
					'max_izin'		=>$this->input->post('max_izin'),
					'flag'			=>$this->input->post('flag'),
					'id_company' 	=>$id_company);

		$this->Jenis_izin_m->save($data,$id,$kd_jenis_izin_old);
	}

	public function delete(){
		$id = $this->input->post("id_jenis_izin");
		$this->Jenis_izin_m->delete($id);
	}

	public function getJenis_izinByName($id = null){
        $search = $this->input->get("q");
        $nama_paket = $this->Jenis_izin_m->max_karyawan()->nama;
        $this->Jenis_izin_m->getCabangByName($id, $search, $nama_paket);
    }
}
