<script>
    $(function() {
        $(".move-tahapan").on("click", function() {
            var jenis = $(this).data("jenis");
            var id_pipeline = "<?= $id ?>";
            var param = {};
            param.tahapan_sesudah = $(this).data("tahapan");
            param.id_pipeline = id_pipeline;
            param.action = "move";
            param.periode = "<?= $periode ?>";
            if (["wont", "lost"].includes(jenis)) {
                $("#tampil_form").load("<?= route("sales_activity.kanban.form", ['jenis' => '" + jenis + "', 'id_pipeline' => '" + id_pipeline + "']) ?>", function() {
                    $("#modal_form .modal-dialog").addClass("modal-lg");
                    $("#modal_form").modal("show");

                    $("#btn_submit").on("click", function(el) {
                        el.preventDefault();
                        $("#message").html("");
                        var loading = Ladda.create(this);

                        param.keterangan = $("#form_kanban #keterangan textarea").val();

                        $.ajax({
                            type: 'POST',
                            url: "<?= route('sales_activity.kanban.update_pipeline') ?>",
                            data: param,
                            dataType: 'JSON',
                            beforeSend: function() {
                                loading.start();
                                disable_form("#form_kanban", ["input", "textarea", "select", "button"], true);
                            },
                            success: function(result) {
                                loading.stop();
                                if (result.success == true) {
                                    showMsg(result.message);
                                    load_data(get_periode(), get_pelanggan(), get_sales());
                                    $("#detail-perusahaan").load("<?= route('sales_activity.kanban.detail.perusahaan', ['id' => $id, 'periode' => $periode]) ?>");
                                    $("#detail-aktivitas").load("<?= route('sales_activity.kanban.detail.aktivitas', ['id' => $id]) ?>");
                                } else {
                                    disable_form("#form_kanban", ["input", "textarea", "select", "button"], false);
                                    $('#message').show();
                                    $('#message').html(result.message);
                                }
                            },
                            error: function() {
                                loading.stop();
                                disable_form("#form_kanban", ["input", "textarea", "select", "button"], false);
                                $('#message').show();
                                $('#message').html('<font color="#eb3a28"><i class="fa fa-close (alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                            }
                        });
                    });
                });
            } else {
                $.ajax({
                    type: 'POST',
                    url: "<?= route('sales_activity.kanban.update_pipeline') ?>",
                    data: param,
                    dataType: 'JSON',
                    beforeSend: function() {
                        $("#stage-header").find("div:eq(0)").removeClass("d-flex").addClass("hidden");
                        $("#stage-header").find("div:eq(0)").next().removeClass("hidden").addClass("d-flex");
                    },
                    success: function(result) {
                        if (result.success == true) {
                            load_data(get_periode(), get_pelanggan(), get_sales());
                            $("#detail-perusahaan").load("<?= route('sales_activity.kanban.detail.perusahaan', ['id' => $id, 'periode' => $periode]) ?>");
                            $("#detail-aktivitas").load("<?= route('sales_activity.kanban.detail.aktivitas', ['id' => $id]) ?>");
                        } else {
                            showMsg(result.message, true, 2000);
                            $("#stage-header").find("div:eq(0)").removeClass("hidden").addClass("d-flex");
                            $("#stage-header").find("div:eq(0)").next().removeClass("d-flex").addClass("hidden");
                        }
                    },
                    error: function() {
                        showMsg('error', false);
                        $("#stage-header").find("div:eq(0)").removeClass("hidden").addClass("d-flex");
                        $("#stage-header").find("div:eq(0)").next().removeClass("d-flex").addClass("hidden");
                    }
                })
            }
        });

        $("#stage-header .edit-pelanggan").on("click", function() {
            $("#tampil_form").load("<?= route('sales_activity.kanban.detail.perusahaan.form', ['id' => $id]) ?>", function() {
                $("#modal_form .modal-dialog").addClass("modal-lg");
                $("#modal_form").modal("show");
                $("#modal_form .title").text("<?= $this->lang->line('title_form_edit_data') ?>");
            });
        });
    });
</script>
<style>
    #detail-perusahaan label {
        color: grey;
    }

    .text-biru {
        color: #1c77d4;
    }

    .dark-dropdown-item:hover,
    .dark-dropdown-item:focus {
        color: #ffffff;
        text-decoration: none;
        background-color: rgb(42 46 48 / 40%);
    }

    .dark-dropdown-item {
        display: block;
        width: 100%;
        padding: 0.25rem 1.5rem;
        clear: both;
        font-weight: 400;
        color: #ffffff;
        text-align: inherit;
        white-space: nowrap;
        background-color: transparent;
        border: 0;
    }
</style>
<div class="position-sticky bg-white" style="top: 0; z-index: 1000;">
    <div id="stage-header">
        <?php
        $task_lock = false;
        if (($pipeline->tahun . '-' . $pipeline->bulan) !== date('Y-m')) {
            $task_lock = true;
        } elseif ($pipeline->status === 'pengajuan' && $pipeline->jenis === 'incoming') {
            $task_lock = true;
        } elseif ($pipeline->status === 'approve' && in_array($pipeline->jenis, ['wont', 'lost'])) {
            $task_lock = true;
        }
        ?>
        <div class="d-flex justify-content-between align-items-center">
            <div class="btn-group">
                <a href="#" class="btn btn-secondary disabled font-weight-bold" data-old="<?= $pipeline->tahapan ?>" <?= 'style="background-color: ' . ($pipeline->warna ? $pipeline->warna . ';color:' . $pipeline->warna_text . ';opacity: 1;' : '#BABFC7;') . 'border: none;"' ?> role="button" aria-disabled="true"><?= $pipeline->tahapan ?: '-' ?></a>
                <?php if (($task_lock === false) && ($pipeline->id_karyawan === $this->id_karyawan)) : ?>
                    <button type="button" class="btn btn-secondary dropdown-toggle-split rounded-right" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fa fa-chevron-down"></i>
                    </button>
                    <div class="dropdown-menu bg-secondary">
                        <h6 class="dropdown-header text-center text-white">Move to stage</h6>
                        <div class="dropdown-divider"></div>
                        <?php foreach ($tahapan as $tahap) : ?>
                            <?php if ($pipeline->id_tahapan_m != $tahap->id_tahapan_m) : ?>
                                <a data-tahapan="<?= $tahap->id_tahapan_m ?>" data-jenis="<?= $tahap->jenis ?>" class="move-tahapan dark-dropdown-item d-flex" href="javascript:void(0)"><span class="badge badge-pill mr-1" style="<?= 'background-color:' . $tahap->warna . ';' ?> width: 20px; height: 20px"> </span> <?= $tahap->nama ?></a>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
            <?php if (($task_lock === false) && ($pipeline->id_karyawan === $this->id_karyawan)) : ?>
                <div class="btn-group pr-2">
                    <a href="javascript:void(0)" class="text-light" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fa fa-ellipsis-h"></i></a>
                    <div class="dropdown-menu">
                        <a href="javascript:void(0)" class="edit-pelanggan dropdown-item"><i class="fa fa-edit text-warning"></i> Edit Pelanggan</a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div class="hidden">
            <span class="custom-loader" style="margin: 0.34rem 1rem"></span>
        </div>
    </div>
    <hr>
</div>
<div>
    <div class="form-group pb-1">
        <h6 class="font-weight-bold mb-1 text-biru">Data <?= ($pipeline->kategori_pelanggan == 'perusahaan') ? 'Perusahaan' : 'Personal' ?></h6>
        <div class="row">
            <div class="col-12">
                <label>Nama <?= ($pipeline->kategori_pelanggan == 'perusahaan') ? 'Perusahaan' : '' ?></label>
                <p class="font-weight-bold"><?= $pipeline->nama_perusahaan ?: '-' ?></p>
            </div>
            <div class="col-6">
                <label>Jenis <?= ($pipeline->kategori_pelanggan == 'perusahaan') ? 'Perusahaan' : 'Perorangan' ?></label>
                <p class="font-weight-bold"><?= $pipeline->jenis_perusahaan ?: '-' ?></p>
            </div>
            <div class="col-6">
                <label>Lead Source</label>
                <p class="font-weight-bold"><?= $pipeline->lead_source ?: '-' ?></p>
            </div>
        </div>
    </div>
    <div class="form-group pb-1">
        <h6 class="font-weight-bold mb-1 text-biru"><?= $this->lang->line('alamat') ?></h6>
        <div class="row">
            <div class="col-12">
                <label><?= $this->lang->line('alamat') ?></label>
                <p class="font-weight-bold"><?= htmlspecialchars($pipeline->alamat) ?: '-' ?></p>
            </div>
            <div class="col-6">
                <label><?= $this->lang->line('provinsi') ?></label>
                <p class="font-weight-bold"><?= $pipeline->provinsi ?: '-' ?></p>
            </div>
            <div class="col-6">
                <label><?= $this->lang->line('kota') ?></label>
                <p class="font-weight-bold"><?= $pipeline->kota ?: '-' ?></p>
            </div>
            <div class="col-6">
                <label><?= $this->lang->line('kecamatan') ?></label>
                <p class="font-weight-bold"><?= $pipeline->kecamatan ?: '-' ?></p>
            </div>
            <div class="col-6">
                <label><?= $this->lang->line('kelurahan') ?></label>
                <p class="font-weight-bold"><?= $pipeline->kelurahan ?: '-' ?></p>
            </div>
        </div>
    </div>
    <div class="form-group pb-1">
        <h6 class="font-weight-bold mb-1 text-biru"><?= ($pipeline->kategori_pelanggan == 'perusahaan') ? 'Data PIC' : 'Kontak' ?></h6>
        <div class="row">
            <?php if ($pipeline->kategori_pelanggan == 'perusahaan'): ?>
                <div class="col-4">
                    <label><?= $this->lang->line('nama') ?></label>
                    <p class="font-weight-bold"><?= $pipeline->pic_nama ?: '-' ?></p>
                </div>
            <?php endif; ?>
            <div class="<?= ($pipeline->kategori_pelanggan == 'perusahaan') ? 'col-4' : 'col-6' ?>">
                <label><?= $this->lang->line('email') ?></label>
                <p class="font-weight-bold"><?= $pipeline->pic_email ?: '-' ?></p>
            </div>
            <div class="<?= ($pipeline->kategori_pelanggan == 'perusahaan') ? 'col-4' : 'col-6' ?>">
                <label><?= $this->lang->line('no_telp') ?></label>
                <p class="font-weight-bold"><?= $pipeline->pic_telp ?: '-' ?></p>
            </div>
        </div>
    </div>
    <?php if ($pipeline->id_karyawan !== $this->id_karyawan) : ?>
        <div class="form-group pb-1">
            <h6 class="font-weight-bold mb-1 text-biru">Data Sales</h6>
            <div class="row">
                <div class="col-4">
                    <label><?= $this->lang->line('nama') ?></label>
                    <p class="font-weight-bold"><?= $pipeline->sales_nama ? $pipeline->sales_nama : ltrim(explode('-', $pipeline->user_input)[1]) ?></p>
                </div>
                <div class="col-4">
                    <label><?= $this->lang->line('email') ?></label>
                    <p class="font-weight-bold"><?= $pipeline->sales_email ?: '-' ?></p>
                </div>
                <div class="col-4">
                    <label><?= $this->lang->line('no_telp') ?></label>
                    <p class="font-weight-bold"><?= $pipeline->sales_telp ?: '-' ?></p>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <div class="form-group pb-1">
        <h6 class="font-weight-bold mb-1 text-biru">Deskripsi</h6>
        <div class="row">
            <div class="col-12">
                <label>Judul</label>
                <p class="font-weight-bold"><?= htmlspecialchars($pipeline->title) ?: '-' ?></p>
            </div>
            <div class="col-12">
                <label><?= $this->lang->line('keterangan') ?></label>
                <p class="font-weight-bold"><?= htmlspecialchars($pipeline->keterangan) ?: '-' ?></p>
            </div>
        </div>
    </div>
</div>
