<?php

/**
 * CLI Routes
 *
 * This routes only will be available under a CLI environment
 */

// To enable Luthier-CI built-in cli commands
// uncomment the followings lines:

// Luthier\Cli::maker();
// Luthier\Cli::migrations();

Route::group('crontab', function () {
    Route::group('absensi', function () {
        Route::cli('reguler', 'Crontab@reguler');
        Route::cli('reguler-limit/{offset}/{limit}', 'Crontab_reguler@by_limit');
        Route::cli('alpha/reguler', 'Crontab@alpha'); # ALPA TIDAK MASUK KERJA DAN JADWAL REQULER MASUK
        Route::cli('alpha/shift', 'Crontab@alpha2'); # ALPA TIDAK MASUK SHIFT DAN JADWAL REQULER LIBUR
        Route::cli('alpha/shift/lewat/hari', 'Crontab@alpha_shift_lewat_hari'); # ALPA TIDAK MASUK SHIFT LEWAT HARI
        Route::cli('libur', 'Crontab@libur');
        Route::cli('libur/nasional', 'Crontab@libur_nasional');
        Route::cli('shift', 'Crontab@shift');
        Route::cli('shift/lewat_hari1', 'Crontab@shift_lewat_hari1'); # BATAS ABSENNSI PULANG LEWAT HARI
        Route::cli('shift/lewat_hari2', 'Crontab@shift_lewat_hari2'); # ABSENNSI PULANG LEWAT HARI
        Route::cli('shift/off', 'Crontab@shift_off');
        Route::cli('pensiun', 'Crontab@pensiun');
        Route::cli('hapus/absensi/masuk', 'Crontab@hapus_absensi_masuk');
        Route::cli('hapus/absensi/istirahat_mulai', 'Crontab@hapus_absensi_istirahat_mulai');
        Route::cli('hapus/absensi/istirahat_selesai', 'Crontab@hapus_absensi_istirahat_selesai');
        Route::cli('hapus/absensi/pulang', 'Crontab@hapus_absensi_pulang');
        Route::cli('hapus/shift/karyawan', 'Crontab@hapus_shift_karyawan');

        Route::cli('migrasi', 'Crontab_migrasi@absensi'); # MIGRASI
        Route::cli('reminder/testing', 'cron/Reminder_absensi@testing');
        Route::cli('reminder/{waktu_mulai}/{waktu_selesai}', 'cron/Reminder_absensi@index');
    });

    Route::cli('insert/jumlah/karyawan', 'Crontab@insert_data_dashbord'); # INSERT JUMLAH KARYAWAN
});

//crontab
Route::group('cron', function () {
    Route::cli('reset_ct_by_join_date', 'cron/Saldo_cuti@reset_cuti_1');
    Route::cli('reset_ct_by_month', 'cron/Saldo_cuti@reset_cuti_2');
    Route::cli('carry_forward_hangus_by_join_date', 'cron/Saldo_cuti@reset_cuti_carry_forward_1');
    Route::cli('carry_forward_hangus_by_month', 'cron/Saldo_cuti@reset_cuti_carry_forward_2');
    // Route::cli('test', function () {
    //     echo 'test';
    // });
});

//migration
Route::cli('migrate', 'Migrate@index');

// sales activity
Route::cli('set_target_poin', 'sales_activity/report/realisasi_poin/Crontab@set_target_poin');

if(ENVIRONMENT == 'development') {
    Route::group('testing', function() {
        Route::group('pengajuan', function() {
            Route::group('data-diri', function() {
                Route::cli('', 'testing/Pengajuan_data_diri@pengajuan');
            });
            Route::group('kelengkapan-file', function() {
                Route::cli('', 'testing/Pengajuan_kelengkapan_file@pengajuan');
            });
            Route::group('data-keluarga', function() {
                Route::cli('', 'testing/Pengajuan_data_keluarga@pengajuan');
            });
            Route::group('data-sertifikat', function() {
                Route::cli('', 'testing/Pengajuan_data_sertifikat@pengajuan');
            });
            Route::group('pengalaman-kerja', function() {
                Route::cli('', 'testing/Pengajuan_pengalaman_kerja@pengajuan');
            });
            Route::group('riwayat-pendidikan', function() {
                Route::cli('', 'testing/Pengajuan_riwayat_pendidikan@pengajuan');
            });
        });
    });
}