<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Bpjs_tk_m extends CI_Model {

	public function __construct(){
		parent::__construct();

        $this->id_company = $this->session->userdata('id_company');
	}

	public function get_config() {
		$this->db->from('payroll_bpjs_tk_comp_p');
		$this->db->where('id_company', $this->session->userdata('id_company'));
		return $this->db->get()->row();
	}

	public function save($flag) {
		$name = $this->input->post('name');

		$this->db->trans_start();
		$this->save_pengaturan($name, $flag);
		$this->save_master($name, $flag);
		$this->update_total();
		$this->db->trans_complete();
		return $this->db->trans_status();
	}

	private function save_pengaturan($name, $flag) {
		$this->db->set($name, $flag);
		$this->db->set('user_update', $this->session->userdata('nik').'-'.$this->session->userdata('nama_user'));
		$this->db->set('tgl_update', date('Y-m-d H:i:s'));
		$this->db->where('id_company', $this->session->userdata('id_company'));
		$this->db->update('payroll_bpjs_tk_comp_p');
	}

	private function save_master($name, $flag) {
		$cols = flag_map($name);
		foreach($cols as $col) {
			if($flag == '1') {
				$this->db->set($col.'_rp', 'cast(ttl_gaji_terdaftar as decimal(9,2))*('.$col.'_persen/100)', FALSE);
			} else {
				$this->db->set($col.'_rp', 0.00);
			}
		}
		$this->db->set('user_update', $this->session->userdata('nik').'-'.$this->session->userdata('nama_user'));
		$this->db->set('tgl_update', date('Y-m-d H:i:s'));
		$this->db->where('id_company', $this->session->userdata('id_company'));
		$this->db->update('payroll_bpjs_tk_m');
	}

	public function cek_data($id_karyawan) {
        $this->db->where('id_karyawan', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get('payroll_bpjs_tk_m')->num_rows();
    }

    public function get_data($id_karyawan) {
        $this->db->where('md5(id_karyawan)', $id_karyawan);
        $this->db->where('id_company', $this->id_company);
        return $this->db->get('payroll_bpjs_tk_m')->row();
    }

    private function update_total() {
    	$sql = "UPDATE payroll_bpjs_kes_m 
    			JOIN payroll_bpjs_tk_m ON payroll_bpjs_kes_m.id_karyawan = payroll_bpjs_tk_m.id_karyawan AND payroll_bpjs_kes_m.id_company = payroll_bpjs_tk_m.id_company 
    			SET ttl_pot_karyawan = IF(payroll_bpjs_kes_m.flag = '1', payroll_bpjs_kes_m.pot_kry_rp, 0)+
    					IF(payroll_bpjs_tk_m.flag_jht = '1', payroll_bpjs_tk_m.pot_jht_kry_rp, 0)+
    					IF(payroll_bpjs_tk_m.flag_jp = '1', payroll_bpjs_tk_m.pot_jp_kry_rp, 0), 
    				ttl_tunj_dibiayai_perus = IF(payroll_bpjs_kes_m.flag = '1', payroll_bpjs_kes_m.tunj_perus_rp, 0)+
    					IF(payroll_bpjs_tk_m.flag_jht = '1', payroll_bpjs_tk_m.tunj_jht_perus_rp, 0)+
    					IF(payroll_bpjs_tk_m.flag_jkk = '1', payroll_bpjs_tk_m.tunj_jkk_rp, 0)+
    					IF(payroll_bpjs_tk_m.flag_jkm = '1', payroll_bpjs_tk_m.tunj_jkm_rp, 0)+
    					IF(payroll_bpjs_tk_m.flag_jp = '1', payroll_bpjs_tk_m.tunj_jp_perus_rp, 0) 
    			WHERE payroll_bpjs_kes_m.id_company = ?";
    	$this->db->query($sql, array($this->id_company));
    }

	public function save_nominal() {
		$name  = $this->input->post('name');
		$temp  = $this->input->post('value_temp');
		$value = str_replace(',', '.', $this->input->post('value'));
		if($temp == $value) {
			return true;
		} elseif($value == '') {
			return false;
		} else {
			$this->db->trans_start();
			$this->save_pengaturan_nominal($name, $value);
			$this->save_master_nominal($name, $value);
			$this->update_total();
			$this->db->trans_complete();
			return $this->db->trans_status();
		}
	}

	private function save_pengaturan_nominal($name, $value) {
		if($value == '') {
			$this->db->set($name, 0.00);
		} else {
			$this->db->set($name, $value);
		}
		$this->db->set('user_update', $this->session->userdata('nik').'-'.$this->session->userdata('nama_user'));
		$this->db->set('tgl_update', date('Y-m-d H:i:s'));
		$this->db->where('id_company', $this->session->userdata('id_company'));
		$this->db->update('payroll_bpjs_tk_comp_p');
	}

	private function save_master_nominal($name, $value) {
		if($value == '') {
			$this->db->set($name.'_persen', 0.00);
			$this->db->set($name.'_rp', 0.00);
		} else {
			$this->db->set($name.'_persen', $value);
			$this->db->set($name.'_rp', 'cast(ttl_gaji_terdaftar as decimal(9,2))*('.$value.'/100)', FALSE);
		}
		$this->db->set('user_update', $this->session->userdata('nik').'-'.$this->session->userdata('nama_user'));
		$this->db->set('tgl_update', date('Y-m-d H:i:s'));
		$this->db->where('id_company', $this->session->userdata('id_company'));
		$this->db->update('payroll_bpjs_tk_m');
	}

}