<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Bagan_organisasi_m extends CI_Model {

    public function data_cabang(){
        $this->db->select('mc.id_cabang,
                            mc.nama AS nm_cabang');
        $this->db->from("master_cabang AS mc");
        $this->db->where('mc.id_company',$this->id_company);
        $this->db->order_by('mc.nama ASC');
        $select = $this->db->get();

        if($select->num_rows() > 1){
            $data = $select->result();

            $result = [];
            foreach($data as $row){
                $kacab = $this->_kepala_cabang($row->id_cabang);
                $nm_cabang = "<div class='box-org'>".$row->nm_cabang."</div>";
                $result[]=[
                            'name'     => (empty($kacab['name']))?'':$kacab['name'],
                            'title'    => (empty($kacab['title']))?'&nbsp;'.$nm_cabang:$kacab['title'].$nm_cabang,
                            'children' => $this->_data_departemen($row->id_cabang)
                        ];
            }
        }else{
            $row = $select->row();
            $kacab = $this->_kepala_cabang($row->id_cabang);
            $nm_cabang = "<div class='box-org'>".$row->nm_cabang."</div>";
            $result[]=[
                        'name'     => (empty($kacab['name']))?'':$kacab['name'],
                        'title'    => (empty($kacab['title']))?'&nbsp;'.$nm_cabang:$kacab['title'].$nm_cabang,
                        'children' => $this->_data_departemen($row->id_cabang)
            ];
        }

        return $result;
    }

    private function _data_departemen($id_cabang = ''){
        $this->db->select('md.id_departemen,
                            md.nama');
        $this->db->from("master_departemen as md");
        $this->db->join("data_karyawan AS dk","dk.id_departemen = md.id_departemen");
        $this->db->where('md.id_company',$this->id_company);
        $this->db->where('dk.id_cabang',$id_cabang);
        $this->db->where_in('dk.status',['1','2','3','4']);
        $this->db->group_by('CONCAT(dk.id_cabang,dk.id_departemen)');
        $this->db->order_by('md.nama ASC');
        $select = $this->db->get();

        if($select->num_rows() > 1){
            $data = $select->result();
            $result = [];
            foreach($data as $row){
                $kedep = $this->_kepala_departemen($id_cabang, $row->id_departemen);
                $nm_departemen = "<div class='box-org'>".$row->nama."</div>";
                $result[]= [
                            'name'     => (empty($kedep['name']))?'':$kedep['name'],
                            'title'    => (empty($kedep['title']))?'&nbsp'.$nm_departemen:$kedep['name'].$nm_departemen,
                            'children' => $this->_data_staff($id_cabang, $row->id_departemen)
                        ];
            }
        }else{
            $row = $select->row();
            $kedep = $this->_kepala_departemen($row->id_cabang, $row->id_departemen);
            $nm_departemen = "<div class='box-org'>".$row->nama."</div>";
            $result[]=[
                        'name'     => (empty($kedep['name']))?'':$kedep['name'],
                        'title'    => (empty($kedep['title']))?'&nbsp'.$nm_departemen:$kedep['name'].$nm_departemen,
                        'children' => $this->_data_staff($id_cabang, $row->id_departemen)
            ];
        }

        return $result;
    }


    // private function _data_departemen($id_cabang = ''){
    //     $this->db->select('md.id_departemen,
    //                         md.nama');
    //     $this->db->from("master_departemen as md");
    //     $this->db->join("p_kedep as kedep","kedep.id_departemen = md.id_departemen");
    //     $this->db->join("data_karyawan AS dk","dk.id_karyawan = kedep.id_karyawan");
    //     $this->db->where('md.id_company',$this->id_company);
    //     $this->db->where('dk.id_cabang',$id_cabang);
    //     $this->db->group_by('CONCAT(dk.id_cabang,dk.id_departemen)');
    //     $this->db->order_by('md.nama ASC');
    //     $select = $this->db->get();

    //     if($select->num_rows() > 1){
    //         $data = $select->result();
    //         $result = [];
    //         foreach($data as $row){
    //             $kedep = $this->_kepala_departemen($id_cabang, $row->id_departemen);
    //             $nm_departemen = "<div class='box-org'>".$row->nama."</div>";
    //             $result[]= [
    //                         'name'     => (empty($kedep['name']))?'':$kedep['name'],
    //                         'title'    => (empty($kedep['title']))?'&nbsp'.$nm_departemen:$kedep['name'].$nm_departemen,
    //                         'children' => $this->_data_staff($id_cabang, $row->id_departemen)
    //                     ];
    //         }
    //     }else{
    //         $row = $select->row();
    //         $kedep = $this->_kepala_departemen($row->id_cabang, $row->id_departemen);
    //         $nm_departemen = "<div class='box-org'>".$row->nama."</div>";
    //         $result[]=[
    //                     'name'     => (empty($kedep['name']))?'':$kedep['name'],
    //                     'title'    => (empty($kedep['title']))?'&nbsp'.$nm_departemen:$kedep['name'].$nm_departemen,
    //                     'children' => $this->_data_staff($id_cabang, $row->id_departemen)
    //         ];
    //     }

    //     return $result;
    // }

    public function data_direksi(){
        $this->db->select('dk.nama_lengkap as nm_karyawan,
                            mj.kode_jabatan AS kode_jabatan,
                            mj.nama AS nm_jabatan');
        $this->db->from('data_karyawan AS dk');
        $this->db->join("master_jabatan AS mj","mj.id_jabatan = dk.id_jabatan");
        $this->db->where('dk.id_company',$this->id_company);
        $this->db->where_in('dk.status',['1','2','3','4']);
        $this->db->where('mj.level_user','4');
        $this->db->order_by('mj.kode_jabatan ASC');
        $select = $this->db->get();

        $nm_karyawan = "";
        $title       = "Direksi";
        if($select->num_rows() > 1){
            $data_karyawan = $select->result();

            $no = 0;
            foreach($data_karyawan as $row){
                $no++;

                if($no > 1){
                    $style="margin-left:20px";
                }else{
                    $style="margin-left:5px";
                }

                $nm_karyawan .= "<span title='".$row->nm_karyawan."' style='".$style."'>".$row->kode_jabatan." - ".$row->nm_karyawan."</span><br>";
            }
        }else{
            $row = $select->row();

            $nm_karyawan .= $row->nm_karyawan;
            $title        = (empty($row->nm_cabang))?"Direksi":$row->nm_jabatan;
        }


        $data=[
                'name'     => $nm_karyawan,
                'title'    => $title
            ];

        return $data;
    }
    public function _kepala_cabang($id_cabang = ''){
        $this->db->select('dk.nama_lengkap as nm_karyawan,
                            mj.kode_jabatan AS kode_jabatan,
                            mj.nama AS nm_jabatan');
        $this->db->from('data_karyawan AS dk');
        $this->db->join("master_jabatan AS mj","mj.id_jabatan = dk.id_jabatan");
        $this->db->join("p_kacab AS kacab","kacab.id_karyawan = dk.id_karyawan");
        $this->db->where('dk.id_company',$this->id_company);
        $this->db->where('kacab.id_cabang',$id_cabang);
        $this->db->where_in('dk.status',['1','2','3','4']);
        $this->db->where('mj.level_user','5');
        $this->db->order_by('mj.kode_jabatan ASC');
        $select = $this->db->get();

        $nm_karyawan = "";
        $title       = "Kepala Cabang";
        if($select->num_rows() > 1){
            $data_karyawan = $select->result();

            $no = 0;
            foreach($data_karyawan as $row){
                $no++;

                if($no > 1){
                    $style="margin-left:20px";
                }else{
                    $style="margin-left:5px";
                }

                $nm_karyawan .= "<span title='".$row->nm_karyawan."' style='".$style."'>".$row->kode_jabatan." - ".$row->nm_karyawan."</span><br>";
            }


        }else{
            $row = $select->row();

            $nm_karyawan .= $row->nm_karyawan;
            $title        = $row->nm_jabatan;
        }
        $data=[
                'name'     => $nm_karyawan,
                'title'    => $title
            ];

        return $data;
    }

    public function _kepala_departemen($id_cabang = '', $id_departemen = ''){
        $this->db->select('dk.nama_lengkap as nm_karyawan,
                            mj.kode_jabatan AS kode_jabatan,
                            mj.nama AS nm_jabatan');
        $this->db->from('data_karyawan AS dk');
        $this->db->join("master_jabatan AS mj","mj.id_jabatan = dk.id_jabatan");
        $this->db->join("p_kedep AS kedep","kedep.id_karyawan = dk.id_karyawan");
        $this->db->where('dk.id_company',$this->id_company);
        $this->db->where('kedep.id_cabang',$id_cabang);
        $this->db->where('kedep.id_departemen',$id_departemen);
        $this->db->where_in('dk.status',['1','2','3','4']);
        $this->db->where('mj.level_user','2');
        $this->db->order_by('mj.kode_jabatan ASC');
        $select = $this->db->get();

        $nm_karyawan = "";
        $title       = "";
        if($select->num_rows() > 1){
            $data_karyawan = $select->result();

            $no = 0;
            foreach($data_karyawan as $row){
                $no++;

                if($no > 1){
                    $style="margin-left:20px";
                }else{
                    $style="margin-left:5px";
                }

                $nm_karyawan .= "<span title='".$row->nm_karyawan."' style='".$style."'>".$row->kode_jabatan." - ".$row->nm_karyawan."</span><br>";
            }
        }else{
            $row = $select->row();

            $nm_karyawan .= $row->nm_karyawan;
            $title        = $row->nm_jabatan;
        }


        $data=[
                'name'     => $nm_karyawan,
                'title'    => $title
            ];

        return $data;
    }

    private function _data_staff($id_cabang = '', $id_departemen = ''){
        $this->db->select('dk.id_karyawan,
                            dk.nama_lengkap as nm_karyawan,
                            mj.nama as nm_jabatan,
                            mj.level_user');
        $this->db->from('data_karyawan AS dk');
        $this->db->join("master_jabatan AS mj","mj.id_jabatan = dk.id_jabatan");
        $this->db->where('dk.id_company',$this->id_company);
        $this->db->where('dk.id_cabang',$id_cabang);
        $this->db->where('dk.id_departemen',$id_departemen);
        $this->db->where_in('dk.status',['1','2','3','4']);
        $this->db->where('dk.supervisi','');
        $this->db->where_in('mj.level_user',['3','7']);
        $this->db->order_by('mj.level_user DESC, mj.nama ASC, dk.nik ASC');
        $select = $this->db->get();


        if($select->num_rows() > 1){
            $data = $select->result();

            $result = [];
            foreach($data as $row){
                $result[]=[
                            'name'     => (empty($row->nm_karyawan))?"&nbsp;":$row->nm_karyawan,
                            'title'    => (empty($row->nm_jabatan))?"&nbsp;":$row->nm_jabatan,
                            'children' => ($row->level_user == '7')?$this->_data_bawahan_spv($row->id_karyawan):[]
                        ];
            }
        }else{
            $row = $select->row();

            $result[] = [
                            'name'     => (empty($row->nm_karyawan))?"&nbsp;":$row->nm_karyawan,
                            'title'    => (empty($row->nm_jabatan))?"&nbsp;":$row->nm_jabatan,
                            'children' => ($row->level_user == '7')?$this->_data_bawahan_spv($row->id_karyawan):[]
                        ];
        }
        return $result;
    }
    private function _data_bawahan_spv($id_spv = ''){
        $this->db->select('dk.nama_lengkap as nm_karyawan,
                            mj.nama as nm_jabatan');
        $this->db->from('data_karyawan AS dk');
        $this->db->join("master_jabatan AS mj","mj.id_jabatan = dk.id_jabatan");
        $this->db->where('dk.id_company',$this->id_company);
        $this->db->where_in('dk.status',['1','2','3','4']);
        $this->db->where('dk.supervisi',$id_spv);
        $this->db->where_in('mj.level_user',['3','7']);
        $this->db->order_by('dk.id_jabatan ASC','dk.nik ASC');
        $select = $this->db->get();

        if($select->num_rows() > 1){
            $data = $select->result();

            $result = [];
            foreach($data as $row){
                $result[]=[
                            'name'     => (empty($row->nm_karyawan))?"&nbsp;":$row->nm_karyawan,
                            'title'    => (empty($row->nm_jabatan))?"&nbsp;":$row->nm_jabatan
                        ];
            }
        }else{
            $row = $select->row();
            $result[] = [
                            'name'     => (empty($row->nm_karyawan))?"&nbsp;":$row->nm_karyawan,
                            'title'    => (empty($row->nm_jabatan))?"&nbsp;":$row->nm_jabatan
                        ];
        }
        return $result;
    }
}