<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Realisasi_nominal extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('sales_activity/report/Realisasi_nominal_m', 'model');
    }

    public function view_data()
    {
        $this->load->view('sales_activity/report/realisasi_nominal/view_data');
    }

    public function view_diagram()
    {
        $this->load->view('sales_activity/report/realisasi_nominal/view_diagram');
    }

    private function sumArray($listArray, $iFrom, $iTo)
    {
        $sum = [];
        for ($i = $iFrom; $i <= $iTo; $i++) {
            $sum[$i] = array_sum($listArray[$i]);
        }
        return array_values($sum);
    }

    public function list_data_diagram()
    {
        $tahun                = $this->input->get('tahun');
        $id_group             = $this->input->get('id_group');
        $nm_group             = $this->input->get('nm_group');
        $id_karyawan          = $this->input->get('id_karyawan');
        $nm_karyawan          = $this->input->get('nm_karyawan');
        $targ_tahunan_bulanan = $this->model->get_target_tahunan_bulanan($tahun, $id_group);
        $target_personil      = $this->model->get_target_personil($tahun, $id_group, $id_karyawan);
        $list                 = $this->model->get_datatables($tahun, $id_group, $id_karyawan);

        $data = [];
        foreach ($list as $field) {
            for ($i = 1; $i <= 12; $i++) {
                $key_target = $field->id_karyawan . $tahun . sprintf("%02d", $i) . $this->id_company;
                $res        = array_search($key_target, array_column($target_personil, 'key_target'));
                $res        = ($res !== false) ? $target_personil[$res] : null;

                $nominal_target       = !empty($res['nominal_target']) ? $res['nominal_target'] : '0';
                $data['target'][$i][] = $nominal_target;

                $nominal_realisasi       = !empty($res['nominal_realisasi']) ? $res['nominal_realisasi'] : '0';
                $data['realisasi'][$i][] = $nominal_realisasi;
            }
        }

        $data['total_realisasi']       = $this->sumArray($data['realisasi'], 1, 12);
        $data['total_target_personal'] = $this->sumArray($data['target'], 1, 12);

        if ($id_karyawan == "all") {
            foreach ($targ_tahunan_bulanan as $value) {
                $data['total_target_tahunan'][] = (int)$value['tahunan'];
                $data['total_target_kuartal'][] = (int)$value['kuartal'];
                $data['total_target_bulanan'][] = (int)$value['bulanan'];
            }
        }

        $data['title'] = ucwords(strtolower('Report Nominal, Group/Area : '.$nm_group.', Sales : '.$nm_karyawan));

        $maxNominal = [
            max(array_map('max', $data['target'])),
            max(array_map('max', $data['realisasi'])),
            max($data['total_target_tahunan'] ?: 0),
            max($data['total_target_kuartal'] ?: 0),
            max($data['total_target_bulanan'] ?: 0),
        ];
        $data['max'] = max($maxNominal);

        echo json_encode($data);
    }

    public function list_data()
    {
        $tahun                = $this->input->get('tahun');
        $id_group             = $this->input->get('id_group');
        $id_karyawan          = $this->input->get('id_karyawan');
        $target_personil      = $this->model->get_target_personil($tahun, $id_group, $id_karyawan);
        $total                = $this->_get_total_target_and_realisasi($target_personil);
        $targ_tahunan_bulanan = $this->model->get_target_tahunan_bulanan($tahun, $id_group);

        $list  = $this->model->get_datatables($tahun, $id_group, $id_karyawan);
        $data  = array();
        $no    = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = $field->nama_lengkap . "<br><b>" . $field->nik . "</b>";

            for ($i = 1; $i <= 12; $i++) {
                $key_target = $field->id_karyawan . $tahun . sprintf("%02d", $i) . $this->id_company;
                $res        = array_search($key_target, array_column($target_personil, 'key_target'));
                $res        = ($res !== false) ? $target_personil[$res] : null;

                $nominal_target = !empty($res['nominal_target']) ? $res['nominal_target'] : '0';
                $row[]          = number_format($nominal_target, 0, ",", ".");

                $nominal_realisasi = !empty($res['nominal_realisasi']) ? $res['nominal_realisasi'] : '0';
                $row[]             = number_format($nominal_realisasi, 0, ",", ".");
            }

            $row[]  = 'no-colspan';
            $data[] = $row;
        }

        // Start Footer Total Target Personil
        $row   = array();
        $row[] = "<B>Total Target Personil<B>";
        $row[] = "";
        for ($i = 1; $i <= 12; $i++) {
            $t_target    = $total[sprintf("%02d", $i)]['target'];
            $t_realisasi = $total[sprintf("%02d", $i)]['realisasi'];
            $row[]       = '<B>' . number_format($t_target, 0, ",", ".") . '</B>';
            $row[]       = '<B>' . number_format($t_realisasi, 0, ",", ".") . '</B>';
        }

        $row[]  = 'colspan-t-realisasi';
        $data[] = $row;
        // End Footer Total Target Personil


        // Start Footer Total Target Tahunan, Kuartal & Bulanan
        $row_t_tahunan   = array();
        $row_t_tahunan[] = "<B>Target Tahunan<B>";
        $row_t_tahunan[] = "";

        $row_t_kuartal   = array();
        $row_t_kuartal[] = "<B>Target Kuartal<B>";
        $row_t_kuartal[] = "";

        $row_t_bulanan   = array();
        $row_t_bulanan[] = "<B>Target Bulanan<B>";
        $row_t_bulanan[] = "";

        foreach ($targ_tahunan_bulanan as $targ_bt) {
            $row_t_tahunan[] = '<B>' . number_format($targ_bt['tahunan'],  0, ",", ".") . '</B>';
            $row_t_tahunan[] = "";

            $row_t_kuartal[] = '<B>' . number_format($targ_bt['kuartal'], 0, ",", ".") . '</B>';
            $row_t_kuartal[] = "";

            $row_t_bulanan[] = '<B>' . number_format($targ_bt['bulanan'], 0, ",", ".") . '</B>';
            $row_t_bulanan[] = "";
        }

        $row_t_tahunan[] = "colspan-t-tahunan-bulanan";
        $row_t_kuartal[] = "colspan-t-tahunan-bulanan";
        $row_t_bulanan[] = "colspan-t-tahunan-bulanan";

        $data[] = $row_t_bulanan;
        $data[] = $row_t_kuartal;
        $data[] = $row_t_tahunan;
        // End Footer Total Target Tahunan, Kuartal & Bulanan

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($tahun, $id_group, $id_karyawan),
            "recordsFiltered" => $this->model->count_filtered($tahun, $id_group, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);
        echo json_encode($output);
    }

    public function download()
    {
        $tahun       = $this->input->get('tahun');
        $id_group    = $this->input->get('id_group');
        $nm_group    = $this->input->get('nm_group');
        $id_karyawan = $this->input->get('id_karyawan');
        $nm_karyawan = $this->input->get('nm_karyawan');
        $id_karyawan = ($id_karyawan != "null") ? $id_karyawan : "";

        $filename = "Sales Monitoring - Laporan Nominal Tahun ".$tahun." ".$nm_group." ".$nm_karyawan;
        $header = "Sales Monitoring - Laporan Nominal ".$nm_group." ".$nm_karyawan;

        $data['tahun']                = $tahun;
        $data['header']               = $header;
        $data['list']                 = $this->model->get_datatables($tahun, $id_group, $id_karyawan);
        $data['target_personil']      = $this->model->get_target_personil($tahun, $id_group, $id_karyawan);
        $data['targ_tahunan_bulanan'] = $this->model->get_target_tahunan_bulanan($tahun, $id_group);

        $output  = true;
        $sb_view = $this->load->view('sales_activity/report/realisasi_nominal/download', $data, $output);

        // START FORMAT COLUMN
        $format_columns = [
            'A'  => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
            'B'  => ['width' => 20, 'align' => 'left', 'valign' => 'middle', 'format' => 'text'],
            'C'  => ['width' => 30, 'align' => 'left', 'valign' => 'middle'],
        ];

        for ($i = 4; $i <= (12 * 2) + 4; $i++) {
            $alphabet = $this->_numberToLetters($i);
            $alphabet = strtoupper($alphabet);

            $format_columns[$alphabet] = [
                'width'  => 15,
                'align'  => 'right',
                'valign' => 'middle',
                'rupiah' => 'true'
            ];
        }
        // END FORMAT COLUMN

        // Bold Header & Footer Table
        $bold_footer = COUNT($data['list']) + 6;
        $thead = ['4', '5', strval($bold_footer), strval($bold_footer + 1), strval($bold_footer + 2), strval($bold_footer + 3)];

        // Align Column Midle
        $align_column_2   = "D" . strval($bold_footer + 1) . ":AA" . strval($bold_footer + 3);
        $align_column_arr = ["D4:AA5", $align_column_2];

        $param = [
            'download'    => true,
            'cLength'     => 24 + 2,
            'file_name'   => strtoupper($filename),
            'paper_size'  => 'LEGAL',
            'font-size'   => 11,
            'page_margin' => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation' => 'landscape',
            'header'      => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
            ],
            'freezecolumn' => ['D6'],
            'thead'        => $thead,
            'tbody'        => [
                'start'  => '4',
                'height' => 15,
                'wrap'   => ['B', 'C', 'D', 'E'],
                'column' => $format_columns,
            ],
            'align_column_unit' => [
                ['align' => 'center', 'column' => $align_column_arr]
            ]
        ];

        $this->load->library('PHPExcel/Excel');

        if ($output) {
            $this->excel->generateExcel($sb_view, $param);
        }
        exit;
    }

    public function dropdown_nama_group($tahun="all")
    {
        $search = $this->input->get("q");
        return $this->model->dropdown_nama_group($tahun, $search);
    }

    public function dropdown_karyawan()
    {
        $tahun    = $this->input->get("tahun");
        $id_group = $this->input->get("id_group");
        $search   = $this->input->get("q");
        return $this->model->dropdown_karyawan($tahun, $id_group, $search);
    }

    private function _numberToLetters($number)
    {
        $letters = '';
        while ($number > 0) {
            $mod     = ($number - 1) % 26;
            $letters = chr(97 + $mod) . $letters;
            $number  = floor(($number - 1) / 26);
        }
        return $letters;
    }

    private function _get_total_target_and_realisasi($data_target =  []){
        $total = array();
        for ($i=1; $i <= 12; $i++) {
            $total[sprintf("%02d", $i)] = array(
                'bulan'     => sprintf("%02d", $i),
                'target'    => 0,
                'realisasi' => 0,
            );
        }

        foreach($data_target as $value){
            $total[$value['bulan']]['target']    += $value['nominal_target'];
            $total[$value['bulan']]['realisasi'] += $value['nominal_realisasi'];
        }

        return $total;
    }
}
