<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Informasi_bank extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model(['karyawan_detail/Informasi_bank_m' => 'model', 'karyawan_detail/Informasi_karyawan_m' => 'karyawan']);
    }

    public function index($id_karyawan = null)
    {
        $data['data']        = $this->karyawan->get_data_diri_by_id($id_karyawan);
        $data['id_karyawan'] = $id_karyawan;
        $this->load->view('karyawan/payroll/informasi_bank/index', $data);
    }

    public function form($column, $id_karyawan)
    {
        $default = $this->karyawan->get_data_by_data_karyawan($column, $id_karyawan);

        $data['column']      = $column;
        $data['id_karyawan'] = $id_karyawan;
        $data['default']     = $default;

        $this->load->view('karyawan/payroll/informasi_bank/form', $data);
    }

    public function save()
    {
        // def
        $id_karyawan = $this->input->post('id_karyawan');
        $column      = $this->input->post('column');
        $value       = $this->input->post('value');
        $value_old   = $this->input->post('value_old');

        // decrypt karyawan
        $id_karyawan = $this->fungsi->decrypt_idkaryawan($id_karyawan);

        // validasi
        if ($value === $value_old) return __response_update(true);
        if (!$id_karyawan) return __response_update(false, ['message' => '<i class="fa fa-close"></i> Karyawan tidak ditemukan']);
        if (!$column) return __response_update(false, ['message' => '<i class="fa fa-close"></i> Gagal simpan data, silakan muat ulang halaman']);
        if ($column == 'bank_rek') {
            if (!is_numeric($value)) return __response_update(false, ['message' => '<i class="fa fa-close"></i> No. Rekening harus berupa angka']);
        }

        $set   = [$column => $value];
        $where = ['id_karyawan' => $id_karyawan];

        // update data
        $this->model->save($set, $where);
    }
}
