<?php
defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Dashboard_absensi extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Dashboard_absensi_m');
        $this->load->model('Dashboard_m');
    }

    public function index($id_cabang = 0, $id_shift = 0)
    {
        $data['judul'] = $this->lang->line('title_absensi_hari_ini');
        $data['aktif'] = 'dashboard';

        $tanggal = date('Y-m-d');
        $data['level_user']       = $this->level_user;
        $data['multi_cabang']     = $this->multi_cabang;
        $data['multi_departemen'] = $this->multi_departemen;

        $cabang_selected = $this->db->select("id_cabang,kode,nama")
            ->from("master_cabang")
            ->where("id_cabang", $id_cabang)
            ->where("id_company", $this->id_company)
            ->get()
            ->row();

        $data['cabang_selected'] = $cabang_selected;
        $data['id_cabang']       = $id_cabang;

        $shift_selected = $this->db->select("id_master_shift, kode_shift, nama_shift")
            ->from("master_shift")
            ->where("id_master_shift", $id_shift)
            ->where("id_company", $this->id_company)
            ->get()
            ->row();
        $data['shift_selected'] = $shift_selected;
        $data['id_shift']       = $id_shift;

        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('dashboard_absensi/main', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function view_data($cabang = "all", $departemen = "all", $jadwal = "all", $status = 0)
    {
        $data['judul']      = $this->lang->line('title_absensi_hari_ini');
        $data['aktif']      = 'dashboard';
        $data['cabang']     = $cabang;
        $data['departemen'] = $departemen;
        $data['jadwal']     = $jadwal;
        $data['status']     = $status;
        $usergroup          = $this->session->userdata('level_user');
        $data['export']     = $this->export($usergroup);
        $this->load->view('dashboard_absensi/list_data', $data, false);
    }

    public function list_data($cabang = 0, $departemen = 0, $jadwal = 0, $status = 0)
    {
        $tanggal = date('Y-m-d');
        $jenis   = $this->input->get('jenis');

        $list = $this->Dashboard_absensi_m->get_datatables($cabang, $departemen, $jadwal, $status);
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;

            $row = array();
            $row[] = $no;

            $foto_masuk  = $this->config->item('base_image') . 'image?_t=photo&_d=' . $field->foto_masuk;
            $foto_pulang = $this->config->item('base_image') . 'image?_t=photo&_d=' . $field->foto_pulang;

            $row[] = $field->nama_karyawan . "<br><b>" . $field->nik . "</b>";
            $row[] = $field->nama_cabang."<br>".$field->nama_departemen;
            $row[] = '<a href="'.$foto_masuk.'" data-lightbox="mulai-'.$no.'"><img src="'.$foto_masuk.'" width="100px" height="100px"></a><br>';
            $row[] = $this->list_informasi($field->kode_absen, $this->fungsi->konversi_datetime($field->absen_masuk), 'masuk', $field->terlambat, $field->id_absensi_masuk, $field->gmt, $field->lokasi_absen, $field->ket_absen_masuk);

            if(empty($field->absen_pulang)){
                $row[] = '-';
            }else{
                $row[] = '<a href="'.$foto_pulang.'" data-lightbox="selesai-'.$no.'"><img src="'.$foto_pulang.'" width="100px" height="100px"></a>';
            }

            $row[] = $this->list_informasi($field->kode_absen, $this->fungsi->konversi_datetime($field->absen_pulang), 'pulang', $field->pulang_cepat, $field->id_absensi_pulang, $field->gmt_pulang, $field->lokasi_absen_pulang, $field->ket_absen_pulang);

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Dashboard_absensi_m->count_all($cabang, $departemen, $jadwal, $status),
            "recordsFiltered" => $this->Dashboard_absensi_m->count_filtered($cabang, $departemen, $jadwal, $status),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    function list_informasi($kode_absen, $jam, $jenis, $terlambat, $id, $gmt, $lokasi_absen, $keterangan)
    {
        if ($jam != '00-00-0000 00:00:00') {
            if ($jenis == 'masuk') {
                if ($id != '') {
                    if ($terlambat > 0) {
                        $lb_terlambat = '</br><label class="text-danger font-weight-bold"> T ' .$terlambat. ' menit</label>';
                    } else {
                        $lb_terlambat = '';
                    }

                    if ($keterangan != '') {
                        $info_keterangan = '</br><i class="fa fa-pencil-square-o" aria-hidden="true"></i> '.$keterangan;
                    }else{
                        $info_keterangan = '';
                    }

                    $button = '<i class="fa fa-calendar-check-o" aria-hidden="true"></i> '.date_format(date_create($jam), 'd-m-Y') . '<br> <b><i class="fa fa-clock-o" aria-hidden="true"></i> ' . date_format(date_create($jam), 'H:i:s') . ' ' . $this->fungsi->_gmt($gmt) . $lb_terlambat . '</b> <br> <i class="fa fa-map-marker" aria-hidden="true"></i> '.$lokasi_absen.$info_keterangan.'<br><a class="btn btn-primary" href="' . site_url('dashboard/absensi/detail/lokasi/masuk/' . $id) . '" target="_blank">Detail</a>';
                } else {
                    $button = $jam;
                }
            } else {
                if ($id != '') {
                    if ($terlambat > 0) {
                        $lb_terlambat = '</br><label class="text-danger font-weight-bold">PC ' .$terlambat. ' menit</label>';
                    } else {
                        $lb_terlambat = '';
                    }

                    if ($keterangan != '') {
                        $info_keterangan = '</br><i class="fa fa-pencil-square-o" aria-hidden="true"></i> '.$keterangan;
                    }else{
                        $info_keterangan = '';
                    }

                    $button = '<i class="fa fa-calendar-check-o" aria-hidden="true"></i> '.date_format(date_create($jam), 'd-m-Y') . '<br> <b><i class="fa fa-clock-o" aria-hidden="true"></i> ' . date_format(date_create($jam), 'H:i:s') .' ' . $this->fungsi->_gmt($gmt) . $lb_terlambat . '</b> <br><i class="fa fa-map-marker" aria-hidden="true"></i> '.$lokasi_absen.$info_keterangan.'<br><a class="btn btn-secondary" href="' . site_url('dashboard/absensi/detail/lokasi/pulang/' . $id) . '" target="_blank">Detail</a>';
                } else {
                    $button = $jam;
                }
            }
        } else {
            $button = '';
        }

        return $button;
    }

    function data_dashboard($id_cabang = "all", $id_departemen = "all", $id_shift = "all", $status = "all")
    {

        $hadir       = $this->Dashboard_absensi_m->count_filtered($id_cabang, $id_departemen, $id_shift, 'H');
        $terlambat   = $this->Dashboard_absensi_m->count_filtered($id_cabang, $id_departemen, $id_shift, 'T');
        $belum_absen = $this->Dashboard_absensi_m->count_filtered($id_cabang, $id_departemen, $id_shift, 'A');
        $izin        = $this->Dashboard_absensi_m->count_filtered($id_cabang, $id_departemen, $id_shift, 'I');
        $sakit       = $this->Dashboard_absensi_m->count_filtered($id_cabang, $id_departemen, $id_shift, 'S');
        $cuti        = $this->Dashboard_absensi_m->count_filtered($id_cabang, $id_departemen, $id_shift, 'C');

        $json = array(
            "hadir"       => $hadir,
            "terlambat"   => $terlambat,
            "belum_absen" => $belum_absen,
            "izin"        => $izin,
            "cuti"        => $cuti,
            "sakit"       => $sakit,
            "total"       => $jumlah_pegawai
        );

        $json = __response($this->MY_response, $json);

        echo json_encode($json);
    }

    function export($usergroup)
    {
        if ($usergroup == 1) {
            $button = "<a id='export' class='btn btn-success' href='" . site_url('dashboard/absensi/detail/excel') . "'><i class='fa fa-file-excel-o'></i> Export</a>";
        } else {
            $button = "";
        }
        return $button;
    }

    function excel()
    {
        $this->load->library(array('PHPExcel/Excel', 'PHPExcel/PHPExcel'));
        $filename     = "Belum Absen";
        $tanggal      = date("Y-m-d");
        $data['data'] = $this->Dashboard_absensi_m->export($tanggal);
        $sb_view      = $this->load->view('dashboard_absensi/export', $data, true);
        $param        = [
            'download'  => true,
            'cLength'   => (2),
            'file_name' => $filename,
            'header'    => [
                '1' => ['merge' => true, 'align' => 'center'],
                '2' => ['merge' => true, 'align' => 'center']
            ],
            'thead' => ['2'],
            'tbody' => [
                'start'  => '3',
                'column' => [
                    'A' => ['align' => 'left', 'width' => 5],
                    'B' => ['align' => 'left', 'width' => 35],
                    'C' => ['align' => 'left', 'width' => 60]
                ],
            ]
        ];
        $this->excel->generateExcel($sb_view, $param);
    }

    function list_absensi()
    {
        $key = $this->input->get("q");

        $json[] = ['id' => 'H', 'text' => strtoupper($this->lang->line('hadir'))];
        $json[] = ['id' => 'T', 'text' => strtoupper($this->lang->line('terlambat'))];
        $json[] = ['id' => 'I', 'text' => strtoupper($this->lang->line('izin'))];
        $json[] = ['id' => 'C', 'text' => strtoupper($this->lang->line('cuti'))];
        $json[] = ['id' => 'S', 'text' => strtoupper($this->lang->line('sakit'))];
        $json[] = ['id' => 'A', 'text' => strtoupper($this->lang->line('belum_absen'))];

        echo json_encode($json);
    }

    function lokasi($jenis, $id)
    {
        $data['judul'] = $this->lang->line($jenis);
        $data['aktif'] = 'dashboard';
        $data_lokasi   = $this->Dashboard_absensi_m->lokasi($jenis, $id);
        $data['data']  = $data_lokasi;
        $this->load->library('googlemaps/Googlemaps');
        $config = array();
        $config['center']     = $data_lokasi->latitude . ',' . $data_lokasi->longitude;
        $config['zoom']       = 18;
        $config['map_height'] = "400px";
        $this->googlemaps->initialize($config);

        $marker = array();
        $marker['position'] = $data_lokasi->latitude . "," . $data_lokasi->longitude;
        $marker['title']    = $data_lokasi->lokasi_absen;
        $this->googlemaps->add_marker($marker);

        $data['map'] = $this->googlemaps->create_map();
        $foto             = $this->config->item('base_image') . 'image?_t=absensi&_d=' . $data_lokasi->foto;
        $data['foto']     = $foto;
        $data['menu']     = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('dashboard_absensi/lokasi', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data_absen($cabang = 0, $departemen = 0, $jadwal = 0, $status = 0)
    {
        $tanggal = date('Y-m-d');
        $jenis = $this->input->get('jenis');

        $list = $this->Dashboard_absensi_m->get_datatables($cabang, $departemen, $jadwal, $status);
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;

            $row = array();
            $row[] = $no;

            $foto = $this->config->item('base_image') . 'imagebiodata?_t=photo&_d=' . $field->foto_masuk;

            $row[] = '<a href="'.$foto.'" data-lightbox="mulai-'.$no.'"><img src="'.$foto.'" width="100px" height="100px"></a>';
            $row[] = $field->nama_karyawan . "<br><b>" . $field->nik . "</b>";
            $row[] = $field->nama_cabang . "<br><b>" . $field->kode_cabang . "</b>";
            $row[] = $field->nama_departemen . "<br><b>" . $field->kode_departemen . "</b>";
            $row[] = $field->nama_jabatan . "<br><b>" . $field->kode_jabatan . "</b>";
            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Dashboard_absensi_m->count_all($cabang, $departemen, $jadwal, $status),
            "recordsFiltered" => $this->Dashboard_absensi_m->count_filtered($cabang, $departemen, $jadwal, $status),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }
}
