<div class="table-responsive mt-2">
    <div id="data-actions" class="pull-right ml-1">
        <button id="download" type="button" class="btn btn-primary ladda-button" disabled data-style="expand-left">
            <i class="fa fa-download"></i> <?= $this->lang->line('button_unduh') ?>
        </button>
    </div>
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th rowspan="2" class="text-center align-middle">NO</th>
                <th rowspan="2" class="text-center align-middle">KARYAWAN</th>
                <th colspan="<?= COUNT($table_header) ?>" class="text-center align-middle">AKTIVITAS</th>
            </tr>
            <tr>
                <?php foreach ($table_header as $value) { ?>
                    <th class="text-center align-middle text-uppercase"><?= $value->nama_aktivitas ?></th>
                <?php } ?>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>

<script>
    $(function () {
        list_data = $('#list_data').DataTable({
            'searching': false,
            'searchDelay': 1000,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            'fixedColumns': {
                leftColumns: 2
            },
            'language': {
                <?php if ($this->code_lang == 'id'): ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Nama karyawan'
                <?php else: ?> 'searchPlaceholder': 'Employees Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "layout": {
                "topEnd": [
                    $("#data-actions")
                ]
            },
            "ajax": {
                "url": "<?= route('sales_activity.report.aktivitas.data.list') ?>",
                "type": "GET",
                "data": function (d) {
                    delete d.columns;
                    d.periode_mulai = $(".filter #periode_mulai").val();
                    d.periode_selesai = $(".filter #periode_selesai").val();
                    d.id_group = !$(".filter #id_group").val() ? 'all' : $(".filter #id_group").val();
                    d.id_karyawan = !$(".filter #id_karyawan").val() ? 'all' : $(".filter #id_karyawan").val();
                },
                "complete": function (data) {
                    $("#download").prop("disabled", false);
                    reconfigure(data);
                    screenUp(200);
                }
            },
            "aoColumnDefs": [{
                render: function (data, type, full, meta) {
                    return "<div style='text-wrap:wrap !important; width:200px'>" + data + "</div>";
                },
                targets: 1
            }],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });

                for (var i = 2; i <= <?= COUNT($table_header) + 1 ?>; i++) {
                    $('td:eq(' + i + ')', nRow).css({
                        'text-align': 'center'
                    });
                }

                // Footer Total
                if (aData[i] == "colspan") {
                    $("td:eq(1)", nRow).css({
                        'display': 'none'
                    });
                    $(nRow).children('td:eq(0)').attr('colspan', 2);

                    $('td:eq(0)', nRow)
                        .css({
                            'text-align': 'center',
                            'background-color': '#1c77d4',
                            'color': '#fff',
                            'border-top': '1px solid #fff',
                            'border-right': '1px solid #fff'
                        });

                    for (var i = 2; i <= <?= COUNT($table_header) + 1 ?>; i++) {
                        $('td:eq(' + i + ')', nRow).css({
                            'background-color': '#ccedff',
                            'color': '#000',
                            'border-top': '1px solid #fff',
                            'border-right': '1px solid #fff'
                        });
                    }
                }
            },
        });

        $("#download").click(function () {

            let periode_mulai = $(".filter #periode_mulai").val();
            let periode_selesai = $(".filter #periode_selesai").val();
            let id_group = !$(".filter #id_group").val() ? 'all' : $(".filter #id_group").val();
            let nm_group = !$(".filter #id_group").val() ? 'Semua Group' : $(".filter #id_group").select2('data')[0]['nm-group'];
            let id_karyawan = !$(".filter #id_karyawan").val() ? 'all' : $(".filter #id_karyawan").val();
            let nm_karyawan = !$(".filter #id_karyawan").val() ? 'Semua Sales' : $(".filter #id_karyawan").select2('data')[0]['nm-karyawan'];

            urlExcel = "<?= route('sales_activity.report.aktivitas.data.download') ?>" +
                '?periode_mulai=' + periode_mulai +
                '&periode_selesai=' + periode_selesai +
                '&id_group=' + id_group +
                '&nm_group=' + nm_group +
                '&id_karyawan=' + id_karyawan +
                '&nm_karyawan=' + nm_karyawan;
            downloadFile(urlExcel, this);
        });
    });
</script>