<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=<?= $this->config->item('api_map_key') ?>&sensor=false<?= $preview->flag_lokasi == '1' ? '&callback=initMap' : '' ?>"></script>
<script type="text/javascript">
    var map;

    function initMap() {
        map = new google.maps.Map(document.getElementById('map'), {
            center: {
                lat: <?= $preview->lat ?: 0 ?>,
                lng: <?= $preview->long ?: 0 ?>
            },
            zoom: 16,
            mapTypeId: google.maps.MapTypeId.ROADMAP
        });

        var marker = new google.maps.Marker({
            position: {
                lat: <?= $preview->lat ?: 0 ?>,
                lng: <?= $preview->long ?: 0 ?>
            },
            map: map,
            animation: google.maps.Animation.DROP,
        });
    }

    $(function() {
        $("#btn_approve").on("click", function(e) {
            e.preventDefault();
            verify_approval(this, "<?= route('sales_activity.approval_activity.verification.approve') ?>");
        });

        $("#btn_reject").on('click', function(e) {
            e.preventDefault();
            verify_approval(this, "<?= route('sales_activity.approval_activity.verification.reject') ?>");
        });
    });

    function verify_approval(e, route) {
        var loading = Ladda.create(e);
        var is_selected = $("#list_data").find("[data-id='<?= $id ?>']").closest('tr').hasClass("selected");

        var param = {};
        param.tabel = "<?= $tabel ?>";
        param.id = "<?= $id ?>";
        param.kategori = "<?= $preview->kategori ?>";

        $.ajax({
            type: "POST",
            url: route,
            data: param,
            dataType: "JSON",
            beforeSend: function() {
                loading.start();
                $("#modal_form button").prop("disabled", true);
            },
            success: function(result) {
                loading.stop();
                $("#modal_form button").prop("disabled", false);
                if (result.success == true) {
                    showMsg(result.message);
                    if (is_selected) {
                        set_selected_rows(param.tabel + "_" + param.id, "remove");
                    }
                    list_data.ajax.reload();
                } else {
                    showMsg(result.message, true, 2000);
                }
            },
            error: function() {
                loading.stop();
                $("#modal_form button").prop("disabled", false);
                showMsg("error", false);
            }
        });
    }
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>

<div id="detail-aktivitas-preview" class="card-body">
    <div class="form-group">
        <div class="row">
            <div class="col-12">
                <h6>Tahapan saat ini</h6>
                <p class="font-weight-bold">
                    <?= $preview->tahapan_sekarang ?>
                </p>
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-6">
                <h6>Pelanggan</h6>
                <p class="font-weight-bold"><?= $preview->nama_perusahaan ?></p>
            </div>
            <div class="col-6">
                <h6>Lead Source</h6>
                <p class="font-weight-bold"><?= htmlspecialchars($preview->nama_lead_source) ?: '-' ?></p>
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-6">
                <h6><?= $this->lang->line('tgl') ?> aktivitas</h6>
                <p class="font-weight-bold">
                    <?php
                    if (!empty($preview->waktu)) {
                        if ($this->code_lang == 'id') {
                            echo indo_date(strtotime($preview->waktu), 'l, d M  Y  H:i');
                        } else {
                            echo date('l, d M  Y  H:i', strtotime($preview->waktu));
                        }
                    } else {
                        echo '-';
                    }
                    ?>
                </p>
            </div>
            <div class="col-6">
                <h6>Dibuat oleh</h6>
                <p class="font-weight-bold"><?= ltrim(explode('-', $preview->user)[1]) ?></p>
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-6">
                <h6>Aktivitas</h6>
                <?php
                if ($preview->kategori === 'move') {
                    $aktivitas = explode(',', $preview->aktivitas_pindah_bulan);
                    $aktivitas = '<i class="text-warning">' . $aktivitas[0] . '</i> ' . $aktivitas[1] . ' <i class="fa fa-long-arrow-right"></i> ' . $aktivitas[2];
                } else {
                    if ($preview->aktivitas == 'Move') {
                        $aktivitas = '<i class="text-warning">' . $preview->aktivitas . '</i> ' . $preview->tahapan_sebelum . ' <i class="fa fa-long-arrow-right"></i> ' . $preview->tahapan_sekarang;
                    } elseif ($preview->aktivitas == 'New') {
                        $aktivitas = '<i class="text-primary">' . $preview->aktivitas . '</i> ' . $preview->tahapan_sekarang;
                    } else {
                        $aktivitas = $preview->aktivitas;
                    }
                }
                ?>
                <p class="font-weight-bold"><?= $aktivitas ?: '-' ?></p>
            </div>
            <div class="col-6">
                <h6>Poin</h6>
                <p class="font-weight-bold"><?= ($preview->poin != '') ? number_format($preview->poin, 0, ',', '.') : '-'; ?></p>
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <div class="col-12">
                <h6>Keterangan</h6>
                <p class="font-weight-bold"><?= htmlspecialchars(($preview->kategori === 'move') ? $preview->keterangan : ($preview->aktivitas_pindah_bulan ?: $preview->keterangan)) ?: '-' ?></p>
            </div>
        </div>
    </div>
    <div class="form-group">
        <div class="row">
            <?php if ($preview->flag_lokasi == '1') : ?>
                <div class="col-6">
                    <h6>Lokasi</h6>
                    <div id="map" style="width:100%; height:200px;"></div>
                </div>
            <?php endif; ?>
            <?php if ($preview->flag_upload_foto == '1') : ?>
                <div class="col-6">
                    <h6>Foto</h6>
                    <?php
                    $foto = $this->config->item('base_image') . 'image?_t=absensi&_d=' . $preview->path_foto;
                    ?>
                    <a href="<?= $foto ?>" data-lightbox="image_activity"><img src="<?= $foto ?>" height="200"></a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="card-footer">
    <div class="w-100 text-right">
        <button id="btn_reject" class="btn btn-danger text-white w-25 ladda-button" data-style="zoom-in"><i class="fa fa-times"></i> <?= $this->lang->line('button_form_tolak') ?></button>
        <button id="btn_approve" class="btn btn-primary w-25 ladda-button" data-style="zoom-in"><i class="fa fa-check"></i> <?= $this->lang->line('button_form_approve') ?></button>
    </div>
</div>
