<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div class="col d-flex align-items-center"><h4 class="text-primary">KPI Team</h4></div>
                <div class="col text-right" id="message_kpi"></div>
            </div>
            <hr class="mb-2">
            <form action="">
                <div class="form-group row">
                    <label for="periode" class="col-sm-2 form-label"><?= $this->lang->line('periode') ?></label>
                    <div class="col-sm-3">
                        <input type="text" name="periode" id="periode" class="form-control">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="karyawan" class="col-sm-2 form-label"><?= $this->lang->line('karyawan') ?></label>
                    <div class="col-sm-3">
                        <select name="karyawan" id="karyawan" class="form-control"></select>
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-primary ladda-button" data-style="expand-left" id="filter" onclick="filterData();">Filter</button>
                    </div>
                </div>
            </form>
            <table class="table table-striped table-bordered">
                <thead>
                    <tr style="font-family: Poppins SemiBold;">
                        <th class="no_sort align-middle _center" width=50 height=50>No</th>
                        <th class="align-middle"><?= $this->lang->line('nama') ?></th>
                        <th class="align-middle" width=250><?= $this->lang->line('jabatan') ?></th>
                        <th width=250 class="no_sort _center align-middle"><?= $this->lang->line('periode') ?></th>
                        <th class="no_sort _center align-middle" width=200>Status</th>
                        <th class="no_sort _center align-middle" width=150><?= $this->lang->line('aksi') ?></th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>
<script>
    $(function() {
        $('#periode').datepicker({
            format     : "MM yyyy",
            minViewMode: 1,
            autoclose  : true,
            orientation: "bottom",
            language   : "id"
        });
        
        const ls_menu_kpi = localStorage.getItem("menu_kpi");
        let menu_kpi;
        let displayStart = 0;
        let pageLength   = 10;
        if(ls_menu_kpi !== undefined) {
            menu_kpi = JSON.parse(ls_menu_kpi);
            if(menu_kpi.hasOwnProperty("filter")) {
                $('#periode').datepicker('setDate', new Date(menu_kpi.filter.periode));
                displayStart = 10*menu_kpi.filter.page;
                pageLength   = menu_kpi.filter.length;
            } else {
                $('#periode').datepicker('setDate', new Date());
            }
        } else {
            $('#periode').datepicker('setDate', new Date());
        }

        $('#periode').datepicker().on('changeDate', function() {
            select2Karyawan();
        });
        select2Karyawan();
        if(ls_menu_kpi !== undefined) {
            if(menu_kpi.hasOwnProperty("filter")) {
                if(menu_kpi.filter.hasOwnProperty("karyawan")) {
                    var option = new Option(menu_kpi.filter.karyawan.selected, menu_kpi.filter.karyawan.value, true, true);
                    $('#karyawan').append(option).trigger('change');
                }

                delete menu_kpi.filter;
                localStorage.setItem("menu_kpi", JSON.stringify(menu_kpi));
            }
        }

        list_data = $('table').DataTable({
            displayStart: displayStart,
            pageLength  : pageLength,
            searching   : false,
            language    : {
                url: '<?= $this->code_lang == 'id' ? base_url("assets/plugins/datatables/dataTables-language-id.json") : "" ?>'
            },
            order: [],
            ordering: false,
            columnDefs: [
                { targets: 'no_sort', orderable: false },
                { targets: '_center', className: "text-center" },
            ],
            processing: true,
            serverSide: true,
            ajax      : {
                url : '<?= route("kpi.team.list.data") ?>',
                data: function(d) {
                    delete d.columns;
                    delete d.search;
                    
                    const waktu = $('#periode').datepicker('getDate');
                    d.tahun    = waktu.getFullYear();
                    d.bulan    = waktu.getMonth()+1;
                    d.karyawan = $('#karyawan').val();
                }
            },
            drawCallback: function(settings) {
                $('#message_kpi').html('');
                $('#message_kpi').html(this.api().ajax.json().validasiPeriode);
            }
        });
    });

    function select2Karyawan() {
        const waktu = $('#periode').datepicker('getDate');
        const tahun = waktu.getFullYear();
        const bulan = waktu.getMonth()+1;
        $('#karyawan').select2({
            placeholder: '<?= $this->lang->line("pilih_karyawan") ?>',
            allowClear: true,
            ajax: {
                url: '<?= route("dropdown.kpi.bawahan")  ?>',
                data: function(params) {
                    const query = {
                        search: params.term,
                        tahun : tahun,
                        bulan : bulan
                    };

                    return query;
                },
                dataType: 'json',
                processResults: function(data) {
                    return {
                        results: data
                    };
                }
            }
        });
    }

    function filterData() {
        event.preventDefault();
        var loading = Ladda.create(document.querySelector('#filter'));
        loading.start();
        list_data.ajax.reload(function() {
            loading.stop();
        });
    }
</script>