<script type="text/javascript">
    $(function() {
        $.fn.dataTableExt.sErrMode = 'none';
        list_data = $('#list_data').on('error.dt', function(e, settings, techNote, message) {
            if (confirm('Terjadi kesalahan saat memproses data, muat ulang halaman ?')) {
                window.location.reload();
            }
        }).DataTable({
            'searching': true,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language': {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Kode/Nama'
                <?php else : ?> 'searchPlaceholder': 'Code/Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('master.jenisizin.listdata') ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                    "aTargets": [0],
                    "bSortable": false
                }
                <?php
                if (in_array($this->session->userdata('level_user'), array("1")) || in_array($this->session->userdata('level_user'), array("1"))) {
                ?>, {
                        "aTargets": [-1],
                        "bSortable": false
                    }

                <?php } ?>
            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });
                $('td:eq(1)', nRow).css({
                    'text-align': 'center',
                    'width': '50px'
                });
                $('td:eq(3), td:eq(4), td:eq(5), td:eq(6), td:eq(7), td:eq(8), td:eq(9)', nRow).css({
                    'text-align': 'center'
                });

                <?php
                if (in_array($this->session->userdata('level_user'), array("1")) || in_array($this->session->userdata('level_user'), array("1"))) {
                ?>

                    $('td:eq(-1)', nRow).css({
                        'text-align': 'center',
                        'width': '100px'
                    });

                <?php } ?>
            }

        });

        $(document).on('click', '.btn_tambah', function() {
            $('#tampil_form').load("<?= route('master.jenisizin.form.tambah') ?>", function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_tambah_data') ?>");
                $(".btn_save").addClass("btn_save btn btn-primary");
                $(".btn_save").append('<i class="fa fa-save"></i> ');
                $(".btn_save").append('<?= $this->lang->line('button_form_simpan') ?>');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click', '.btn_edit', function() {
            $('#tampil_form').load("<?= route('master.jenisizin.form.edit') ?>" + "/" + $(this).attr('id'), function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_edit_data') ?>");
                $(".btn_save").addClass("btn_save btn btn-warning");
                $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
                $(".btn_save").append('<?= $this->lang->line('button_form_perbarui') ?>');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click', '.btn_delete', function() {
            $('#tampil_form').load("<?= route('master.jenisizin.form.hapus') ?>" + "/" + $(this).attr('id'), function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
                $('#form_input input[type=text]').prop("disabled", true);
                $('#form_input input[type=number]').prop("disabled", true);
                $('#form_input input[type=checkbox]').prop("disabled", true);
                $("#jenis_izin, #flag, #flag_kalender").prop("disabled", true);
                $(".btn_save").append('<i class="fa fa-trash"></i> ');
                $(".btn_save").append('<?= $this->lang->line('button_form_hapus') ?>');
                $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            });
        });

        $(document).on('click', '#btn_new_input', function() {
            $('#form_input input[type=text]').prop("disabled", false);
            $("#form_input input[type=text]").val('');

            $('#form_input input[type=number]').prop("disabled", false);
            $("#form_input input[type=number]").val('');

            $("#jenis_izin, #flag, #flag_kalender").prop("disabled", false);
            $("#jenis_izin").val('');
            $("#flag, #flag_kalender").val(0);

            $('#form_input input[type=checkbox]').prop("disabled", false);
            $("#form_input input[type=checkbox]").prop('checked', false);

            $('.btn_save').show();
            $('#btn_new_input').hide();
            $('#message').hide();
        });

        $(document).on("click", ".btn_save", function(e) {
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);

            if ($("#kd_jenis_izin").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_kode_jenis_izin') ?></font>");
                $("#kd_jenis_izin").focus();
                return false;
            } else if ($("#jenis_izin").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_jenis_izin') ?></font>");
                $('#jenis_izin').focus();
                return false;
            } else if ($("#nm_jenis_izin").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_nama_jenis_izin') ?></font>");
                $('#nm_jenis_izin').focus();
                return false;
            } else if ((!$("#file_0").is(":checked")) && (!$("#file_1").is(":checked"))) {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_file_jenis_izin') ?></font>");
                return false;
            }

            loading.start();

            var param = {};
            param.id_jenis_izin = $("#id_jenis_izin").val();
            param.kd_jenis_izin = $("#kd_jenis_izin").val();
            param.kd_jenis_izin_old = $("#kd_jenis_izin_old").val();
            param.kd_jenis_izin = $("#kd_jenis_izin").val();
            param.nm_jenis_izin = $("#nm_jenis_izin").val();
            param.jenis_izin = $("#jenis_izin").val();
            param.max_izin = $("#max_izin").val();
            param.back_date = $("#back_date").val();
            param.flag = $("#flag").val();
            param.flag_kalender = $("#flag_kalender").val();
            param.file_0 = $("#file_0").is(":checked");
            param.file_1 = $("#file_1").is(":checked");

            $.ajax({
                type: 'POST',
                url: "<?= route('master.jenisizin.save') ?>",
                data: param,
                dataType: 'JSON',
                success: function(result) {
                    if (result.success == true) {
                        if (result.type == 'save') {
                            $("#form_input :input").prop("disabled", true);
                            $('.btn_save').hide();
                            $('#btn_new_input').show();
                        }
                        $("#kd_jenis_izin_old").val($("#kd_jenis_izin").val());
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });

        // PROSES DELETE
        $(document).on('click', '.btn_hapus', function() {
            var loading = Ladda.create(this);
            loading.start();
            $.ajax({
                type: 'POST',
                url: "<?= route('master.jenisizin.delete') ?>",
                data: 'id_jenis_izin=' + $("#id_jenis_izin").val(),
                dataType: 'JSON',
                success: function(result) {
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message.replace("#009900", "#ffffff"));

                },
                error: function() {
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
                }
            });
        });

    });
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_master_data') ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <?php
            if (in_array($this->session->userdata('level_user'), array("1")) || in_array($this->session->userdata('level_user'), array("1"))) {
            ?>
                <div class="float-md-right">
                    <button type="button" class="btn_tambah btn btn-biru">
                        <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?>
                    </button>
                </div>
            <?php
            }
            ?>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="table-responsive">
                <table id="list_data" class="table table-striped" style="width:100%">
                    <thead>
                        <tr>
                            <th class="align-middle">NO</th>
                            <th class="align-middle"><?= $this->lang->line('kode') ?></th>
                            <th class="align-middle text-uppercase"><?= $this->lang->line('nama') ?></th>
                            <th class="align-middle text-uppercase"><?= $this->lang->line('jenis_izin') ?></th>
                            <th class="align-middle"><?= $this->lang->line('max_izin') ?><br>(<?= $this->lang->line('hari') ?>)</th>
                            <th class="align-middle"><?= $this->lang->line('kalender') ?></th>
                            <th class="align-middle"><?= $this->lang->line('back_date') ?><br>(<?= $this->lang->line('hari') ?>)</th>
                            <th class="align-middle">FILE UPLOAD</th>
                            <th class="align-middle"><?= $this->lang->line('mengurangi_cuti_tahunan') ?></th>
                            <?php
                            if (in_array($this->level_user, array("1"))) {
                            ?>
                                <th class="text-center align-middle"><?= $this->lang->line('aksi') ?></th>
                            <?php
                            }
                            ?>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->
