
<script type="text/javascript">

    $(".numberbox").keydown(function (e) {
        // Allow: backspace, delete, tab, escape, enter and
        if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110]) !== -1 ||
            // Allow: Ctrl+A
            (e.keyCode == 65 && e.ctrlKey === true) ||
            // Allow: home, end, left, right, down, up
            (e.keyCode >= 35 && e.keyCode <= 40)) {
                // let it happen, don't do anything
                return;
        }
        // Ensure that it is a number and stop the keypress
        if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
            e.preventDefault();
            $("#max_nominal_plafon").focus();
            return false();
        }
    });

    function formatangka(objek) {
        a = objek.value;
        b = a.replace(/[^\d]/g,"");
        c = "";
        panjang = b.length;
        j = 0;
        for (i = panjang; i > 0; i--) {
            j = j + 1;
            if (((j % 3) == 1) && (j != 1)) {
            c = b.substr(i-1,1) + "." + c;
            } else {
            c = b.substr(i-1,1) + c;
            }
        }
        objek.value = c;
    }
    $(document).ready(function() {
        $('#form_input #id_cabang').select2({
            placeholder: 'Pilih Semua',
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: true
            },
            minLength: 3,
        });
    });
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body">
    <input type="hidden" id="id_jenis_plafon" value="<?= ((isset($data->id_jenis_reimbursement))?md5($data->id_jenis_reimbursement):'') ?>">
    <div class="form-group">
        <label>Cabang <i class="text-danger">*</i></label>
        <select id="id_cabang" class="select2 form-control" style="width:100%">
            <option value="0">Pilih Cabang</option>
            <?php
                if(isset($data) && !empty($data->id_cabang)){
                    echo '<option value="'.$data->id_cabang.'" selected>'.$data->kode_cabang.' - '.$data->nama_cabang.'</option>';
                }
            ?>
        </select>
    </div>

    <div class="form-group">
        <label>Kode Plafon <i class="text-danger">*</i></label>
        <input type="text" id="kd_plafon" class="form-control" value="<?= ((isset($data->kode_plafon))?$data->kode_plafon:'') ?>">
    </div>

    <div class="form-group">
        <label>Jenis Plafon <i class="text-danger">*</i></label>
        <input type="text" id="jenis_plafon" class="form-control" placeholder="Makan, Transport, Intertain dll" value="<?= ((isset($data->jenis_plafon))?$data->jenis_plafon:'') ?>">
    </div>

    <div class="form-group">
        <label>Maksimal Nominal Plafon <i class="text-danger">*</i></label>
        <input type="text" id="max_nominal_plafon" class="numberbox form-control" onkeyup="formatangka(this);" value="<?= ((isset($data->max_nominal_plafon))?number_format($data->max_nominal_plafon,0,',','.'):'') ?>">
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none">TAMBAH BARU</button>
            <button class="btn_save ladda-button" data-style="expand-left"></button>
        </div>
    </div><!-- ./row -->
</div>