<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quick_setup_departemen_m extends CI_Model{
  var $table = 'master_departemen';
  public function __construct(){
  parent::__construct();
}

  function get_datatables(){
      $this->_get_datatables_query();
      if($_POST['length'] != -1){
          $this->db->limit($_POST['length'], $_POST['start']);
      }
      $query = $this->db->get();
      return $query->result();
  }

  function count_filtered(){
      $this->_get_datatables_query();
      $query = $this->db->get();
      return $query->num_rows();
  }

  public function count_all(){
      $this->db->select("id_departemen")->from($this->table);
      $this->db->where("id_company",$this->id_company);
      return $this->db->count_all_results();
  }
  private function _get_datatables_query(){
      $this->db->select("id_departemen, kode, nama")->from($this->table);
      $this->db->where("id_company",$this->id_company);

      $column_search = array('kode','nama');
      $i = 0;

      foreach ($column_search as $item){  // looping awal
          if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

              if($i===0){ // looping awal
                  $this->db->group_start();
                  $this->db->like($item, $_POST['search']['value']);
              }else{
                  $this->db->or_like($item, $_POST['search']['value']);
              }

              if(count($column_search) - 1 == $i){
                  $this->db->group_end();
              }
          }
          $i++;
      }

      $column_order = array('kode','nama','');

      if(isset($_POST['order'])){
          $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
      }
      else{
          $order_by = array("kode"=>"DESC");
          $this->db->order_by(key($order_by), $order_by[key($order_by)]);
      }
  }

  function cek_kode($kode) {
    $this->db->where('kode', $kode);
    $this->db->where('id_company', $this->id_company);
    return $this->db->get($this->table)->num_rows();
  }

  function cek_nama($nama) {
    $this->db->where('nama', $nama);
    $this->db->where('id_company', $this->id_company);
    return $this->db->get($this->table)->num_rows();
  }

  function save() {
    $data = array(
      'id_departemen' => $this->fungsi->getNextId($this->table,'id_departemen',$_SESSION['id_company'],3),
      'kode'          => $this->input->post('kode'),
      'nama'          => $this->input->post('nama'),
      'id_company'    => $this->id_company
    );

    $insert = $this->db->insert($this->table, $data);

    if($insert) {
        return __response_save(true);
    }else{
        return __response_save(false);
    }
  }

  function update() {
    $data = array(
      'kode'  => $this->input->post('kode'),
      'nama'  => $this->input->post('nama')
    );

    $this->db->where('id_departemen', $this->input->post('id_departemen'));
    $update = $this->db->update($this->table, $data);

    if($update) {
        return __response_update(true);
    }else{
        return __response_update(false);
    }
  }

  function detail($id_departemen) {
    $this->db->select('id_departemen, kode, nama');
    $this->db->where('id_departemen', $id_departemen);
    return $this->db->get($this->table)->row();
  }

  function delete() {
    $this->db->where("id_departemen",$this->input->post('id_departemen'));
    $delete = $this->db->delete($this->table);

    if($delete) {
        return __response_delete(true);
    }else{
        return __response_delete(false);
    }
  }

  function cek_karyawan() {
    $this->db->where('id_departemen', $this->input->post('id_departemen'));
    return $this->db->get('data_karyawan')->num_rows();
  }
}
