<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Pengaturan_shift_import_m extends CI_Model {
    var $table = 'informasi_gaji_temp';
    public function __construct(){
        parent::__construct();
    }
    function get_datatables(){
        $this->_get_datatables_query();
        if($_POST['length'] != -1){
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $this->_get_datatables_query();
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $this->db->select("data_karyawan.id_karyawan,
                            data_karyawan.nik,
                            data_karyawan.nama_lengkap,
                            master_cabang.id_cabang,
                            master_cabang.kode as kode_cabang,
                            master_cabang.nama as nama_cabang,
                            master_departemen.kode as kode_departemen,
                            master_departemen.nama as nama_departemen,
                            master_jabatan.kode_jabatan,
                            master_jabatan.nama as nama_jabatan");
        $this->db->from("data_shift_karyawan_temp");
        $this->db->join("data_karyawan","data_karyawan.id_karyawan = data_shift_karyawan_temp.id_karyawan");
        $this->db->join("master_cabang","master_cabang.id_cabang = data_karyawan.id_cabang");
        $this->db->join("master_departemen","master_departemen.id_departemen = data_karyawan.id_departemen","LEFT");
        $this->db->join("master_jabatan","master_jabatan.id_jabatan = data_karyawan.id_jabatan");
        $this->db->where("data_shift_karyawan_temp.id_company",$this->id_company);
        $this->db->where("data_shift_karyawan_temp.user_input",$this->id_karyawan);
        $this->db->where("data_shift_karyawan_temp.tanggal !=", '0000-00-00');
        $this->db->group_by("data_shift_karyawan_temp.id_karyawan");

        $column_search = array('data_karyawan.nik',
                                'data_karyawan.nama_lengkap',
                                'master_cabang.kode',
                                'master_cabang.nama',
                                'master_departemen.kode',
                                'master_departemen.nama',
                                'master_jabatan.kode_jabatan',
                                'master_jabatan.nama');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('','data_karyawan.nik','master_cabang.kode','master_departemen.kode','master_jabatan.kode_jabatan');

        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else{
            // $order_by = array("master_cabang.kode"=>"ASC", "master_departemen.kode"=>"ASC", "master_jabatan.kode_jabatan"=>"ASC", "data_karyawan.nik"=>"ASC");
            // $this->db->order_by(key($order_by), $order_by[key($order_by)]);
            $this->db->order_by("master_departemen.kode ASC, master_jabatan.kode_jabatan ASC, data_karyawan.nik ASC");
        }
    }

    public function getDataShift(){
        $this->db->select("data_shift_karyawan_temp.tanggal,
                            data_shift_karyawan_temp.id_karyawan,
                            data_shift_karyawan_temp.flag,
                            IF(master_shift.kode_shift is null,data_shift_karyawan_temp.id_master_shift,master_shift.kode_shift) AS kode_shift",false);
        $this->db->from("data_shift_karyawan_temp");
        $this->db->join("master_shift","master_shift.id_master_shift = data_shift_karyawan_temp.id_master_shift","LEFT");
        $this->db->where("data_shift_karyawan_temp.user_input",$this->id_karyawan);
        $this->db->where("data_shift_karyawan_temp.id_company",$this->id_company);
        $query = $this->db->get()->result();

        foreach($query as $row){
            $data[$row->id_karyawan."-".$row->tanggal] = ["kode_shift"=>$row->kode_shift,"flag"=>$row->flag];
        }
        return $data;
    }

    public function getDataKaryawan($id_cabang="-", $id_departemen="-"){

        if($this->level_user == "7"){
            $this->db->where("data_karyawan.supervisi",$this->id_karyawan);
        }

        if($id_cabang != "-") {
            $this->db->where("data_karyawan.id_cabang",$id_cabang);
        }else{
            if($this->level_user == "5"){
                if($this->multi_cabang== true){
                    $this->db->where_in("data_karyawan.id_cabang",$this->id_cabang_arr);
                }else{
                    $this->db->where("data_karyawan.id_cabang",$this->id_cabang);
                }
            }else if($this->level_user == "2"){
                $this->db->where("data_karyawan.id_cabang",$this->id_cabang);
            }
        }

        if($id_departemen != "-") {
            $this->db->where("data_karyawan.id_departemen",$id_departemen);
        }else{
            if($this->level_user == "2"){
                if($this->multi_departemen == true){
                    $this->db->where_in("data_karyawan.id_departemen",$this->id_departemen_arr);
                }else{
                    $this->db->where_in("data_karyawan.id_departemen",$this->id_departemen);
                }
            }
        }


        $this->db->select("data_karyawan.id_karyawan,
                            data_karyawan.nik,
                            data_karyawan.nama_lengkap,
                            master_cabang.id_cabang,
                            master_cabang.kode as kode_cabang,
                            master_cabang.nama as nama_cabang,
                            master_departemen.kode as kode_departemen,
                            master_departemen.nama as nama_departemen,
                            master_jabatan.kode_jabatan,
                            master_jabatan.nama as nama_jabatan");
        $this->db->from("data_karyawan");
        $this->db->join("master_cabang","master_cabang.id_cabang = data_karyawan.id_cabang");
        $this->db->join("master_departemen","master_departemen.id_departemen = data_karyawan.id_departemen","LEFT");
        $this->db->join("master_jabatan","master_jabatan.id_jabatan = data_karyawan.id_jabatan");
        $this->db->where("data_karyawan.id_company",$this->id_company);
        $this->db->where_in("data_karyawan.status",["1","2","3","8"]);
        $this->db->where_not_in("master_jabatan.level_user",["1","6"]);
        $this->db->order_by("master_departemen.kode ASC, master_jabatan.kode_jabatan ASC, data_karyawan.nik ASC");

        $query = $this->db->get()->result();
        return $query;
    }

    public function masterShift($id_cabang = null){
        $this->db->select("id_master_shift,kode_shift");
        $this->db->from("master_shift");
        $this->db->where("id_cabang",$id_cabang);
        $this->db->where("id_company",$this->id_company);
        $query = $this->db->get()->result();
        $data = [];
        foreach($query as $row){
            $key = strtoupper(strtolower($row->kode_shift));
            $data[$key] = $row->id_master_shift;
        }

        return $data;
    }

    public function getCountPeriodeShift(){
        $this->db->select("id")
                ->from("data_shift_karyawan_temp")
                ->where("id_company",$this->id_company)
                ->where("user_input",$this->id_karyawan)
                ->where("tanggal !=", '0000-00-00');
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function getPeriodeShift(){
        $this->db->select("MIN(tanggal) as tgl_mulai, MAX(tanggal) as tgl_selesai")
                ->from("data_shift_karyawan_temp")
                ->where("id_company",$this->id_company)
                ->where("user_input",$this->id_karyawan)
                ->where("tanggal !=", '0000-00-00');
        $query = $this->db->get();
        return $query->row();
    }

    public function getDataShiftTemp(){
        $this->db->select("id,tanggal,id_karyawan,id_master_shift")
                ->from("data_shift_karyawan_temp")
                ->where("flag","1")
                ->where("id_company",$this->id_company)
                ->where("user_input",$this->id_karyawan)
                ->where("tanggal !=", '0000-00-00');
        $query = $this->db->get();
        return $query->result();
    }

    public function getDataShiftReady($tgl_mulai=null, $tgl_selesai=null){
        $this->db->select("id_shift_karyawan,tanggal,id_karyawan");
        $this->db->from("data_shift_karyawan");
        $this->db->where("tanggal >=",$tgl_mulai);
        $this->db->where("tanggal <=",$tgl_selesai);
        $this->db->where("id_company",$this->id_company);
        $query = $this->db->get()->result();
        $data = [];
        foreach($query as $row){
            $key = $row->id_karyawan."-".$row->tanggal;
            $data[$key] = $row->id_shift_karyawan;
        }

        // echo "<pre>";
		// print_r($data);
        // die();

        return $data;
    }

}