<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Jenis_plafon_m extends CI_Model {
    var $table = 'reimbursement_jenis';

    function get_datatables($cabang = null){
        $this->_get_datatables_query($cabang);
        if($_POST['length'] != -1){
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($cabang = null){
        $this->_get_datatables_query($cabang);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($cabang = null){
        $id_company = $this->session->userdata('id_company');

        if($cabang != 0){
            $this->db->where("reimbursement_jenis.id_cabang",$cabang);
        }
        $this->db->select("master_cabang.nama as nama_cabang,
                        master_cabang.kode as kode_cabang,
                        reimbursement_jenis.id_jenis_reimbursement,
                        reimbursement_jenis.jenis_plafon,
                        reimbursement_jenis.max_nominal_plafon")
                ->join("master_cabang","master_cabang.id_cabang = reimbursement_jenis.id_cabang")
                ->from("reimbursement_jenis")
                ->where('reimbursement_jenis.id_company',$id_company);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query($cabang = null){
        $id_company = $this->session->userdata('id_company');

        if($cabang != 0){
            $this->db->where("reimbursement_jenis.id_cabang",$cabang);
        }
        $this->db->select("master_cabang.nama as nama_cabang,
                        master_cabang.kode as kode_cabang,
                        reimbursement_jenis.id_jenis_reimbursement,
                        reimbursement_jenis.kode_plafon,
                        reimbursement_jenis.jenis_plafon,
                        reimbursement_jenis.max_nominal_plafon")
                ->join("master_cabang","master_cabang.id_cabang = reimbursement_jenis.id_cabang")
                ->from("reimbursement_jenis")
                ->where('reimbursement_jenis.id_company',$id_company);

        $column_search = array('reimbursement_jenis.jenis_plafon','reimbursement_jenis.max_jenis_plafon');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('',
                            'master_cabang.nama',
                            'reimbursement_jenis.jenis_plafon',
                            'reimbursement_jenis.max_nominal_plafon');

        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else{
            $order_by = array("reimbursement_jenis.id_jenis_reimbursement"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id=null){
        $id_company = $this->session->userdata('id_company');
        $select = $this->db->select("master_cabang.nama AS nama_cabang,
                                    master_cabang.kode as kode_cabang,
                                    reimbursement_jenis.id_cabang,
                                    reimbursement_jenis.id_jenis_reimbursement,
                                    reimbursement_jenis.kode_plafon,
                                    reimbursement_jenis.jenis_plafon,
                                    reimbursement_jenis.max_nominal_plafon")
                            ->from("reimbursement_jenis")
                            ->join("master_cabang","master_cabang.id_cabang = reimbursement_jenis.id_cabang")
                            ->where("MD5(reimbursement_jenis.id_jenis_reimbursement) ",$id)
                            ->where("reimbursement_jenis.id_company",$id_company)
                            ->get()
                            ->row();
        return $select;
    }

    public function save($data,$id = null){
        $id_company = $this->session->userdata('id_company');
        $plafon = $data['jenis_plafon'];
        $id_cabang = $data['id_cabang'];
        if($id != null){
            $cek_plafon = $this->db->select("jenis_plafon")
                                    ->from("reimbursement_jenis")
                                    ->where("jenis_plafon",$plafon)
                                    ->where("md5(id_jenis_reimbursement) !=",$id)
                                    ->where("id_cabang",$id_cabang)
                                    ->where("id_company",$id_company)
                                    ->get();
            if ($cek_plafon->num_rows() > 0) {
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Jenis plafon sudah digunakan</font>');
                return __response_update(false,$message);
            }else{
                $this->db->where(array('md5(id_jenis_reimbursement)'=>$id, 'id_company'=>$id_company));
                $update = $this->db->update($this->table,$data);
                return  __response_update($update);
            }


        }else{
            $cek_plafon = $this->db->select("jenis_plafon")
                                    ->from("reimbursement_jenis")
                                    ->where("jenis_plafon",$plafon)
                                    ->where("id_cabang",$id_cabang)
                                    ->where("id_company",$id_company)
                                    ->get();
            if ($cek_plafon->num_rows() > 0) {
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Jenis plafon sudah digunakan</font>');
                return __response_save(false,$message);
            }else{
                $nextId = $this->fungsi->getNextId($this->table,'id_jenis_reimbursement',$id_company,4);
                $id_shift = array('id_jenis_reimbursement' => $nextId);
                $save = $this->db->insert($this->table, array_merge($data,$id_shift));

                return __response_save($save);
            }


        }
    }

    public function delete($id=null){
        $this->db->where(array('md5(id_jenis_reimbursement)'=>$id));
        $delete =$this->db->delete($this->table);
        return  __response_delete($delete);

    }

}