<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Jabatan_m extends CI_Model {
    var $table = 'master_jabatan';
    public function __construct(){
		parent::__construct();
	}

    function get_datatables($leveluser = 0){
        $this->_get_datatables_query($leveluser);
        if($_POST['length'] != -1){
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered($leveluser = 0){
        $this->_get_datatables_query($leveluser);
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all($leveluser = 0){
        $this->db->select("master_jabatan.id_jabatan")
                ->join("usergroup","usergroup.id = master_jabatan.level_user")
                ->from($this->table);
        $this->db->where("id_company",$this->id_company);

        if($leveluser != 0){
            $this->db->where("usergroup.id",$leveluser);
        }

        return $this->db->count_all_results();
    }
    private function _get_datatables_query($leveluser = 0){
        if($leveluser != 0){
            $this->db->where("usergroup.id",$leveluser);
        }
        $this->db->select("master_jabatan.id_jabatan,
                            master_jabatan.kode_jabatan,
                            master_jabatan.nama,
                            master_jabatan.level_user,
                            usergroup.id,
                            usergroup.level")
                ->join("usergroup","usergroup.id = master_jabatan.level_user")
                ->where("id_company",$this->id_company)
                ->from($this->table);

        $column_search = array('master_jabatan.kode_jabatan','master_jabatan.nama');

        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('','master_jabatan.kode_jabatan','master_jabatan.nama','usergroup.urutan');

        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else{
            $order_by = array("master_jabatan.tgl_input"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id=null){
        $select = $this->db->query("SELECT id_jabatan,
                                            kode_jabatan,
                                            nama, level_user
                                    FROM $this->table
                                    WHERE MD5(id_jabatan) = '$id'
                                    AND id_company = '".$this->id_company."'")->row();
        return $select;
    }

    public function getLevelUser(){
        $select = $this->db->query("SELECT id,level,urutan FROM usergroup ORDER BY urutan ASC")->result();
        return $select;
    }

    public function save($data,$id_jabatan = null){
        $kode_jabatan = $data['kode_jabatan'];
        $level_user = $data['level_user'];
        if($id_jabatan != null){
            $select = "SELECT kode_jabatan FROM master_jabatan WHERE kode_jabatan = ? AND md5(id_jabatan) != ? AND id_company = ?";
            $cek_kode = $this->db->query($select, array($kode_jabatan,$id_jabatan,$this->id_company));
            $cek_level_admin = $this->db->query("SELECT id_jabatan FROM master_jabatan WHERE id_company = '$this->id_company'
                                                AND level_user = 1")->num_rows();
            if ($cek_kode->num_rows() > 0) {
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode sudah digunakan</font>');
                return __response_update(false,$message);
            }else if($cek_level_admin > 0 && $level_user == 1){
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data jabatan level admin sudah ada </font>');
                return __response_update(false,$message);
            }else{
                $this->db->where(array('md5(id_jabatan)'=>$id_jabatan, 'id_company'=>$this->id_company));
                $update = $this->db->update($this->table,$data);
                return  __response_update($update);
            }

        }else{
            $select = "SELECT kode_jabatan FROM master_jabatan WHERE kode_jabatan = ?  AND id_company = ?";
            $cek_kode = $this->db->query($select, array($kode_jabatan,$this->id_company));
            $cek_level_admin = $this->db->query("SELECT id_jabatan FROM master_jabatan WHERE id_company = '$this->id_company'
                                                AND level_user = 1")->num_rows();
            if ($cek_kode->num_rows() > 0) {
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode sudah digunakan</font>');
                return __response_save(false,$message);
            }else if($cek_level_admin > 0 && $level_user == 1){
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data jabatan level admin sudah ada </font>');
                return __response_update(false,$message);
            }else{
                $nextId = $this->fungsi->getNextId($this->table,'id_jabatan',$this->id_company,3);
                $id_jabatan = array('id_jabatan' => $nextId);
                $save = $this->db->insert($this->table, array_merge($data,$id_jabatan));
                return __response_save($save);
            }
        }

    }

    public function delete($id=null){
        $this->db->select("id_karyawan");
        $this->db->from("data_karyawan");
        $this->db->where("md5(id_jabatan)",$id);
        $this->db->where("id_company",$this->id_company);
        $cek_data = $this->db->get()->num_rows();

        if($cek_data > 0){
            $message = '<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>Gagal, terdapat karyawan menggunakan jabatan ini</font>';
            return __response_delete(false,["message"=>$message]);
        }else{
            $this->db->where(array('md5(id_jabatan)'=>$id,'id_company'=>$this->id_company));
            $delete =$this->db->delete($this->table);
            return  __response_delete($delete);
        }

    }

}