<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Departemen_m extends CI_Model {
    var $table = 'master_departemen';

    public function __construct(){
		parent::__construct();
	}

    function get_datatables(){
        $this->_get_datatables_query();
        if($_POST['length'] != -1){
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

    public function count_all(){
        $this->db->select("id_departemen")->from($this->table);
        $this->db->where('id_company',$_SESSION['id_company']);
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $this->db->select("id_departemen,kode,nama")->from($this->table);
        $this->db->where('id_company',$_SESSION['id_company']);

        $column_search = array('kode','nama');
        $i = 0;

        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }

                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }

        $column_order = array('','kode','nama');

        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else{
            $order_by = array("id_departemen"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id=null){
        $select = $this->db->query("SELECT id_departemen,
                                            kode,
                                            nama, jenis
                                    FROM $this->table
                                    WHERE MD5(id_departemen) = '$id'
                                    AND id_company = '".$_SESSION["id_company"]."'")->row();
        return $select;
    }

    public function save($data,$id = null){
        if($id != null){
            $kode = $data['kode'];
            $this->db->select("kode");
            $this->db->from("master_departemen");
            $this->db->where("kode",$kode);
            $this->db->where("md5(id_departemen) !=",$id);
            $this->db->where("id_company",$this->id_company);
            $cek_kode = $this->db->get();
            if ($cek_kode->num_rows() > 0) {
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode sudah digunakan</font>');
                return __response_update(false,$message);
            }else{
                $this->db->where(array('md5(id_departemen)'=>$id, 'id_company'=>$_SESSION['id_company']));
                $update = $this->db->update($this->table,$data);
                return  __response_update($update);
            }

        }else{
            $kode = $data['kode'];
            $this->db->select("kode");
            $this->db->from("master_departemen");
            $this->db->where("kode",$kode);
            $this->db->where("id_company",$this->id_company);
            $cek_kode = $this->db->get();
            if ($cek_kode->num_rows() > 0) {
                $message = array('message'=>'<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode sudah digunakan</font>');
                return __response_save(false,$message);
            }else{
                $nextId = $this->fungsi->getNextId($this->table,'id_departemen',$_SESSION['id_company'],3);
                $id_departemen = array('id_departemen' => $nextId);
                $save = $this->db->insert($this->table, array_merge($data,$id_departemen));
                return __response_save($save);
            }
        }

    }

    public function delete($id=null){

        $this->db->select("id_karyawan");
        $this->db->from("data_karyawan");
        $this->db->where("md5(id_departemen)",$id);
        $this->db->where("id_company",$this->id_company);
        $cek_data = $this->db->get()->num_rows();

        if($cek_data > 0){
            $message = '<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>Gagal, terdapat karyawan didepartemen ini</font>';
            return __response_delete(false,["message"=>$message]);
        }else{
            $this->db->where(array('md5(id_departemen)'=>$id, 'id_company'=>$this->id_company));
            $delete =$this->db->delete($this->table);
            return  __response_delete($delete);
        }

    }

}