<script type="text/javascript">
    $(function() {
        // Datatable
        list_data = $('#list_data').DataTable({
            'searching': false,
            'paging': false,
            'lengthChange': true,
            'ordering': false,
            'info': false,
            'scrollX': true,
            'language': {
                'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                'searchPlaceholder': 'Kode/Nama'
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('kpi.master.kinerja.data') ?>",
                "type": "GET",
                "data": function(d) {
                    delete d.columns;
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                    "aTargets": [0, 1, 2],
                    "bSortable": false
                },
                {
                    "className": "text-left",
                    "targets": [0, 1]
                },
                {
                    "className": "text-center",
                    "targets": [2]
                },
            ],

            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '30px'
                });

                $('td:eq(1)', nRow).css({
                    'text-align': 'center',
                });

                $('td:eq(2)', nRow).css({
                    'text-align': 'center',
                    'width': '50px'
                });
            }
        });

        // Fungsi Order
        $('#list_data').sortable({
            items: "tr",
            cursor: "move",
            handle: "i.fa-sort",
            placeholder: "ui-state-highlight",
            update: function() {
                var order = [];
                $('#list_data tbody tr').each(function(index, element) {
                    order.push({
                        id_objek: $(this).find("td:eq(0) i").data("key"),
                        no_urut: index + 1
                    });
                });
                // console.log(order);
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: "<?= route("kpi.master.kinerja.order") ?>",
                    data: {
                        order: order,
                    },
                    success: function(response) {
                        if (response.status == "success") {
                            console.log(response);
                        } else {
                            console.log(response);
                        }
                    }
                });
            }
        });
    });

    // START CRUD
    function tambah(e){
        $('#tampil_form').load("<?= route('kpi.master.kinerja.form.tambah') ?>", function() {
            $('#modal_form').modal('show');
            $(".title").text("Form Tambah Data");
            $(".btn_save").addClass("btn_save btn btn-primary");
            $(".btn_save").append('<i class="fa fa-save"></i> ');
            $(".btn_save").append('SIMPAN');
            $('.btn_save').attr('onClick','simpan(this)');
            $("#btn_new_input").hide();
        });
    }

    function edit(e){
        $('#tampil_form').load("<?= route('kpi.master.kinerja.form.edit') ?>" + "/" + $(e).attr('id'), function() {
            $('#modal_form').modal('show');
            $(".title").text("Form Edit Data");
            $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
            $(".btn_save").append('PERBARUI');
            $(".btn_save").removeClass("btn_save").addClass("btn_update btn btn-warning");
            $('.btn_update').attr('onClick','perbarui(this)');
            $("#btn_new_input").hide();
        });
    }


    function hapus_form(e){
        $('#tampil_form').load("<?= route('kpi.master.kinerja.form.hapus') ?>" + "/" + $(e).attr('id'), function() {
            $('#modal_form').modal('show');
            $(".title").text("Apakah Anda ingin menghapus data ini?");
            $('#form_input input[type=text]').prop("disabled", true);
            $(".btn_save").append('<i class="fa fa-trash"></i> ');
            $(".btn_save").append('HAPUS');
            $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            $('.btn_hapus').attr('onClick','hapus_action(this)');
        });
    }

    function new_input(e){
        $('#form_input input[type=text]').prop("disabled", false);
        $("#form_input input[type=text]").val('');

        $('.btn_save').show();
        $('#btn_new_input').hide();
        $('#message').hide();
    }

    function simpan(e){
        $('#message').html("");
        var loading = Ladda.create(e);

        if ($("#nm_object").val() == "") {
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nama Obyektive belum diisi</font>");
            $("#nm_object").focus();
            return false;
        }

        loading.start();

        var param = 'id_object=' + $("#id_object").val() +
            '&nm_object=' + $("#nm_object").val() +
            '&reorder=' + reorder();

        $.ajax({
            type: 'POST',
            url: "<?= route('kpi.master.kinerja.form.save') ?>",
            data: param,
            dataType: 'JSON',
            success: function(result) {
                if (result.success == true) {
                    if (result.type == 'save') {
                        $("#form_input :input").prop("disabled", true);
                        $('.btn_save').hide();
                        $('#btn_new_input').show();
                    }
                }
                loading.stop();

                $('#message').show();
                $('#message').html(result.message);
            },
            error: function() {
                loading.stop();
                $('#message').show();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    }

    function perbarui(e){
        $('#message').html("");
        var loading = Ladda.create(e);

        loading.start();

        var param = 'id_object=' + $("#id_object").val() +
            '&nm_object=' + $("#nm_object").val() +
            '&reorder=' + reorder();

        $.ajax({
            type: 'POST',
            url: "<?= route('kpi.master.kinerja.form.update') ?>",
            data: param,
            dataType: 'JSON',
            success: function(result) {
                if (result.success == true) {
                    if (result.type == 'update') {
                        $('.btn_update').hide();
                    }
                }
                loading.stop();
                setTimeout(() => {
                    $("#modal_form").modal("hide");
                }, 2000);
                $('#message').show();
                $('#message').html(result.message);
            },
            error: function() {
                loading.stop();
                $('#message').show();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    }

    function hapus_action(e){
        var loading = Ladda.create(e);
        loading.start();
        var param = {};
        param.id_object = $("#id_object").val();
        $.ajax({
            type: 'POST',
            url: "<?= route('kpi.master.kinerja.form.delete') ?>",
            data: param,
            dataType: 'JSON',
            success: function(result) {
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html(result.message.replace("009900", "FFFFFF"));

                setTimeout(() => {
                    $("#modal_form").modal("hide");
                }, 2000);
            },
            error: function() {
                loading.stop();
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
            }
        });
    }

    function reorder() {
        var order = [];
        $('#list_data tbody tr').each(function(index, element) {
            order.push({
                id_objek: $(this).find("td:eq(0) i").data("key"),
                no_urut: index + 1
            });
        });
        return order;
    }
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Aspek Kinerja</h5>
    </div>
    <div class="content-header-right col-md-6 col-12">
        <button type="button" class="btn btn_tambah btn-success pull-right" onclick="tambah(this)">
            <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?>
        </button>
    </div>
</div>
<hr>


<div class="table-responsive mt-2">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center">NO</th>
                <th class="text-left">ASPEK KINERJA</th>
                <th class="text-center">AKSI</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>