<style>
    body {
        font-family: 'Inter', sans-serif;
        background-color: #f8f9fa;
        padding-top: 40px;
    }
    .container {
        max-width: 600px;
        background-color: #ffffff;
        padding: 30px;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    h2 {
        margin-bottom: 25px;
        color: #333;
        text-align: center;
    }
    .form-group label {
        font-weight: 600;
    }
    
    /* --- Gaya Baru untuk Tampilan Tag --- */

    /* Wadah untuk tag yang meniru tampilan input */
    .datepicker-tags-container {
        display: flex;
        flex-wrap: wrap;
        align-items: center;
        gap: 8px;
        padding: 6px 12px; /* Sama seperti .form-control */
        font-size: 14px;
        line-height: 1.42857143;
        color: #555;
        background-color: #fff;
        background-image: none;
        border: 1px solid #ccc;
        border-radius: 4px;
        box-shadow: inset 0 1px 1px rgba(0,0,0,.075);
        transition: border-color ease-in-out .15s, box-shadow ease-in-out .15s;
        min-height: 34px; /* Sama tinggi minimum dengan .form-control */
        cursor: text; /* Agar seperti input text biasa */
    }

    /* Gaya untuk setiap tag tanggal */
    .date-tag {
        display: inline-flex;
        align-items: center;
        background-color: #1abc9c; /* Warna teal seperti di gambar */
        color: white;
        padding: 5px 10px;
        border-radius: 5px;
        font-size: 14px;
        font-weight: 500;
    }

    /* Tombol hapus (x) pada setiap tag */
    .remove-tag {
        margin-left: 8px;
        cursor: pointer;
        font-weight: bold;
        font-size: 16px;
        line-height: 1;
        opacity: 0.7;
        transition: opacity 0.2s;
    }
    .remove-tag:hover {
        opacity: 1;
    }
    
    /* Teks placeholder ketika tidak ada tanggal yang dipilih */
    .placeholder-text {
        color: #999;
    }

    .hidden-datepicker-input {
        position: absolute;
        width: 1px;
        height: 1px;
        padding: 0;
        margin: 0;
        border: none;
        clip: rect(0, 0, 0, 0);
        overflow: hidden;
    }

</style>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>

    <div class="form-group">
        <label for="multiple-datepicker"><?= $this->lang->line('tgl'); ?> <i class="text-danger">*</i></label>
        
        <div id="datepicker-wrapper">
            <!-- Wadah untuk menampilkan tag tanggal -->
            <div id="datepicker-tags-container" class="datepicker-tags-container">
                <span class="placeholder-text">dd-mm-yyyy</span>
            </div>

            <!-- Input asli, sekarang disembunyikan. Ini diperlukan untuk datepicker bekerja -->
            <input type="text" id="tanggal" class="hidden-datepicker-input">
        </div>
    </div>

    <div class="form-group">
        <label><?= $this->lang->line('keterangan'); ?> <i class="text-danger">*</i></label>
        <input type="text" id="keterangan" class="form-control">
    </div>

    <div class="form-group">
        <label><?= $this->lang->line('jenis'); ?> <i class="text-danger">*</i></label>
        <select name="jenis" id="jenis" class="form-control">
            <option value=""><?= $this->lang->line('pilih_jenis_hari_libur') ?></option>
            <option value="nasional"><?= $this->lang->line('libur_nasional') ?></option>
            <option value="khusus"><?= $this->lang->line('libur_khusus') ?></option>
        </select>
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" style="display:none"><?= $this->lang->line('button_form_tambah_baru'); ?></button>
            <button class="btn_save ladda-button" data-style="expand-left"></button>
        </div>
    </div>
</div>

<script>
    $(document).ready(function(){
        // --- Logika Baru untuk Tampilan Tag ---

        const dateInput     = $('#tanggal');
        const tagsContainer = $('#datepicker-tags-container');
        const format        = "dd-mm-yyyy";

        // 1. Inisialisasi Datepicker pada input yang disembunyikan
        dateInput.datepicker({
            multidate: true,
            format: format,
            language: "id",
            autoclose: false,
            todayHighlight: true,
            container: 'body',
            orientation : 'bottom'
        });

        // 2. Fungsi untuk me-render ulang tag berdasarkan tanggal yang dipilih
        function renderTags() {
            tagsContainer.empty(); // Kosongkan wadah tag
            // PERBAIKAN: Gunakan 'getUTCDates' untuk menghindari masalah zona waktu
            const selectedDates = dateInput.datepicker('getUTCDates');

            if (selectedDates.length > 0) {
                selectedDates.forEach(function(date) {
                    // Format tanggal sesuai dengan format yang ditentukan
                    const formattedDate = $.fn.datepicker.DPGlobal.formatDate(date, format, 'id');
                    
                    // Buat elemen tag
                    const tag = $(`
                        <span class="date-tag">
                            ${formattedDate}
                            <span class="remove-tag" data-date="${date.getTime()}">&times;</span>
                        </span>
                    `);
                    tagsContainer.append(tag);
                });
            } else {
                // Jika tidak ada tanggal, tampilkan placeholder
                tagsContainer.append('<span class="placeholder-text">dd-mm-yyyy</span>');
            }
        }

        // 3. Tampilkan datepicker ketika wadah tag diklik
        tagsContainer.on('click', function() {
            dateInput.datepicker('show');
        });

        // 4. Hapus tag ketika tombol (x) diklik
        tagsContainer.on('click', '.remove-tag', function(e) {
            e.stopPropagation(); // Mencegah datepicker terbuka saat menghapus tag

            const dateToRemoveTimestamp = $(this).data('date');
            // PERBAIKAN: Gunakan 'getUTCDates' untuk konsistensi
            let currentDates = dateInput.datepicker('getUTCDates');
            
            // Filter array untuk menghapus tanggal yang sesuai
            const newDates = currentDates.filter(function(date) {
                return date.getTime() != dateToRemoveTimestamp;
            });
            
            if (newDates.length > 0) {
                // PERBAIKAN: Gunakan 'setUTCDates' untuk mengatur tanggal kembali
                dateInput.datepicker('setUTCDates', newDates);
            } else {
                // 'clearDates' sudah benar karena akan menghapus semua tanggal
                dateInput.datepicker('clearDates');
            }
        });

        // 5. Dengarkan event 'changeDate' untuk me-render ulang tag
        dateInput.on('changeDate', function() {
            renderTags();
        });

        // Render tag saat pertama kali halaman dimuat (jika ada nilai default)
        renderTags();
    });
</script>
