<?php
defined('BASEPATH') || exit('No direct script access allowed');

class Product extends MY_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('sales_activity/master/Product_m');
    }

    public function list_data(){
        $list = $this->Product_m->get_datatables();
        $data = array();
        $no = $_GET['start'];
        foreach ($list as $field) {
            $no++;
            $row   = array();
            $row[] = $no;
            $row[] = $field->nama_g_product . "<br><b>" . $field->kode_g_product . "</b>";
            $row[] = $field->nama_product . "<br><b>" . $field->kode_product . "</b>";

            if($this->fungsi->cek_adm_satu_grup() == false){
                $row[] = $field->nama_g_area . "<br><b>" . $field->kode_g_area . "</b>";
            }
            
            $row[] = number_format($field->harga_product,0,",",".");

            $btn_edit = '<a href="javascript:void(0)" class="text-warning" title="EDIT"> <i id="' . md5($field->id_product_m) . '" class="btn_edit_m_product fa fa-edit (alias) "> </i></a>';
            $btn_hapus = '<a href="javascript:void(0)" class="text-danger" title="' . $this->lang->line('hapus') . '"><i id="' . md5($field->id_product_m) . '" class="btn_delete_m_product fa fa-trash"></i></a>';
            $row[] = $btn_edit. '&nbsp'. $btn_hapus;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Product_m->count_all(),
            "recordsFiltered" => $this->Product_m->count_filtered(),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null){
        $data = [];
        if($id != null){
			$data['data'] = $this->Product_m->getDataById($id);
		}
		$this->load->view('sales_activity/master/product/form',$data);
    }

    public function save(){
        $id            = $this->input->post('id_product_m');
        $harga_product = str_replace('.','',$this->input->post('harga_product'));
        $harga_product = preg_replace('/[^0-9]/', '', $harga_product);

        $data = array( 
            'id_product_group_m' => $this->input->post('id_product_group_m'),
            'kode'               => $this->input->post('kode_product'),
            'nama'               => $this->input->post('nama_product'),
            'harga'              => $harga_product,
            'id_company'         => $this->id_company
        );

        $this->Product_m->save($data, $id);
    }

    public function delete(){
        $id = $this->input->post("id_product_m");
        $this->Product_m->delete($id);
    }

    public function dropdown_group_product(){
        $search = $this->input->get("q");

        $this->db->select('
            sgp.id_product_group_m, 
            sgp.kode,
            sgp.nama,
            IF(sgm.id_group_m IS NULL, "-", CONCAT(sgm.kode," - ",sgm.nama)) AS nama_group_area
        ');

        $this->db->from('sales_product_group_m AS sgp');
        $this->db->join('sales_group_m AS sgm', 'sgm.id_group_m = sgp.id_group_m', 'LEFT');
        $this->db->where('sgp.id_company',  $this->id_company);
        $this->db->order_by('sgp.id_product_group_m', 'ASC');

        if($this->is_sales_admin == true){
            if (!in_array($this->sales_admin_group, ["all", ""])) {
                $this->db->where_in('sgp.id_group_m', explode(',', $this->sales_admin_group));
            }
        }
        
        $this->db->group_start();
        $this->db->like('sgp.kode', $search);
        $this->db->or_like('sgp.nama', $search);
		$this->db->or_like('sgm.kode', $search);
        $this->db->or_like('sgm.nama', $search);
        $this->db->group_end();

        $result = $this->db->get()->result();

        $json = [];
        foreach ($result as $rows) {  
            $text = $rows->kode . " - " . $rows->nama;

            if($this->fungsi->cek_adm_satu_grup() == false){
                $text .= " - ".$rows->nama_group_area;
            }       

            $json[] = [
                'id'              => $rows->id_product_group_m,
                'text'            => $text,
            ];
        }
        echo json_encode($json);
    }
}