<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Adm_reimbursement extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('pengaturan/Adm_reimbursement_m');
    }

	public function index(){
		$data['judul'] = 'Admin Reimbursement';
		$data['aktif'] = 'adm_reimbursement';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('pengaturan/adm_reimbursement/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
		$list = $this->Adm_reimbursement_m->get_datatables();
		$data = array();
		$no = $_GET['start'];

		$cabang_arr = $this->Adm_reimbursement_m->getCabang();
		foreach ($list as $field) {
			$no++;

			$id_cabang = $field->id_cabang;
			if($id_cabang  == "all"){
				$cabang = "Semua Cabang";
			}else{
				$id_cabang_arr = explode(",",$id_cabang);

				$cabang = "";
				foreach($id_cabang_arr as $row){
					$cabang .= "<h6 class='badge badge-primary'>".$cabang_arr[$row]['nm_cabang']."</h6>";
					$cabang .=" ";
				}
			}

			$row = array();
			$row[] = $no;
			$row[] = $field->nm_karyawan."<br><b>".$field->nik."</b>";
			$row[] = $cabang;

            if(in_array($this->level_user, array("1"))) {

				$row[] = '<a href="#" class="text-warning" title="EDIT">
							<i id="'.md5($field->id).'" class="btn_edit fa fa-edit (alias) "> </i></a>&nbsp;
						<a href="#" class="text-danger" title="HAPUS">
							<i id="'.md5($field->id).'" class="btn_delete fa fa-trash"></i>
						</a>';
			}

			$data[] = $row;
		}

			$output = array("draw"            => $_GET['draw'],
							"recordsTotal"    => $this->Adm_reimbursement_m->count_all(),
							"recordsFiltered" => $this->Adm_reimbursement_m->count_filtered(),
							"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function form($id=null){
		if($id==null){
			$this->load->view('pengaturan/adm_reimbursement/form');
		}else{
			$data['data'] 		= $this->Adm_reimbursement_m->getDataById($id);
			$data['cabang_arr'] = $this->Adm_reimbursement_m->getCabang();
			$this->load->view('pengaturan/adm_reimbursement/form',$data);
		}

	}

	public function form_delete($id=null){
		$data['data'] 		= $this->Adm_reimbursement_m->getDataById($id);
		$data['cabang_arr'] = $this->Adm_reimbursement_m->getCabang();
		$this->load->view('pengaturan/adm_reimbursement/form_delete',$data);
	}

	public function save(){
		$id = $this->input->post('id');

		$data = array('id_karyawan'		=>$this->input->post('id_karyawan'),
					'id_cabang'			=>empty($this->input->post('id_cabang'))?"all":$this->input->post('id_cabang'),
					'id_company' 		=>$this->id_company);

		$this->Adm_reimbursement_m->save($data,$id);
	}

	public function delete(){
		$id = $this->input->post("id");
		$this->Adm_reimbursement_m->delete($id);
	}
}
