<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Gaji extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model(['payroll/gaji/Gaji_m', 'payroll/Pph21_uu24_m', 'payroll/gaji/Komponen_m']);
        $this->load->model('payroll/laporan_pph/Laporan_pph_m', 'laporan_pph');
        $this->load->helper('payroll');
    }

    public function index()
    {
        $data['judul']          = 'Hitung Gaji';
        $data['aktif']          = 'hitung_gaji';
        $data['pengaturan_pph'] = $this->Pph21_uu24_m->get_pengaturan_pph();
        $data['menu']           = $this->load->view('main_menu', $data, true);
        $data['content']        = $this->load->view('payroll/gaji/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function view($periode, $cabang, $departemen, $karyawan)
    {
        $data['periode']    = $periode;
        $data['cabang']     = $cabang;
        $data['departemen'] = $departemen;
        $data['karyawan']   = $karyawan;

        $data['komponen_kehadiran']      = $this->Komponen_m->master_trx($this->periode($periode), 'tetap', 'kehadiran');
        $data['komponen_tunj_tetap']     = $this->Komponen_m->master_trx($this->periode($periode), 'tetap', 'pendapatan');
        $data['komponen_tunj_tdk_tetap'] = $this->Komponen_m->master_trx($this->periode($periode), 'tidak tetap', 'pendapatan');
        $data['komponen_tunj_kehadiran'] = $this->Komponen_m->master_trx($this->periode($periode), 'tetap', 'kehadiran');
        $data['komponen_pot_tetap']      = $this->Komponen_m->master_trx($this->periode($periode), 'tetap', 'potongan');
        $data['komponen_pot_tdk_tetap']  = $this->Komponen_m->master_trx($this->periode($periode), 'tidak tetap', 'potongan');
        $this->load->view('payroll/gaji/view', $data);
    }

    public function list_data($bulan = "", $id_cabang = "all", $id_departemen = "all", $id_karyawan = "all")
    {
        $bulan = date_format(date_create("01-" . $bulan), "Y-m");
        $list  = $this->Gaji_m->get_datatables($bulan, $id_cabang, $id_departemen, $id_karyawan);
        $data  = array();
        $no    = $_GET['start'];
        foreach ($list as $field) {
            $no++;

            $row   = array();
            $row[] = $no;
            $row[] = $field->nm_karyawan . "<br><b>" . $field->nik . "</b>";
            $row[] = date("m-Y", strtotime($field->periode));
            $row[] = $field->nm_cabang . "<br><b>" . $field->kd_cabang . "</b>";
            $row[] = $field->nm_departemen . "<br><b>" . $field->kd_departemen . "</b>";
            $row[] = date("d-m-Y", strtotime($field->tgl_mulai)) . '<br>s/d<br>' . date("d-m-Y", strtotime($field->tgl_selesai));
            $row[] = number_format($field->gapok, 0, ",", ".");
            // KOMPONEN TUNJANGAN TETAP
            $data_tunj_tetap_trx = $this->Komponen_m->tunj_tetap_trx($bulan, $field->id_karyawan);
            if (count($data_tunj_tetap_trx->result()) > 0) {
                foreach ($data_tunj_tetap_trx->result() as $val) {
                    $row[] = number_format($val->nominal_tunjangan, 0, ",", ".");
                }
            } else {
                $row[] = 0;
            }
            // KOMPONEN TUNJANGAN TIDAK TETAP
            $data_tunj_tdk_tetap_trx = $this->Komponen_m->tunj_tdk_tetap_trx($bulan, $field->id_karyawan);
            if (count($data_tunj_tdk_tetap_trx->result()) > 0) {
                foreach ($data_tunj_tdk_tetap_trx->result() as $val) {
                    $row[] = number_format($val->nominal_tunjangan, 0, ",", ".");
                }
            } else {
                $row[] = 0;
            }
            // KOMPONEN TUNJANGAN KEHADIRAN
            $data_tunj_kehadiran_trx = $this->Komponen_m->tunj_kehadiran_trx($bulan, $field->id_karyawan);
            if (count($data_tunj_kehadiran_trx->result()) > 0) {
                foreach ($data_tunj_kehadiran_trx->result() as $val) {
                    $row[] = number_format($val->nominal_tunjangan, 0, ",", ".");
                }
            } else {
                $row[] = 0;
            }
            $row[] = number_format($field->ttl_tunjangan, 0, ",", ".");

            // $row[] = $field->lembur_menit;
            // $row[] = number_format($field->lembur_per_jam, 0, ",", ".");
            $row[] = '<a href="javascript:void(0)" class="detail_upah_lembur" data-upah-lembur="' . $field->id_karyawan . $bulan . '">' . number_format($field->lembur_rp, 0, ",", ".") . '</a>';

            // KOMPONEN POTONGAN TETAP
            $data_pot_tetap_trx = $this->Komponen_m->pot_tetap_trx($bulan, $field->id_karyawan);
            if (count($data_pot_tetap_trx->result()) > 0) {
                foreach ($data_pot_tetap_trx->result() as $val) {
                    $row[] = number_format($val->nominal_potongan, 0, ",", ".");
                }
            } else {
                $row[] = 0;
            }
            // KOMPONEN POTONGAN TIDAK TETAP
            $data_pot_tdk_tetap_trx = $this->Komponen_m->pot_tdk_tetap_trx($bulan, $field->id_karyawan);
            if (count($data_pot_tdk_tetap_trx->result()) > 0) {
                foreach ($data_pot_tdk_tetap_trx->result() as $val) {
                    $row[] = number_format($val->nominal_potongan, 0, ",", ".");
                }
            } else {
                $row[] = 0;
            }
            $row[] = number_format($field->pot_bpjs_kes, 0, ",", ".");
            $row[] = number_format($field->pot_bpjs_tk, 0, ",", ".");
            $row[] = '<a href="javascript:void(0)" class="detail_pot_absensi" data-mulai="' . $field->tgl_mulai . '" data-selesai="' . $field->tgl_selesai . '" data-pot-absensi="' . $field->id_karyawan . $bulan . '">' . number_format($field->pot_absensi_acc, 0, ",", ".") . '</a>';
            $row[] = number_format($field->pot_pph21, 0, ",", ".");
            $row[] = number_format($field->ttl_potongan, 0, ",", ".");
            $row[] = number_format($field->thp, 0, ",", ".");
            $row[] = number_format($field->tunj_bpjs_kes, 0, ",", ".");
            $row[] = number_format($field->tunj_bpjs_tk, 0, ",", ".");
            $row[] = number_format($field->ttl_tunj_dibiayai_perus, 0, ",", ".");

            if ($field->publish_sch == "0000-00-00 00:00:00") {
                $row[] = "-";
            } else {
                $row[] = date("d-m-Y", strtotime($field->publish_sch));
            }

            if ($field->publish_tgl == "0000-00-00 00:00:00") {
                $row[] = "-";
            } else {
                $row[] = date("d-m-Y H:i:s", strtotime($field->publish_tgl));
            }

            if ($field->publish_user == '') {
                $checklist_publish = '';
                $btn               = '<a href="#" id="' . md5($field->id_karyawan) . '" bulan="' . $field->periode . '" class="btn_delete text-danger" title="HAPUS"><i class="fa fa-trash"></i></a>';
            } else {
                $checklist_publish = 'checked';
                $btn               = '<a href="' . route('payroll.gaji.detail') . '/' . md5($field->id_karyawan) . '/' . $field->periode . '" class="btn_detail text-primary" title="DETAIL"><i class="fa fa-info-circle" aria-hidden="true"></i></a>';
            }

            $row[] = '<input class="btn_publish" id="' . md5($field->id_karyawan . $field->periode) . '" type="checkbox" onclick="publish_unpublish(`' . md5($field->id_karyawan . $field->periode) . '`)" publish="' . $field->publish_flag . '" ' . $checklist_publish . ' disabled>';
            $aksi  = $btn;

            $row[] = $aksi;

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->Gaji_m->count_all($bulan, $id_cabang, $id_departemen, $id_karyawan),
            "recordsFiltered" => $this->Gaji_m->count_filtered($bulan, $id_cabang, $id_departemen, $id_karyawan),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function detail($id = "", $bulan = "")
    {
        $data = $this->Gaji_m->get_datatables($bulan, $id_cabang = "all", $id_departemen = "all", $id);

        $data['judul']          = "Hitung Gaji Bulanan";
        $data['aktif']          = 'hitung_gaji';
        $data['menu']           = $this->load->view('main_menu', $data, true);
        $data['data']           = $data[0];
        $data['tunj_tetap']     = $this->Gaji_m->tunj_tetap_karyawan(null, $id, $bulan);
        $data['tunj_tdk_tetap'] = $this->Gaji_m->tunj_tdk_tetap_karyawan(null, $id, $bulan);
        $data['tunj_kehadiran'] = $this->Gaji_m->tunj_kehadiran_karyawan(null, $id, $bulan);
        $data['pot_tetap']      = $this->Gaji_m->pot_tetap_karyawan(null, $id, $bulan);
        $data['pot_tdk_tetap']  = $this->Gaji_m->pot_tdk_tetap_karyawan(null, $id, $bulan);
        $data['content']        = $this->load->view('payroll/gaji/detail', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function detail_upah_lembur($id = '')
    {
        $data['data'] = $this->Gaji_m->get_data_lembur_trx($id);
        $this->load->view('payroll/gaji/detail_upah_lembur', $data);
    }

    public function detail_pot_absensi($id = '')
    {
        // get data yang diikutsertakan hitungan potongan absensi
        $data['data_gapok']          = $this->Gaji_m->get_data_gapok_trx($id) ?: 0;
        $data['data_upah_lembur']    = $this->Gaji_m->get_data_upah_lembur_trx($id) ?: 0;
        $data['data_tunj_tetap']     = $this->Gaji_m->get_data_tunj_tetap_trx($id);
        $data['data_tunj_tdk_tetap'] = $this->Gaji_m->get_data_tunj_tdk_tetap_trx($id);
        $data['data_tunj_kehadiran'] = $this->Gaji_m->get_data_tunj_kehadiran_trx($id);
        $data['data']                = $this->Gaji_m->get_data_pot_absensi_trx($id);
        $this->load->view('payroll/gaji/detail_pot_absensi', $data);
    }

    public function form($id = "")
    {
        $data['pengaturan_pph'] = $this->Pph21_uu24_m->get_pengaturan_pph();
        $this->load->view('payroll/gaji/form', $data);
    }

    public function form_publish($key = null)
    {
        $data['data'] = $this->Gaji_m->getDataById($key);
        $this->load->view('payroll/gaji/form_publish', $data);
    }

    public function hitung_gaji()
    {
        $bulan            = date_format(date_create("01-" . $this->input->post('bulan')), "Y-m");
        $periode_mulai    = date_format(date_create($this->input->post('periode_mulai')), "Y-m-d");
        $periode_selesai  = date_format(date_create($this->input->post('periode_selesai')), "Y-m-d");
        $id_cabang        = $this->input->post('id_cabang');
        $id_departemen    = $this->input->post('id_departemen');
        $id_karyawan      = $this->input->post('id_karyawan');
        $tgl_pemotong     = date_format(date_create($this->input->post('tgl_pemotong')), "Y-m-d");
        $status_aktif_pph = $this->input->post('status_aktif_pph');

        // VALIDASI DATA
        if (!$bulan) {
            return __response_save(false, ['message' => ["<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Bulan belum dipilih</font>"]]);
        }
        if (!$periode_mulai) {
            return __response_save(false, ['message' => ["<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Periode mulai belum diisi</font>"]]);
        }
        if (!$periode_selesai) {
            return __response_save(false, ['message' => ["<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Periode selesai belum diisi</font>"]]);
        }
        if (!$tgl_pemotong && $status_aktif_pph == '1') {
            return __response_save(false, ['message' => ["<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal pemotongan belum diisi</font>"]]);
        }
        // case !validateDate($bulan, 'Y-m') belum diperbaiki
        if (!validateDate($periode_mulai) || !validateDate($periode_selesai) || (!validateDate($tgl_pemotong) && $status_aktif_pph == '1')) {
            return __response_save(false, ['message' => ["<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Format tanggal tidak sesuai</font>"]]);
        }

        // cek ptkp karyawan
        if ($status_aktif_pph == '1') {
            $ttl_ptkp = $this->Gaji_m->get_ptkp_karyawan($id_cabang, $id_departemen, $id_karyawan, $periode_mulai, $periode_selesai);
            if ($ttl_ptkp > 0) {
                $button = '<a href="' . route('payroll.gaji.ptkp.index') . '" class="btn btn-warning btn-sm mt-1"><i class="fa fa-info-circle"></i> Lihat Detail</a>';
                return __response_save(false, ['message' => ["<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Data PTKP karyawan belum lengkap</font>" . $button]]);
            }
        }

        // GET GAPOK
        $data_gapok = $this->Gaji_m->gapok($id_cabang, $id_departemen, $id_karyawan);

        // GET TUNJANGAN KEHADIRAN
        $data_tunj_kehadiran = $this->Gaji_m->tunj_kehadiran($id_cabang, $id_departemen, $id_karyawan);

        // GET TUNJANGAN TETAP
        $data_tunj_tetap = $this->Gaji_m->tunj_tetap($id_cabang, $id_departemen, $id_karyawan);

        // GET TUNJANGAN TIDAK TETAP
        $data_tunj_tdk_tetap = $this->Gaji_m->tunj_tdk_tetap($bulan, $id_cabang, $id_departemen, $id_karyawan);

        // GET POTONGAN TETAP
        $data_pot_tetap = $this->Gaji_m->pot_tetap($id_cabang, $id_departemen, $id_karyawan);

        // GET POTONGAN TIDAK TETAP
        $data_pot_tdk_tetap = $this->Gaji_m->pot_tdk_tetap($bulan, $id_cabang, $id_departemen, $id_karyawan);

        // GET POTONGAN ABSENSI
        $pengaturan_potongan = $this->Gaji_m->pengaturan_potongan();

        // GET TERLAMBAT
        if ($pengaturan_potongan['terlambat']['flag'] == '1') {
            $flag_persen_terlambat = $pengaturan_potongan['terlambat']['flag_persentase_gapok'];
            $persen_terlambat      = $pengaturan_potongan['terlambat']['persentase'];
            $kelipatan_terlambat   = $pengaturan_potongan['terlambat']['kelipatan'];
            $menit_terlambat       = $pengaturan_potongan['terlambat']['menit'];
            $nominal_terlambat     = $pengaturan_potongan['terlambat']['nominal_potongan'];
            $flag_terlambat        = 1;
        } else {
            $menit_terlambat = 0;
            $flag_terlambat  = 0;
        }
        // GET PC
        if ($pengaturan_potongan['pc']['flag'] == '1') {
            $flag_persen_pc = $pengaturan_potongan['pc']['flag_persentase_gapok'];
            $persen_pc      = $pengaturan_potongan['pc']['persentase'];
            $kelipatan_pc   = $pengaturan_potongan['pc']['kelipatan'];
            $menit_pc       = $pengaturan_potongan['pc']['menit'];
            $nominal_pc     = $pengaturan_potongan['pc']['nominal_potongan'];
            $flag_pc        = 1;
        } else {
            $menit_pc = 0;
            $flag_pc  = 0;
        }
        // GET TAP
        if ($pengaturan_potongan['tap']['flag'] == '1') {
            $flag_persen_tap = $pengaturan_potongan['tap']['flag_persentase_gapok'];
            $persen_tap      = $pengaturan_potongan['tap']['persentase'];
            $nominal_tap     = $pengaturan_potongan['tap']['nominal_potongan'];
            $flag_tap        = 1;
        } else {
            $flag_tap = 0;
        }
        // GET ALPA
        if ($pengaturan_potongan['alpa']['flag'] == '1') {
            $flag_persen_alpa = $pengaturan_potongan['alpa']['flag_persentase_gapok'];
            $persen_alpa      = $pengaturan_potongan['alpa']['persentase'];
            $nominal_alpa     = $pengaturan_potongan['alpa']['nominal_potongan'];
            $flag_alpa        = 1;
        } else {
            $flag_alpa = 0;
        }

        // GET TUNJ & POT BPJS KESEHATAN
        $data_bpjs_kes = $this->Gaji_m->bpjs_kes();

        // GET TUNJ & POT BPJS TK
        $data_bpjs_tk = $this->Gaji_m->bpjs_tk();

        // DATA KARYAWAN
        $data_absensi = $this->Gaji_m->data_absensi($id_cabang, $id_departemen, $id_karyawan, $periode_mulai, $periode_selesai, $menit_terlambat, $menit_pc);

        // GET PENGATURAN PPH21
        $pengaturan_pph = $this->Pph21_uu24_m->get_pengaturan_pph();
        $objek_pajak    = $this->Pph21_uu24_m->get_objek_pajak();

        // GET DATA LEMBUR PER KARYAWAN
        $data_lembur_karyawan = $this->Gaji_m->data_lembur(array_column($data_absensi, 'id_karyawan'), $periode_mulai, $periode_selesai);

        // PROSES HITUNG GAJI & PPH21
        if ((count($data_absensi) > 0) && $data_absensi[0]->id_karyawan) {
            $data_gaji_karyawan        = [];
            $data_pot_absensi_karyawan = [];
            $data_pengaturan_potongan  = [];
            $data_pph21_karyawan       = [];
            $update_gaji_pph21         = [];
            $data_kehadiran            = [];
            $data_lembur_trx           = [];
            foreach ($data_absensi as $row) {
                // tambah id_company dan periode pada array $row
                $row->id_company = $this->id_company;
                $row->periode    = $bulan;

                // GAPOK
                $nominal_gapok          = $data_gapok[$row->id_karyawan]['nominal'];
                $gapok_flag_pot_absensi = $data_gapok[$row->id_karyawan]['flag_pot_absensi'];

                // TUNJANGAN
                $ttl_tunj_kehadiran = $data_tunj_kehadiran[$row->id_karyawan] ? (array_sum(array_values(nominal_pendapatan($row, $data_tunj_kehadiran[$row->id_karyawan], 'kehadiran')['total_pendapatan']))) : 0;
                $ttl_tunj_tetap     = $data_tunj_tetap[$row->id_karyawan] ? (array_sum(array_values(nominal_pendapatan($row, $data_tunj_tetap[$row->id_karyawan], 'tetap')['total_pendapatan']))) : 0;
                $ttl_tunj_tdk_tetap = $data_tunj_tdk_tetap[$row->id_karyawan] ? (array_sum(array_values(nominal_pendapatan($row, $data_tunj_tdk_tetap[$row->id_karyawan], 'tidak tetap')['total_pendapatan']))) : 0;

                // PROTEKSI (TUNJANGAN DIIKUTSERTAKAN HITUNGAN POTONGAN ABSENSI)
                $ttl_tunj_kehadiran_maks = $data_tunj_kehadiran[$row->id_karyawan] ? (array_sum(array_values(nominal_pendapatan($row, $data_tunj_kehadiran[$row->id_karyawan], 'kehadiran')['proteksi']))) : 0;
                $ttl_tunj_tetap_maks     = $data_tunj_tetap[$row->id_karyawan] ? (array_sum(array_values(nominal_pendapatan($row, $data_tunj_tetap[$row->id_karyawan], 'tetap')['proteksi']))) : 0;
                $ttl_tunj_tdk_tetap_maks = $data_tunj_tdk_tetap[$row->id_karyawan] ? (array_sum(array_values(nominal_pendapatan($row, $data_tunj_tdk_tetap[$row->id_karyawan], 'tidak tetap')['proteksi']))) : 0;
                $nominal_gapok_maks      = ($gapok_flag_pot_absensi == '1') ? $nominal_gapok : 0;
                $proteksi                = ($ttl_tunj_kehadiran_maks + $ttl_tunj_tetap_maks + $ttl_tunj_tdk_tetap_maks + $nominal_gapok_maks);

                // POTONGAN
                $ttl_pot_tetap     = ($data_pot_tetap[$row->id_karyawan]) ? (array_sum(array_values(nominal_potongan($data_pot_tetap[$row->id_karyawan])['total_potongan']))) : 0;
                $ttl_pot_tdk_tetap = ($data_pot_tdk_tetap[$row->id_karyawan]) ? (array_sum(array_values(nominal_potongan($data_pot_tdk_tetap[$row->id_karyawan])['total_potongan']))) : 0;

                // POTONGAN TERLAMBAT
                if ($flag_terlambat != 0) {
                    $nominal_pot_terlambat = $nominal_terlambat;
                    if ($flag_persen_terlambat != 0) {
                        $nominal_pot_terlambat = ($nominal_gapok * $persen_terlambat) / 100;
                    }
                }
                $data_pengaturan_potongan['terlambat'] = [
                    'flag'      => $flag_terlambat,
                    'nominal'   => $nominal_pot_terlambat,
                    'menit'     => $menit_terlambat,
                    'kelipatan' => $kelipatan_terlambat,
                ];

                // POTONGAN PC
                if ($flag_pc != 0) {
                    $nominal_pot_pc = $nominal_pc;
                    if ($flag_persen_pc != 0) {
                        $nominal_pot_pc = ($nominal_gapok * $persen_pc) / 100;
                    }
                }
                $data_pengaturan_potongan['pc'] = [
                    'flag'      => $flag_pc,
                    'nominal'   => $nominal_pot_pc,
                    'menit'     => $menit_pc,
                    'kelipatan' => $kelipatan_pc,
                ];

                // POTONGAN TAP
                if ($flag_tap != 0) {
                    $nominal_pot_tap = $nominal_tap;
                    if ($flag_persen_tap != 0) {
                        $nominal_pot_tap = ($nominal_gapok * $persen_tap) / 100;
                    } else {
                    }
                }
                $data_pengaturan_potongan['tap'] = [
                    'flag'    => $flag_tap,
                    'nominal' => $nominal_pot_tap,
                ];

                // POTONGAN ALPA
                if ($flag_alpa != 0) {
                    $nominal_pot_alpa = $nominal_alpa;
                    if ($flag_persen_alpa != 0) {
                        $nominal_pot_alpa = ($nominal_gapok * $persen_alpa) / 100;
                    }
                }
                $data_pengaturan_potongan['alpa'] = [
                    'flag'    => $flag_alpa,
                    'nominal' => $nominal_pot_alpa,
                ];

                // SET DATA POTONGAN ABSENSI
                $pot_absensi_karyawan        = $this->Gaji_m->getPotAbsensi($row->id_cabang, $row->id_departemen, $row->id_karyawan, $bulan, $periode_mulai, $periode_selesai, $data_pengaturan_potongan);
                $data_pot_absensi_karyawan[] = $pot_absensi_karyawan;

                $pot_absensi_t    = array_sum(array_column($pot_absensi_karyawan, 't_ttl')) ?: 0;
                $pot_absensi_pc   = array_sum(array_column($pot_absensi_karyawan, 'pc_ttl')) ?: 0;
                $pot_absensi_tap  = array_sum(array_column($pot_absensi_karyawan, 'tap_ttl')) ?: 0;
                $pot_absensi_alpa = array_sum(array_column($pot_absensi_karyawan, 'alpa_ttl')) ?: 0;
                $ttl_pot_absensi  = array_sum(array_column($pot_absensi_karyawan, 'ttl_potongan')) ?: 0;

                // BPJS KESEHATAN
                if (count($data_bpjs_kes[$row->id_karyawan]) > 0) {
                    $tunj_bpjs_kes = $data_bpjs_kes[$row->id_karyawan]['tunjangan'];
                    $pot_bpjs_kes  = $data_bpjs_kes[$row->id_karyawan]['potongan'];
                } else {
                    $tunj_bpjs_kes = 0;
                    $pot_bpjs_kes  = 0;
                }

                // BPJS TK
                if (count($data_bpjs_tk[$row->id_karyawan]) > 0) {
                    $tunj_bpjs_tk = $data_bpjs_tk[$row->id_karyawan]['tunjangan'];
                    $pot_bpjs_tk  = $data_bpjs_tk[$row->id_karyawan]['potongan'];
                } else {
                    $tunj_bpjs_tk = 0;
                    $pot_bpjs_tk  = 0;
                }

                // TOTAL TUNJANGAN
                $ttl_tunjangan = $ttl_tunj_kehadiran + $ttl_tunj_tetap + $ttl_tunj_tdk_tetap;

                // LEMBUR
                $ttl_lembur_rp    = 0;
                $lembur_pot_pph21 = 0;
                if ($data_lembur_karyawan[$row->id_karyawan]) {
                    $lembur_karyawan = $data_lembur_karyawan[$row->id_karyawan];
                    foreach ($lembur_karyawan as $value) {
                        $aturan_lembur         = $value['aturan_lembur'];
                        $lembur_ttl_menit      = $value['ttl_lembur'];
                        $lembur_jam            = intdiv((int)$lembur_ttl_menit, 60);
                        $lembur_menit          = ($lembur_ttl_menit % 60);
                        $lembur_perkalian      = [];
                        $lembur_rp             = 0;
                        $lembur_upah_per_jam   = 0;
                        $lembur_upah_per_menit = 0;
                        $salary                = ($nominal_gapok + (array_sum(array_values(nominal_pendapatan($row, $data_tunj_kehadiran[$row->id_karyawan], 'kehadiran')['nominal_upah_lembur'])) ?: 0) + (array_sum(array_values(nominal_pendapatan($row, $data_tunj_tetap[$row->id_karyawan], 'tetap')['nominal_upah_lembur'])) ?: 0));

                        // cek pembulatan waktu
                        if ($aturan_lembur['flag_rounding'] == '1') {
                            foreach ($aturan_lembur['pembulatan'] as $pembulatan) {
                                if ($lembur_menit >= ($pembulatan['menit_mulai']) && ($lembur_menit <= $pembulatan['menit_selesai'])) {
                                    $lembur_menit = $pembulatan['menit_dihitung'];
                                    break;
                                }
                            }
                        }

                        // cek perkalian Waktu
                        $lembur_per_jam = $lembur_jam;
                        foreach ($aturan_lembur['perkalian'] as $perkalian) {
                            if ($lembur_jam >= $perkalian['jam_mulai']) {
                                if ($lembur_jam <= $perkalian['jam_selesai']) {
                                    $lembur_perkalian[] = [
                                        'jam'  => $lembur_per_jam . '.' . $lembur_menit,
                                        'kali' => (float)$perkalian['perkalian'],
                                    ];
                                    break;
                                }
                                $lembur_per_jam -= (int)$perkalian['jam_selesai'];
                                $lembur_perkalian[] = [
                                    'jam'  => (int)$perkalian['jam_selesai'],
                                    'kali' => (float)$perkalian['perkalian'],
                                ];
                                continue;
                            }
                        }

                        // jenis upah lembur
                        if ($aturan_lembur['jenis_upah_lembur'] == 'flat') {
                            $lembur_upah_per_jam = $aturan_lembur['nominal_flat'];
                        }
                        if ($aturan_lembur['jenis_upah_lembur'] == 'prorate') {
                            $lembur_upah_per_jam = round($salary / $aturan_lembur['divide_prorate'], 2);
                        }

                        foreach ($lembur_perkalian as $lembur) {
                            // set upah lembur per menit
                            $lembur_upah_per_menit = ($lembur_upah_per_jam * $lembur['kali']) / 60;

                            // reformat jam ke menit
                            $format_menit = explode('.', $lembur['jam']);
                            if (count($format_menit) > 1) {
                                $format_menit = ((int)($format_menit[0] * 60) + (int)$format_menit[1]);
                            } else {
                                $format_menit = (int)($format_menit[0] * 60);
                            }

                            // hitung upah lembur karyawan
                            $lembur_rp += ($lembur_upah_per_menit * $format_menit);
                        }

                        // pembulatan total upah lembur
                        $lembur_rp = round($lembur_rp, 2);

                        // tambah ke data lembur trx
                        $data_lembur_trx[] = [
                            'id_lembur_trx'          => $value['id_lembur_r'],
                            'id_karyawan'            => $value['id_karyawan'],
                            'periode'                => $bulan,
                            'tgl_lembur'             => $value['tgl_lembur'],
                            'ttl_lembur'             => $lembur_ttl_menit,
                            'ttl_lembur_rounded'     => $lembur_jam . '.' . $lembur_menit,
                            'ttl_lembur_dikali'      => json_encode($lembur_perkalian),
                            'nominal_lembur_per_jam' => $lembur_upah_per_jam,
                            'ttl_lembur_rp'          => $lembur_rp,
                            'flag_pph21'             => $aturan_lembur['flag_pph21'] ?: '0',
                            'flag_pot_absensi'       => $aturan_lembur['flag_pot_absensi'] ?: '0',
                            'id_company'             => $this->id_company,
                            'user_input'             => $this->nik_karyawan . ' - ' . $this->nm_karyawan
                        ];

                        $ttl_lembur_rp += $lembur_rp;

                        // tambah ke proteksi jika diikutsertakan pot. absensi
                        if ($aturan_lembur['flag_pot_absensi'] == '1') {
                            $proteksi += $lembur_rp;
                        }

                        // jika diikutsertakan pot. pph21
                        if ($aturan_lembur['flag_pph21'] == '1') {
                            $lembur_pot_pph21 += $lembur_rp;
                        }
                    }
                }
                $get_lembur_karyawan = $this->findByIdKaryawan($data_lembur_trx, $row->id_karyawan);
                $ttl_lembur_menit    = empty($get_lembur_karyawan) ? 0 : array_sum(array_column($get_lembur_karyawan, 'ttl_lembur'));
                $upah_lembur_per_jam = empty($get_lembur_karyawan) ? 0 : array_column($get_lembur_karyawan, 'nominal_lembur_per_jam')[0];

                // TOTAL POTONGAN
                if ($ttl_pot_absensi > $proteksi) {
                    $ttl_pot_absensi_acc = $proteksi;
                } else {
                    $ttl_pot_absensi_acc = $ttl_pot_absensi;
                }
                $ttl_potongan = $ttl_pot_tetap + $ttl_pot_tdk_tetap + $ttl_pot_absensi_acc + $pot_bpjs_kes + $pot_bpjs_tk;

                // GAJI KOTOR
                $gaji_kotor = $nominal_gapok + $ttl_tunjangan + $ttl_lembur_rp;

                // THP
                $gaji_diterima = $gaji_kotor - $ttl_potongan;

                if ($row->id_karyawan) {
                    $temp_data_gaji = [
                        "id_karyawan"             => $row->id_karyawan,
                        "nik"                     => $row->nik,
                        "nm_karyawan"             => $row->nm_karyawan,
                        "id_jabatan"              => $row->id_jabatan,
                        "kd_jabatan"              => $row->kd_jabatan,
                        "nm_jabatan"              => $row->nm_jabatan,
                        "id_cabang"               => $row->id_cabang,
                        "kd_cabang"               => $row->kd_cabang,
                        "nm_cabang"               => $row->nm_cabang,
                        "id_departemen"           => ($row->id_departemen) ? $row->id_departemen : '',
                        "kd_departemen"           => ($row->kd_departemen) ? $row->kd_departemen : '',
                        "nm_departemen"           => ($row->nm_departemen) ? $row->nm_departemen : '',
                        "periode"                 => $bulan,
                        "tgl_mulai"               => $periode_mulai,
                        "tgl_selesai"             => $periode_selesai,
                        "gapok"                   => $nominal_gapok,
                        "tunj_kehadiran_ttl"      => $ttl_tunj_kehadiran,
                        "tunj_tetap_ttl"          => $ttl_tunj_tetap,
                        "tunj_tdk_tetap_ttl"      => $ttl_tunj_tdk_tetap,
                        "ttl_tunjangan"           => $ttl_tunjangan,
                        "lembur_menit"            => $ttl_lembur_menit,
                        "lembur_per_jam"          => $upah_lembur_per_jam,
                        "lembur_rp"               => $ttl_lembur_rp,
                        "pot_tetap_ttl"           => $ttl_pot_tetap,
                        "pot_tdk_tetap_ttl"       => $ttl_pot_tdk_tetap,
                        "pot_absensi_t"           => $pot_absensi_t,
                        "pot_absensi_pc"          => $pot_absensi_pc,
                        "pot_absensi_a"           => $pot_absensi_alpa,
                        "pot_absensi_tap"         => $pot_absensi_tap,
                        "pot_absensi_mak"         => $proteksi,
                        "pot_absensi_actual"      => $ttl_pot_absensi,
                        "pot_absensi_acc"         => $ttl_pot_absensi_acc,
                        "tunj_bpjs_kes"           => $tunj_bpjs_kes,
                        "pot_bpjs_kes"            => $pot_bpjs_kes,
                        "tunj_bpjs_tk"            => $tunj_bpjs_tk,
                        "pot_bpjs_tk"             => $pot_bpjs_tk,
                        "ttl_potongan"            => $ttl_potongan,
                        "ttl_tunj_dibiayai_perus" => ($tunj_bpjs_kes + $tunj_bpjs_tk),
                        "thp"                     => $gaji_diterima,
                        "bank_atas_nama"          => $row->bank_atas_nama,
                        "bank_rek"                => $row->bank_rek,
                        "bank_nama"               => $row->bank_nama,
                        "no_ktp"                  => $row->no_ktp,
                        "tanggungan"              => $row->tanggungan,
                        "npwp"                    => $row->npwp,
                        "publish_user"            => '',
                        "publish_sch"             => '',
                        "publish_tgl"             => '',
                        "id_company"              => $this->id_company,
                        "user_input"              => $this->nik_karyawan . ' - ' . $this->nm_karyawan
                    ];

                    // kebutuhan komponen kehadiran trx
                    if ($data_tunj_kehadiran[$row->id_karyawan]) {
                        foreach (nominal_pendapatan($row, $data_tunj_kehadiran[$row->id_karyawan], 'kehadiran')['update_kehadiran'] as $value) {
                            $data_kehadiran[] = $value;
                        }
                    }

                    // data gaji karyawan
                    $data_gaji_karyawan[] = $temp_data_gaji;

                    if ($pengaturan_pph->aktif === '1') {
                        $nominal_pph21 = [
                            'gapok'          => $nominal_gapok,
                            'tunj_lain'      => ($data_tunj_kehadiran[$row->id_karyawan] ? array_sum(array_values(nominal_pendapatan($row, $data_tunj_kehadiran[$row->id_karyawan], 'kehadiran')['nominal_pph21'])) : 0)
                                + ($data_tunj_tetap[$row->id_karyawan] ? array_sum(array_values(nominal_pendapatan($row, $data_tunj_tetap[$row->id_karyawan], 'tetap')['nominal_pph21'])) : 0)
                                + ($data_tunj_tdk_tetap[$row->id_karyawan] ? array_sum(array_values(nominal_pendapatan($row, $data_tunj_tdk_tetap[$row->id_karyawan], 'tidak tetap')['nominal_pph21'])) : 0)
                                + $lembur_pot_pph21
                                - $ttl_pot_absensi_acc
                                - ($data_pot_tetap[$row->id_karyawan] ? array_sum(array_values(nominal_potongan($data_pot_tetap[$row->id_karyawan])['nominal_pph21'])) : 0)
                                - ($data_pot_tdk_tetap[$row->id_karyawan] ? array_sum(array_values(nominal_potongan($data_pot_tdk_tetap[$row->id_karyawan])['nominal_pph21'])) : 0),
                            'iuran_pensiun'  => cek_empty($data_bpjs_tk[$row->id_karyawan]['iuran_pensiun']),
                            'premi_asuransi' => cek_empty($data_bpjs_kes[$row->id_karyawan]['tunjangan'] + $data_bpjs_tk[$row->id_karyawan]['premi_asuransi']),
                        ];

                        $temp_pph21                   = $this->Pph21_uu24_m->get_pph21($row, $bulan, $nominal_pph21, $pengaturan_pph, $objek_pajak);
                        $temp_pph21['tgl_pemotongan'] = $tgl_pemotong;
                        $data_pph21_karyawan[]        = $temp_pph21;
                        if ($pengaturan_pph->jenis == 'gross') {
                            $update_gaji_pph21[] = [
                                'concat(id_company,id_karyawan,periode)' => $this->id_company . $row->id_karyawan . $bulan,
                                'pot_pph21'                              => $temp_pph21['pph21'],
                                'ttl_potongan'                           => $temp_data_gaji['ttl_potongan'] + $temp_pph21['pph21'],
                                'thp'                                    => $temp_data_gaji['thp'] - $temp_pph21['pph21']
                            ];
                        }
                    }
                }
            }
        } else {
            $message = ["message" => "<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Data tidak ditemukan</font>"];
            return __response_save(false, $message);
        }

        $this->db->trans_start();
        $this->Komponen_m->insert($bulan);
        $this->Gaji_m->save($data_gaji_karyawan, $data_pot_absensi_karyawan, $bulan, $id_cabang, $id_departemen, $id_karyawan, $data_kehadiran);
        // insert data master lembur trx
        $this->Gaji_m->insert_master_lembur($data_lembur_trx);

        $is_pengaturan_pph_trx_exist = $this->db->get_where('payroll_pph21_p_trx', [
            'id_company'   => $this->id_company,
            'periode_gaji' => $bulan,
        ])->num_rows();
        if ($pengaturan_pph->aktif === '1' && count($data_pph21_karyawan) > 0) {
            // insert or update data pengaturan pph21
            $data_pengaturan_pph = array(
                'aktif'          => $pengaturan_pph->aktif,
                'jenis'          => $pengaturan_pph->jenis,
                'nm_pemotong'    => $pengaturan_pph->nm_pemotong,
                'jenis_pemotong' => $pengaturan_pph->jenis_pemotong,
                'npwp'           => $pengaturan_pph->npwp,
                'no_ktp'         => $pengaturan_pph->no_ktp,
                'id_company'     => $pengaturan_pph->id_company,
                'user_input'     => $pengaturan_pph->user_input,
            );

            if ($is_pengaturan_pph_trx_exist > 0) {
                $data_pengaturan_pph['tgl_update']  = date("Y-m-d H:i:s");
                $data_pengaturan_pph['user_update'] = $this->nik_karyawan . ' - ' . $this->nm_karyawan;
                // Update
                $this->db->update('payroll_pph21_p_trx', $data_pengaturan_pph, [
                    'id_company'   => $this->id_company,
                    'periode_gaji' => $bulan
                ]);
            } else {
                $data_pengaturan_pph['periode_gaji'] = $bulan;
                // Insert
                $this->db->insert('payroll_pph21_p_trx', $data_pengaturan_pph);
            }

            // delete and insert data trx pph21
            $this->Pph21_uu24_m->delete_pph($bulan, $id_cabang, $id_departemen, $id_karyawan);
            $this->db->insert_batch('payroll_pph21_trx_uu24', $data_pph21_karyawan);

            // update pph21 pada gaji
            if (count($update_gaji_pph21) > 0) {
                $this->Pph21_uu24_m->update_gaji($update_gaji_pph21);
            }
        } else {
            if ($is_pengaturan_pph_trx_exist > 0) {
                // delete data pengaturan pph21 trx
                $this->db->delete('payroll_pph21_p_trx', [
                    'id_company'   => $this->id_company,
                    'periode_gaji' => $bulan
                ]);
            }

            // delete data trx pph21
            $this->Pph21_uu24_m->delete_pph($bulan, $id_cabang, $id_departemen, $id_karyawan);
        }
        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_save(false);
        } else {
            $this->db->trans_commit();
            $message = ["message" => '<font color="#009900"><i class="fa fa-check-square">&nbsp;</i>Gaji bulan ' . date('m-Y', strtotime($bulan . '-01')) . ' berhasil dihitung</font>'];
            return __response_save(true, $message);
        }
    }

    public function publish_all()
    {
        $bulan  = date_format(date_create("01-" . $this->input->post("bulan")), "Y-m");
        $jadwal = $this->input->post("jadwal");
        $jadwal = ($jadwal) ? date("Y-m-d", strtotime($jadwal)) : date("Y-m-d");

        $data = array(
            "publish_flag" => "1",
            "publish_user" => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
            "publish_sch"  => $jadwal,
            "publish_tgl"  => date("Y-m-d H:i:s"),
            "user_update"  => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
            "tgl_update"   => date("Y-m-d H:i:s"),
        );

        // $this->send_messageBroker('Informasi Gaji','Gaji Bulan '.$this->fungsi->get_bulan($periode).' Sudah dipublish', $periode);

        $this->db->where('periode', $bulan);
        $this->db->where('id_company', $this->id_company);
        $update = $this->db->update('payroll_gaji_trx', $data);
        if ($update) {
            $message = array("message" => '<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Gaji periode ' . date('m-Y', strtotime($bulan . '-01')) . ' berhasil di publish semua</font>');
            return __response_save(true, $message);
        } else {
            $message = array('message' => '<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>Gaji periode ' . date('m-Y', strtotime($bulan . '-01')) . ' gagal di publish semua</font>');
            return __response_save(false, $message);
        }
    }

    public function unpublish_all()
    {
        $bulan = date_format(date_create("01-" . $this->input->post("bulan")), "Y-m");
        $data  = array(
            "publish_flag" => "0",
            "publish_user" => "",
            "publish_sch"  => "",
            "publish_tgl"  => "",
            "user_update"  => $this->nik_karyawan . ' - ' . $this->nm_karyawan,
            "tgl_update"   => date("Y-m-d H:i:s")
        );

        $this->db->where('periode', $bulan);
        $this->db->where('id_company', $this->id_company);
        $update = $this->db->update('payroll_gaji_trx', $data);
        if ($update) {
            $message = array("message" => '<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Gaji periode ' . date('m-Y', strtotime($bulan . '-01')) . ' berhasil di unpublish semua</font>');
            return __response_save(true, $message);
        } else {
            $message = array('message' => '<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>Gaji periode ' . date('m-Y', strtotime($bulan . '-01')) . ' gagal di unpublish semua</font>');
            return __response_save(false, $message);
        }
    }

    public function publish_unpublish()
    {
        $key = $this->input->post("id");

        $this->db->select("id_karyawan, bulan");
        $this->db->where("md5(concat(id_karyawan,bulan))", $key);
        $data_karyawan = $this->db->get("payroll_gaji")->row();

        $publish = $this->input->post("publish");
        $data    = array(
            "flag_publish" => $publish,
            "tgl_publish"  => date("Y-m-d H:i:s"),
            "user_publish" => $this->id_karyawan
        );

        $this->db->where(array('md5(concat(id_karyawan,bulan))' => $key, 'id_company' => $this->id_company));
        $update = $this->db->update('payroll_gaji', $data);
        if ($update) {
            if ($publish == "1") {
                $message = array("message" => '<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Gaji berhasil di publish</font>');
                // $this->send_messageBroker_perId('Informasi Gaji', 'Gaji Bulan '.$this->fungsi->get_bulan($data_karyawan->bulan).' Sudah dipublish', $data_karyawan->id_karyawan, $data_karyawan->bulan);
            } else {
                $message = array("message" => '<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Gaji berhasil di unpublish</font>');
            }
            return __response_save(true, $message);
        } else {
            if ($publish == "1") {
                $message = '<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal di publish</font>';
            } else {
                $message = '<font color="#ffffff"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal di unpublish</font>';
            }
            return __response_save(false, $message);
        }
    }


    public function delete()
    {
        $id_karyawan = $this->input->post("id");
        $bulan       = $this->input->post("bulan");

        $this->db->trans_start();

        // DELETE GAJI
        $this->db->where("md5(id_karyawan)", $id_karyawan);
        $this->db->where("periode", $bulan);
        $this->db->where("id_company", $this->id_company);
        $this->db->delete("payroll_gaji_trx");
        $this->logger->create_log('payroll_hitung_gaji', 'delete', $this->db->last_query());

        $where_update = [
            "md5(id_karyawan)" => $id_karyawan,
            "periode"          => $bulan,
            "id_company"       => $this->id_company
        ];

        // UPDATE POT TIDAK TETAP
        $this->db->update("payroll_pot_tdk_tetap_m", ["flag_gaji" => "1"], $where_update);
        $this->db->update("payroll_pot_tdk_tetap_m", ["flag_gaji" => "0"], $where_update);

        // UPDATE TUNJ TIDAK TETAP
        $this->db->update("payroll_tunj_tdk_tetap_m", ["flag_gaji" => "1"], $where_update);
        $this->db->update("payroll_tunj_tdk_tetap_m", ["flag_gaji" => "0"], $where_update);

        $this->db->trans_complete();

        if ($this->db->trans_status() === FALSE) {
            $this->db->trans_rollback();
            return __response_delete(false);
        } else {
            $this->db->trans_commit();
            $message = ["message" => '<font color="#ffffff"><i class="fa fa-check-square">&nbsp;</i>Berhasil menghapus data gaji bulan ' . date('m-Y', strtotime($bulan . '-01')) . '</font>'];
            return __response_delete(true, $message);
        }
    }

    public function download_excel($bulan = null, $id_cabang = null, $id_departemen = null, $id_karyawan = null)
    {
        if ($id_cabang == 'undefined' || $id_departemen == 'undefined' || $id_karyawan == 'undefined') {
            $id_cabang     = 'all';
            $id_departemen = 'all';
            $id_karyawan   = 'all';
        }

        $bulan1 = $this->fungsi->get_bulan($bulan);
        $tahun  = $this->fungsi->get_tahun($bulan);

        $bulan2 = date_format(date_create("01-" . $bulan), "Y-m");

        $data["data"] = $this->Gaji_m->download_excel($bulan2, $id_cabang, $id_departemen, $id_karyawan);

        if ($id_cabang == "all" && $id_departemen == "all" && $id_karyawan == "all") {
            $filename = "GAJI SEMUA CABANG";
        } else {
            $filename = "GAJI";
        }

        if ($id_karyawan != "all") {
            $nama_karyawan = $this->db->select("nama_lengkap")
                ->from("data_karyawan")
                ->where("md5(id_karyawan)", $id_karyawan)
                ->where("id_company", $this->id_company)
                ->get()
                ->row("nama_lengkap");
            $filename .= " " . $nama_karyawan;
        }

        if ($id_cabang != "all") {
            $nama_cabang = $this->db->select("nama")
                ->from("master_cabang")
                ->where("id_cabang", $id_cabang)
                ->where("id_company", $this->id_company)
                ->get()
                ->row("nama");

            $filename .= " CABANG " . $nama_cabang;
        }

        if ($id_departemen != "all") {
            $nama_departemen = $this->db->select("nama")
                ->from("master_departemen")
                ->where("id_departemen", $id_departemen)
                ->where("id_company", $this->id_company)
                ->get()
                ->row("nama");

            $filename .= " DEPARTEMEN " . $nama_departemen;
        }

        $data["filename"]                = $filename;
        $data["periode"]                 = $bulan1 . " " . $tahun;
        $data['komponen_tunj_tetap']     = $this->Komponen_m->master_trx($bulan2, 'tetap', 'pendapatan');
        $count_komponen_tunj_tetap       = count($data['komponen_tunj_tetap']->result());
        $data['komponen_tunj_tdk_tetap'] = $this->Komponen_m->master_trx($bulan2, 'tidak tetap', 'pendapatan');
        $count_komponen_tunj_tdk_tetap   = count($data['komponen_tunj_tdk_tetap']->result());
        $data['komponen_tunj_kehadiran'] = $this->Komponen_m->master_trx($bulan2, 'tetap', 'kehadiran');
        $count_komponen_tunj_kehadiran   = count($data['komponen_tunj_kehadiran']->result());
        $data['komponen_pot_tetap']      = $this->Komponen_m->master_trx($bulan2, 'tetap', 'potongan');
        $count_komponen_pot_tetap        = count($data['komponen_pot_tetap']->result());
        $data['komponen_pot_tdk_tetap']  = $this->Komponen_m->master_trx($bulan2, 'tidak tetap', 'potongan');
        $count_komponen_pot_tdk_tetap    = count($data['komponen_pot_tdk_tetap']->result());

        $data['data_tunj_tetap_trx']     = json_decode($this->Komponen_m->tunj_tetap_trx($bulan2), true);
        $data['data_tunj_tdk_tetap_trx'] = json_decode($this->Komponen_m->tunj_tdk_tetap_trx($bulan2), true);
        $data['data_tunj_kehadiran_trx'] = json_decode($this->Komponen_m->tunj_kehadiran_trx($bulan2), true);
        $data['data_pot_tetap_trx']      = json_decode($this->Komponen_m->pot_tetap_trx($bulan2), true);
        $data['data_pot_tdk_tetap_trx']  = json_decode($this->Komponen_m->pot_tdk_tetap_trx($bulan2), true);

        $sb_view = $this->load->view('payroll/gaji/download_excel', $data, true);
        // echo $sb_view;
        // exit;
        $total_komponen = $count_komponen_tunj_tetap + $count_komponen_tunj_tdk_tetap + $count_komponen_pot_tetap + $count_komponen_pot_tdk_tetap;

        $format_columns = [
            'A' => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
            'B' => ['align' => 'left', 'format' => 'text', 'valign' => 'middle'],
            'C' => ['align' => 'left', 'format' => 'text', 'valign' => 'middle'],
            'D' => ['width' => 9, 'align' => 'left', 'format' => 'text', 'valign' => 'middle'],
            'E' => ['align' => 'left', 'format' => 'text', 'valign' => 'middle'],
            'F' => ['align' => 'left', 'format' => 'text', 'valign' => 'middle'],
            'G' => ['align' => 'center', 'valign' => 'middle'],
            'H' => ['width' => 12, 'valign' => 'middle', 'format' => 'text', 'rupiah' => true],
        ];

        $initial_column = 'I';
        // KOMPONEN TUNJANGAN
        if ($count_komponen_tunj_tetap > 0) {
            for ($i = 0; $i < $count_komponen_tunj_tetap; $i++) {
                $format_columns[$initial_column] = ['width' => 20, 'valign' => 'middle', 'format' => 'text', 'rupiah' => true];
                $initial_column++;
            }
        }
        if ($count_komponen_tunj_tdk_tetap > 0) {
            for ($i = 0; $i < $count_komponen_tunj_tdk_tetap; $i++) {
                $format_columns[$initial_column] = ['width' => 20, 'valign' => 'middle', 'format' => 'text', 'rupiah' => true];
                $initial_column++;
            }
        }
        if ($count_komponen_tunj_kehadiran > 0) {
            for ($i = 0; $i < $count_komponen_tunj_kehadiran; $i++) {
                $format_columns[$initial_column] = ['width' => 20, 'valign' => 'middle', 'format' => 'text', 'rupiah' => true];
                $initial_column++;
            }
        }
        // TOTAL TUNJANGAN & LEMBUR
        for ($i = 0; $i < 5; $i++) {
            $format_columns[$initial_column] = ['width' => 11, 'valign' => 'middle', 'format' => 'text', 'rupiah' => true];
            $initial_column++;
        }
        // KOMPONEN POTONGAN
        if ($count_komponen_pot_tetap > 0) {
            for ($i = 0; $i < $count_komponen_pot_tetap; $i++) {
                $format_columns[$initial_column] = ['width' => 20, 'valign' => 'middle', 'format' => 'text', 'rupiah' => true];
                $initial_column++;
            }
        }
        if ($count_komponen_pot_tdk_tetap > 0) {
            for ($i = 0; $i < $count_komponen_pot_tdk_tetap; $i++) {
                $format_columns[$initial_column] = ['width' => 20, 'valign' => 'middle', 'format' => 'text', 'rupiah' => true];
                $initial_column++;
            }
        }
        // NEXT COLUMN
        for ($i = 0; $i < 10; $i++) {
            $format_columns[$initial_column] = ['width' => 12, 'valign' => 'middle', 'format' => 'text', 'rupiah' => true];
            $initial_column++;
        }
        // PUBLISH
        for ($i = 0; $i < 3; $i++) {
            $format_columns[$initial_column] = ['width' => 15, 'align' => 'center', 'valign' => 'middle'];
            $initial_column++;
        }

        $c_length = 24 + $total_komponen;
        $param    = [
            'download'     => true,
            'cLength'      => $c_length,
            'file_name'    => strtoupper(str_replace(" ", "_", $filename)),
            'paper_size'   => 'A4',
            'font-size'    => 9,
            // 'pagebreak'   => true,
            'page_margin'  => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation'  => 'potrait',
            'header'       => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],

            ],
            'freezecolumn' => ['G7'],
            'thead'        => ['4', '5', '6'],
            'tbody'        => [
                'start'  => '4',
                'height' => 13,
                'column' => $format_columns,
                // 'wrap'   => ['H', 'I', 'N', 'O', 'P', 'U'],
            ],
        ];

        $this->load->library('PHPExcel/Excel');
        $this->excel->generateExcel($sb_view, $param);
    }

    public function download_pdf($token)
    {
        $this->load->library('mpdf');

        $slip = $this->Gaji_m->slip($token);
        if ($slip->publish_flag == '0') {
            echo 'slip gaji belum dipublish';
            exit;
        } elseif (date('Y-m-d H:i:s') < $slip->publish_sch) {
            echo 'schedule publish slip gaji pada ' . date('d-m-Y H:i:s');
            exit;
        }

        $data['data']           = $slip;
        $data['tunj_tetap']     = $this->Gaji_m->tunj_tetap_karyawan($token);
        $data['tunj_tdk_tetap'] = $this->Gaji_m->tunj_tdk_tetap_karyawan($token);
        $data['tunj_kehadiran'] = $this->Gaji_m->tunj_kehadiran_karyawan($token);
        $data['pot_tetap']      = $this->Gaji_m->pot_tetap_karyawan($token);
        $data['pot_tdk_tetap']  = $this->Gaji_m->pot_tdk_tetap_karyawan($token);
        // echo $this->db->last_query();exit;
        $html = $this->load->view('payroll/gaji/download_pdf', $data, true);

        $param['page_number']    = true;
        $param['show_watermark'] = false;
        $param['custom_font']    = false;
        $param['download']       = (!empty($this->input->get('dl')) ? filter_var($this->input->get('dl'), FILTER_VALIDATE_BOOLEAN) : true);
        $param['nama_company']   = 'www.absenku.com';
        $filename                = "SLIP GAJI BULAN " . date("m-Y", strtotime($slip->periode . '-01')) . " " . $slip->nik . " - " . $slip->nm_karyawan;
        $this->mpdf->generate($html, $filename, 'A4', 'P', $param);
    }

    public function download_excel_bank($bulan = "00-0000", $cabang = "all", $departemen = "all", $karyawan = "all")
    {
        $bulanDefault = $bulan;
        $bulan        = $this->periode($bulan);
        // FILENAME
        $nama_bulan = substr($bulan, -2);
        if ($karyawan != "all") {
            $nama_karyawan = $this->laporan_pph->nama_karyawan($karyawan);
            $filename      = "Daftar Transfer Bank " . $nama_karyawan;
        } else {
            if ($departemen != "all") {
                $nama_cab = $this->laporan_pph->nama_cabang($cabang);
                $nama_dep = $this->laporan_pph->nama_departemen($departemen);
                $nama     = "Daftar Transfer Bank Cabang " . $nama_cab . " Departemen " . str_replace("/", "-", $nama_dep);
                $filename = $nama;
            } else {
                if ($cabang != "all") {
                    $nama     = $this->laporan_pph->nama_cabang($cabang);
                    $filename = "Daftar Transfer Bank Cabang " . $nama . " Semua Departemen";
                } else {
                    $nama     = "Daftar Transfer Bank Semua Cabang";
                    $filename = $nama;
                }
            }
        }

        $bulan1 = $this->fungsi->get_bulan($bulanDefault);
        $tahun  = $this->fungsi->get_tahun($bulanDefault);

        $data["filename"] = $filename;
        $data["periode"]  = $bulan1 . " " . $tahun;
        $data["data"]     = $this->Gaji_m->download_excel_transfer_bank($bulan, $cabang, $departemen, $karyawan);
        $sb_view          = $this->load->view('payroll/gaji/download_excel_transfer_bank', $data, true);

        $param = [
            'download'     => true,
            'cLength'      => 5,
            'file_name'    => strtoupper(str_replace(" ", "_", $filename) . '_' . $bulan1),
            'paper_size'   => 'A4',
            'font-size'    => 9,
            // 'pagebreak'   => true,
            'page_margin'  => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation'  => 'potrait',
            'header'       => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
            ],
            'freezecolumn' => ['A5'],
            'thead'        => ['4'],
            'tbody'        => [
                'start'  => '4',
                'height' => 15,
                'wrap'   => ['B', 'C'],
                'column' => [
                    'A' => ['width' => 10, 'align' => 'center', 'valign' => 'middle'],
                    'B' => ['align' => 'left', 'format' => 'text', 'valign' => 'middle'],
                    'C' => ['align' => 'left', 'format' => 'text', 'valign' => 'middle'],
                    'D' => ['align' => 'left', 'format' => 'text', 'valign' => 'middle'],
                    'E' => ['rupiah' => true, 'format' => 'text', 'valign' => 'middle'],
                    'F' => ['rupiah' => true, 'format' => 'text', 'valign' => 'middle'],
                ],
            ],
        ];

        $this->load->library('PHPExcel/Excel');
        $this->excel->generateExcel($sb_view, $param);
    }

    public function periode($bulan)
    {
        return date_format(date_create("01-" . $bulan), "Y-m");
    }

    private function findByIdKaryawan($array, $id_karyawan)
    {
        return array_filter($array, function ($item) use ($id_karyawan) {
            return $item['id_karyawan'] == $id_karyawan;
        });
    }
}
