<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Karir_pekerjaan extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Karir_pekerjaan_m');
    }

    public function home($id_karyawan_md5)
    {
        $data['judul']           = $this->lang->line('menu_karyawan');
        $data['aktif']           = 'karyawan';
        $data['tab_karyawan']    = 'karir_verifikasi';
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $data['menu']            = $this->load->view('main_menu', $data, true);
        $data['content']         = $this->load->view('karyawan/menu', $data, true);
        $this->load->view('main_template', $data);
    }

    public function main($id_karyawan_md5 = null)
    {
        $data['id_karyawan_md5'] = $id_karyawan_md5;
        $this->load->view('karyawan/karir_pekerjaan/home', $data);
    }

    public function list_data($id_karyawan = null)
    {
        $data['data'] = $this->Karir_pekerjaan_m->getDataByIdKaryawan($id_karyawan);
        $this->load->view('karyawan/karir_pekerjaan/list_data', $data);
    }

    public function form($id_karyawan = null, $id_karir_pekerjaan = null)
    {
        $data['id_karyawan'] = $id_karyawan;
        if ($id_karir_pekerjaan != null) {
            $data['data'] = $this->Karir_pekerjaan_m->getDataById($id_karir_pekerjaan);

            $nama_departemen = $data['data']->nama_departemen;
            if (empty($nama_departemen)) {
                $data['form_departemen'] = 'style="display:none"';
            } else {
                $data['form_departemen'] = '';
            }
        }
        $this->load->view('karyawan/karir_pekerjaan/form', $data);
    }

    public function save()
    {
        $id = $this->input->post('id_karir_pekerjaan');

        $data = array(
            'nomor_surat_keputusan' => $this->input->post('nomor_surat_keputusan'),
            'id_karyawan'           => $this->input->post('id_karyawan'),
            'kode_jabatan'          => $this->input->post('kode_jabatan'),
            'nama_jabatan'          => $this->input->post('nama_jabatan'),
            'kode_cabang'           => $this->input->post('kode_cabang'),
            'nama_cabang'           => $this->input->post('nama_cabang'),
            'kode_departemen'       => $this->input->post('kode_departemen'),
            'nama_departemen'       => $this->input->post('nama_departemen'),
            'tgl_mulai'             => date('Y-m-d', strtotime($this->input->post('tgl_mulai'))),
            'tgl_berakhir'          => date('Y-m-d', strtotime($this->input->post('tgl_akhir'))),
            'status'                => $this->input->post('status'),
            'keterangan_status'     => $this->input->post('keterangan_status'),
            'id_company'            => $this->session->userdata('id_company')
        );

        $this->Karir_pekerjaan_m->save($data, $id);
    }

    public function delete()
    {
        $id = $this->input->post("id_karir_pekerjaan");
        $this->Karir_pekerjaan_m->delete($id);
    }
}
