<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quick_setup_cabang extends MY_Controller{

  public function __construct()
  {
    parent::__construct();
    $this->load->model('quick_setup_cabang_m', 'q_cabang_m');
  }

  function index()
  {
    $data['aktif'] = 'kelola_mudah';
    $data['judul'] = 'Quick Setup Cabang';
    $data['jenis'] = 'cabang';
    $data['menu'] = $this->load->view('main_menu', $data, true);
    $data['menu_quick_setup'] = $this->load->view('quick_setup/menu', $data, true);
    $data['main'] = $this->load->view('quick_setup/cabang/main', $data, true);
    $data['table'] = $this->load->view('quick_setup/cabang/table', $data, true);
    $data['content'] = $this->load->view('quick_setup/main', $data, true);
    $this->load->view('main_template', $data, false);
  }

  public function list_data(){
    $this->load->model('quick_setup_cabang_m');
		$list = $this->quick_setup_cabang_m->get_datatables();
		$data = array();
    $no = $_POST['start'];
		foreach ($list as $field) {
      $no++;
			$row = array();
      $row[] = $no;
			$row[] = $field->kode;
			$row[] = $field->nama;
			$row[] = $field->lat_asli.','.$field->long_asli;
      $row[] = $field->jarak;
      $row[] = '<a href="#" data-target="tooltip" title="Edit" style="color:#434343;" class="text-warning"
                  onclick="edit(\''.$field->id_cabang.'\',\''.$field->id_lokasi_kantor.'\')">
                  <i id="" class="btn_edit fa fa-edit"></i>
                </a>&nbsp;
                <a href="#" data-target="tooltip" title="Delete" style="color:#434343;" class="text-danger"
                  onclick="hapus(\''.$field->id_cabang.'\',\''.$field->id_lokasi_kantor.'\')">
                    <i id="" class="btn_delete fa fa-trash"></i>
                </a>';

			$data[] = $row;
		}

		$output = array("draw"            => $_POST['draw'],
						"recordsTotal"    => $this->quick_setup_cabang_m->count_all(),
						"recordsFiltered" => $this->quick_setup_cabang_m->count_filtered(),
						"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

  function save() {
    //master cabang
    $kode_cabang  = $this->input->post('kode');
    $cabang       = $this->input->post('cabang');
    $cek_kode     = $this->q_cabang_m->cek_kode($kode_cabang);
    if($cek_kode > 0) {
      return __response_save(false, array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode cabang sudah digunakan</font>'));
    } else {
      $cek_nama = $this->q_cabang_m->cek_nama($cabang);
      if($cek_nama > 0) {
        return __response_save(false, array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Nama cabang sudah digunakan</font>'));
      } else {
        $flag         = '2';
        $id_company   = $this->session->userdata('id_company');
        $id_cabang    = $this->fungsi->getNextId('master_cabang','id_cabang',$id_company,3);

        //data cabang
        $data_cabang = array(
          'kode'        => $kode_cabang,
    			'nama'			  => $cabang,
    			'flag'			  => $flag,
    			'id_company' 	=> $id_company
        );

        //master lokasi
        $latlong  = $this->input->post('latlong');
        $temp     = explode(",", $latlong);
        $lat      = $temp[0];
        $lon      = $temp[1];
        $distance = $this->input->post('radius') / 1000;
        $R        = 6371; //constant earth radius. You can add precision here if you wish

        $maxLat = $lat + rad2deg($distance / $R);
        $minLat = $lat - rad2deg($distance / $R);
        $maxLon = $lon + rad2deg(asin($distance / $R) / cos(deg2rad($lat)));
        $minLon = $lon - rad2deg(asin($distance / $R) / cos(deg2rad($lat)));

        $nextId = $this->fungsi->getNextId('data_lokasi_kantor','id_lokasi_kantor',$_SESSION['id_company'],3);

        $data_lokasi = array(
            'id_lokasi_kantor'  => $nextId,
            'nama_kantor'       => $cabang,
            'lat_asli'          => $lat,
            'lat_min'           => $minLat,
            'lat_max'           => $maxLat,
            'long_asli'         => $lon,
            'long_min'          => $maxLon,
            'long_max'          => $minLon,
            'jarak'             => $this->input->post('radius'),
            'id_company'        => $id_company,
            'id_cabang'         => $id_cabang,
            'flag'              => '0'
        );

        $this->q_cabang_m->save($data_cabang, $id_cabang, $data_lokasi, $id_company);
      }
    }
  }

  function update() {
    //master cabang
    $cabang       = $this->input->post('cabang');
    $kode_cabang  = $this->input->post('kode');
    $cabang_temp  = $this->input->post('cabang_temp');
    $kode_temp    = $this->input->post('kode_temp');
    $equal        = strcasecmp($kode_temp, $kode_cabang);
    $equal_cabang = strcasecmp($cabang_temp, $cabang);
    if($equal == 0 and $equal_cabang == 0) {
      $this->sub_update();
    } elseif($equal != 0 and $equal_cabang == 0) {
      $cek_kode = $this->q_cabang_m->cek_kode($kode_cabang);
      if($cek_kode > 0) {
        return __response_update(false, array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode cabang sudah digunakan</font>'));
      } else {
        $this->sub_update();
      }
    } elseif($equal == 0 and $equal_cabang != 0) {
      $cek_nama = $this->q_cabang_m->cek_nama($cabang);
      if($cek_nama > 0) {
        return __response_update(false, array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Nama cabang sudah digunakan</font>'));
      } else {
        $this->sub_update();
      }
    } else {
      $cek_kode = $this->q_cabang_m->cek_kode($kode_cabang);
      if($cek_kode > 0) {
        return __response_update(false, array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Kode cabang sudah digunakan</font>'));
      } else {
        $cek_nama = $this->q_cabang_m->cek_nama($cabang);
        if($cek_nama > 0) {
          return __response_update(false, array('message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>Nama cabang sudah digunakan</font>'));
        } else {
          $this->sub_update();
        }
      }
    }
  }

  function sub_update() {
    //fungsi update yang asli jika sudah selesai melewati pengecekan
    $cabang       = $this->input->post('cabang');
    $kode_cabang  = $this->input->post('kode');
    $flag         = '2';
    $id_company   = $this->session->userdata('id_company');
    $id_cabang    = $this->input->post('id_cabang');

    //data cabang
    $data_cabang = array(
      'kode'        => $kode_cabang,
			'nama'			  => $cabang,
			'flag'			  => $flag,
			'id_company' 	=> $id_company
    );

    //master lokasi
    $latlong  = $this->input->post('latlong');
    $temp     = explode(",", $latlong);
    $lat      = $temp[0];
    $lon      = $temp[1];
    $distance = $this->input->post('radius') / 1000;
    $R        = 6371; //constant earth radius. You can add precision here if you wish

    $maxLat = $lat + rad2deg($distance / $R);
    $minLat = $lat - rad2deg($distance / $R);
    $maxLon = $lon + rad2deg(asin($distance / $R) / cos(deg2rad($lat)));
    $minLon = $lon - rad2deg(asin($distance / $R) / cos(deg2rad($lat)));

    $id_lokasi_kantor = $this->input->post('id_lokasi_kantor');

    $data_lokasi = array(
        'nama_kantor'       => $cabang,
        'lat_asli'          => $lat,
        'lat_min'           => $minLat,
        'lat_max'           => $maxLat,
        'long_asli'         => $lon,
        'long_min'          => $maxLon,
        'long_max'          => $minLon,
        'jarak'             => $this->input->post('radius'),
        'id_company'        => $id_company,
        'id_cabang'         => $id_cabang,
        'flag'              => '0'
    );

    $this->q_cabang_m->update($data_cabang, $id_cabang, $data_lokasi, $id_lokasi_kantor);
  }

  function delete() {
    $id_cabang        = $this->input->post('id_cabang');
    $id_lokasi_kantor = $this->input->post('id_lokasi_kantor');

    $this->q_cabang_m->delete($id_cabang, $id_lokasi_kantor);
  }

  function detail($id_cabang, $id_lokasi_kantor) {
    $detail = $this->q_cabang_m->detail($id_cabang, $id_lokasi_kantor);
    $data['kode']         = $detail->kode;
    $data['nama']         = $detail->nama;
    $data['jarak']        = $detail->jarak;
    $data['latlong']      = $detail->lat_asli.','.$detail->long_asli;
    $data['nama_kantor']  = $detail->nama_kantor;
    echo json_encode($data);
  }
}
