<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pengaturan_notif extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Pengaturan_notif_m');
    }

	public function index(){
		$data['judul'] = 'Pengaturan Notif';
		$data['aktif'] = 'pengaturan_notif';
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('pengaturan_notif/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
		$list = $this->Pengaturan_notif_m->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->nik." - ".$field->nama_lengkap;
			if ($field->notif_hrd == "1") {
				$notif_hrd = "Ya";
			}else{
				$notif_hrd = "Tidak";
			}
			$row[] = $notif_hrd;

			if ($field->notif_finance == "1") {
				$notif_finance = "Ya";
			}else{
				$notif_finance = "Tidak";
			}
			$row[] = $notif_finance;

			$row[] = '<a href="#" class="text-warning" title="EDIT">
							<i id="'.md5($field->id_notification).'" class="btn_edit fa fa-edit (alias) "> </i></a>&nbsp;
						<a href="#" class="text-danger" title="HAPUS">
							<i id="'.md5($field->id_notification).'" class="btn_delete fa fa-trash"></i>
						</a>';

			$data[] = $row;
		}

			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $this->Pengaturan_notif_m->count_all(),
							"recordsFiltered" => $this->Pengaturan_notif_m->count_filtered(),
							"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function form($id=null){
		if($id==null){
			$this->load->view('pengaturan_notif/form');
		}else{
			$data['data'] = $this->Pengaturan_notif_m->getDataById($id);
			$this->load->view('pengaturan_notif/form',$data);
		}

	}

	public function save(){
		/*var_dump($_POST);
		exit();*/
		$id = $this->input->post('id_notification');
		$hak_akses = $this->input->post('hak_akses');
		if ($hak_akses == '1') {
			$notif_hrd 	   = "1";
			$notif_finance = "0";
		}elseif($hak_akses == '2'){
			$notif_hrd 	   = "0";
			$notif_finance = "1";
		}
		$data = array('id_karyawan'	=>$this->input->post('id_karyawan'),
					'notif_hrd'		=>$notif_hrd,
					'notif_finance'	=>$notif_finance,
					'id_company' 	=>$_SESSION['id_company']);

		$this->Pengaturan_notif_m->save($data,$id);
	}

	public function delete(){
		$id = $this->input->post("id_notification");
		$this->Pengaturan_notif_m->delete($id);
	}
}
