<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Akun_reimburse extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('Akun_reimburse_m');
    }

	public function index(){
		$data['judul'] = 'Akun Reimbursement';
		$data['aktif'] = 'akun_plafon';
		$id_company = $this->session->userdata('id_company');
        $data['menu'] = $this->load->view('main_menu', $data, true);
		$data['content'] = $this->load->view('akun_reimburse/home', $data, true);
		$this->load->view('main_template', $data, false);
	}

	public function list_data(){
		$list = $this->Akun_reimburse_m->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
            $row[] = $field->kode_akun;
            $row[] = $field->nama_akun;

            if(in_array($this->session->userdata('level_user'), array("6")) || in_array($this->session->userdata('level_khusus'), array("6"))) {

				$row[] = '<a href="#" style="color:#f0ad4e" data-target="tooltip" title="Ubah">
								<i id="'.md5($field->id_akun).'" class="btn_edit fa fa-edit (alias) "> </i>
						</a>&nbsp;
						<a href="#" style="color:#d9534f" data-target="tooltip" title="Hapus">
							<i id="'.md5($field->id_akun).'" class="btn_delete fa fa-trash"></i>
						</a>';
            }

			$data[] = $row;
		}

			$output = array("draw"            => $_POST['draw'],
							"recordsTotal"    => $this->Akun_reimburse_m->count_all(),
							"recordsFiltered" => $this->Akun_reimburse_m->count_filtered(),
							"data"            => $data);

			$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function form($id=null){
		if($id == null){
			$this->load->view('akun_reimburse/form');
		}else{
			$data['data'] = $this->Akun_reimburse_m->getDataById($id);
			$this->load->view('akun_reimburse/form',$data);
		}

	}

	public function save(){
		$id_company = $this->session->userdata('id_company');
		$id = $this->input->post('id_akun');

		$data = array('kode_akun'		=>$this->input->post('kode_akun'),
					'nama_akun'			=>$this->input->post('nama_akun'),
					'id_company' 		=>$id_company);

		$this->Akun_reimburse_m->save($data,$id);
	}

	public function delete(){
		$id = $this->input->post("id_akun");
		$this->Akun_reimburse_m->delete($id);
	}
}
