<?php
$CI = & get_instance();
?>
<script type="text/javascript">
    $(function() {

        datatables_calendar();

        $(document).on('click', '#btn_tab_kalender_view', function () {
            thumbnail_calendar()
        });

        $(document).on('click', '#btn_tab_list_view', function () {
            datatables_calendar();
        });


        $(document).on('click', '#btn_search', function () {
            datatables_calendar();
        });

        $('.datepicker').datepicker({
            autoclose: true,
            language: "id",
            locale: "id",
            todayHighlight: true
        });

        $(".dateonly").keydown(function (e) {
            // Allow: backspace, delete, tab, escape, enter and
            if ($.inArray(e.keyCode, [46, 8, 9, 27, 13, 110, 189]) !== -1 ||
                // Allow: Ctrl+A
                (e.keyCode == 65 && e.ctrlKey === true) ||
                // Allow: home, end, left, right, down, up
                (e.keyCode >= 35 && e.keyCode <= 40)) {
                    // let it happen, don't do anything
                    return;
            }
            // Ensure that it is a number and stop the keypress
            if ((e.shiftKey || (e.keyCode < 48 || e.keyCode > 57)) && (e.keyCode < 96 || e.keyCode > 105)) {
                e.preventDefault();
                $("#jumlah_barang").focus();
                return false();
            }
        });

        $(document).on('click','.btn_tambah',function(){
            $('#tampil_form').load("<?= site_url('pengaturan/hari-libur/form/tambah') ?>",function(){
                $('#modal_form').modal('show');
                $(".title").text("Form Tambah Data");
                $(".btn_save").addClass("btn_save btn btn-primary");
                $(".btn_save").append('<i class="fa fa-save"></i> ');
                $(".btn_save").append('SIMPAN');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click','.btn_edit',function(){
            $('#tampil_form').load("<?= site_url('pengaturan/hari-libur/form/edit/') ?>"+$(this).attr('id'),function(){
                $('#modal_form').modal('show');
                $(".title").text("Form Edit Data");
                $(".btn_save").addClass("btn_save btn btn-warning");
                $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
                $(".btn_save").append('PERBARUI');
                $("#btn_new_input").hide();
            });
        });

        $(document).on('click','.btn_delete',function(){
            $('#tampil_form').load("<?php echo site_url('pengaturan/hari-libur/form/hapus/') ?>"+$(this).attr('id'),function(){
                $('#modal_form').modal('show');
                $(".title").text("Apakah Anda ingin menghapus data ini?");
                $('#form_input input[type=text]').prop("disabled",true);
                $('#form_input input[type=date]').prop("disabled",true);
                $(".btn_save").append('<i class="fa fa-trash"></i> ');
                $(".btn_save").append('HAPUS');
                $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            });
        });

        $(document).on('click','#btn_new_input', function(){
            $('#form_input input[type=text]').prop("disabled",false);
            $("#form_input input[type=text]").val('');
            $('#form_input input[type=date]').prop("disabled",false);
            $("#form_input input[type=date]").val('');

            $('.btn_save').show();
            $('#btn_new_input').hide();
            $('#message').hide();
        });

        $(document).on("click",".btn_save",function(e){
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);

            if($("#tanggal").val()==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal belum diisi</font>");
                $("#tanggal").focus();
                return false;
            }else if($("#keterangan").val() ==""){
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Keterangan belum diiisi</font>");
                $('#keterangan').focus();
                return false;
            }

            loading.start();

            var param = 'id='+$("#id").val()+
                        '&tanggal='+$("#tanggal").val()+
                        '&keterangan='+$("#keterangan").val();

            $.ajax({
                type: 'POST',
                url: "<?= site_url('pengaturan/hari-libur/save') ?>",
                data: param,
                dataType:'JSON',
                success: function(result) {
                    if(result.success == true){
                        if(result.type == 'save'){
                            $("#form_input :input").prop("disabled", true);
                            $('.btn_save').hide();
                            $('#btn_new_input').show();
                        }
                        thumbnail_calendar();
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error:function(){
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

        // PROSES DELETE
        $(document).on('click','.btn_hapus',function(){
            var loading = Ladda.create(this);
            loading.start();
            $.ajax({
                type: 'POST',
                url: "<?php echo site_url('pengaturan/hari-libur/delete') ?>",
                data: 'id='+$("#id").val(),
                dataType:'JSON',
                success: function(result){
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message);
                },
                error:function(){
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });

        $('#tahun').select2({
            placeholder: "Pilih tahun"
        });

        $("#btn_export").click(function(e){
            e.preventDefault();
            var tahun = $('#tahun').val();
            window.location.href = "<?= site_url('pengaturan/hari-libur/export/') ?>" + tahun;
        });
    });

    function datatables_calendar(){
        $('#view_list').load("<?= site_url('pengaturan/hari-libur/view/list') ?>");
    }

    function thumbnail_calendar(){
        $("#thumbnail_view").load('<?= route("pengaturan.harilibur.view.thumbnail") ?>');
    }


    function detail_holiday(event){
        $("#modal_update_kalender .card-body").show();
        $("#modal_update_kalender .card-footer").show();
        $("#modal_update_kalender .title").html("Form");
        $('#modal_update_kalender #message').hide();
        $('#modal_update_kalender #id_hari_libur').val(event.id_holiday);
        $('#modal_update_kalender .title').html(moment(event.start).format('DD MMMM YYYY'));
        $('#modal_update_kalender #tanggal').val(moment(event.start).format('YYYY-MM-DD'));
        $('#modal_update_kalender #tanggal').prop("disabled",true);
        $('#modal_update_kalender #keterangan').val(event.title);
        $('#modal_update_kalender').modal('show');
    }

    function editDataHoliday(event){
        $('#modal_update_kalender #btn_update').click(function (e){
            e.preventDefault();
            var loading = Ladda.create(this);
            loading.start();

            var param = 'id='+$("#modal_update_kalender #id_hari_libur").val()+
                        '&tanggal='+$("#modal_update_kalender #tanggal").val()+
                        '&keterangan='+$("#modal_update_kalender #keterangan").val();
            $.ajax({
                url: '<?php echo site_url('pengaturan/hari-libur/update') ?>',
                type: 'POST',
                data: param,
                dataType: 'JSON',
                success: function (result){
                    if(result.success == true){
                        thumbnail_calendar();
                    }
                    loading.stop();
                    $('#modal_update_kalender #message').html(result.message);
                    $('#modal_update_kalender #message').show();
                },
                error:function(){
                    loading.stop();
                    $('#modal_update_kalender #message').show();
                    $('#modal_update_kalender #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        })
    }

    function deleteDataHoliday(event){
        $('#modal_update_kalender .delete_holiday').click(function () {
            var loading = Ladda.create(this);
            loading.start();

            $.ajax({
                url: '<?php echo site_url('pengaturan/hari-libur/delete') ?> ',
                type: 'POST',
                data: 'id=' + event.id_holiday,
                dataType: 'JSON',
                success: function (result){
                    if(result.success == true){
                        thumbnail_calendar();
                        $("#modal_update_kalender .card-body").hide();
                        $("#modal_update_kalender .card-footer").hide();
                        $("#modal_update_kalender .title").html(result.message);
                    }else{
                        $('#modal_update_kalender #message').html(result.message);
                        $('#modal_update_kalender #message').show();
                    }
                    loading.stop();
                },
                error:function(){
                    loading.stop();
                    $('#modal_update_kalender #message').show();
                    $('#modal_update_kalender #message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        })
    };
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        </li>
                        <li class="breadcrumb-item"><a href="#">Pengaturan</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <?php
                if (in_array($this->session->userdata('level_user'), array("1"))) {
            ?>
            <div class="float-md-right">
                <!-- <a href='<?= base_url("kalender/template_kalender.xlsx") ?>' target = '_blank' class='btn btn-warning'><i class="fa fa-file"></i> Template</a>
                <button class=" btn btn-info" id="btn_export"><i class="fa fa-download"></i> Download</button>
                <button class=" btn btn-success" data-toggle="modal" data-target="#modal_import" id="btn_import"><i class="fa fa-upload"></i> Upload</button> -->
                <button type="button" class="btn_tambah btn btn-biru">
                    <i class="fa fa-plus"></i> Tambah Data
                </button>
            </div>
            <?php } ?>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <ul class="nav nav-tabs" role="tablist">
                <li class="nav-item">
                    <a id="btn_tab_list_view" class="nav-link active" href="#profile" role="tab" data-toggle="tab">Daftar Tabel</a>
                </li>
                <li class="nav-item">
                    <a id="btn_tab_kalender_view" class="nav-link" href="#thumbnail_view" role="tab" data-toggle="tab">Kalender</a>
                </li>
            </ul>

            <!-- Tab panes -->
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane active" id="profile">
                <br>
                <div id="view_list" class="col-md-12 bbna"></div>

                </div>
                <!-- <div id="buzz" role="tabpanel" class="tab-pane"></div> -->
                <div id="thumbnail_view" role="tabpanel" class="tab-pane"></div>
            </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div>
<!-- END TAMPIL MODAL -->

<!-- START TAMPIL MODAL EDIT KALENDER PADA TAMPILAN KALENDER-->
<div class="modal fade" id="modal_update_kalender" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-body">
                <input type="hidden" id="id_hari_libur" value="">
                <div class="form-group">
                    <div class="alert alert-danger" style="display: none;"></div>
                </div>
                <div class="form-group">
                    <label>Tanggal <i class="text-danger">*</i></label>
                    <input type="text" id="tanggal" name="tanggal" class="form-control datepicker" value="<?= $tanggal; ?>" readonly="true"><span id="user-availability-status"></span>
                </div>

                <div class="form-group">
                    <label>Keterangan <i class="text-danger">*</i></label>
                    <input type="text" id="keterangan" name="keterangan" class="form-control" value="<?= ((isset($data))?$data->keterangan:'') ?>">
                </div>

            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-5 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-7 text-right">
                        <button type="button" class="btn btn-danger delete_holiday ladda-button" data-style="expand-left"><i class="fa fa-trash"></i> HAPUS</button>
                        <button type="button" id="btn_update" class="btn btn-warning ladda-button" data-style="expand-left"><i class="fa fa-edit (alias)"></i> PERBARUI</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- START TAMPIL MODAL EDIT KALENDER PADA TAMPILAN KALENDER-->

<div id="modal_import" class="modal fade" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="modal-title">Import Data</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div id="box-body" class="modal-body">
                <?= form_open('', "id='form_data_import'") ?>
                <input type="file" name="file" id="file" class="form-control " />
                <?= form_close() ?>
            </div>
            <div class="modal-footer">
                <span id="alert-success-import" style="color:#009900;font-weight: bold"><i class="fa fa-check-square">&nbsp;</i><span id="message-success-import" > Data berhasil disimpan</span></span>
                <span id="alert-danger-import" style="color:#eb3a28;font-weight: bold"><i class="fa fa-window-close">&nbsp;</i><span id="message-danger-import" > Terjadi kesalahan, data belum berhasil disimpan </span></span>
                <button type="button" id="btn_save-import" class=" btn btn-success btn-save ladda-button" data-style="expand-left">
                    <span class="ladda-label">SIMPAN</span>
                </button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function () {

        $(document).on('click', '#btn_import', function () {
            $("#alert-success-import, #alert-danger-import").hide();
        });

        $(document).on('click', '#btn_save-import', function () {
            $('#btn_save-import').prop('disabled', true);
            var loading = Ladda.create(this);
            loading.start();

            var form = $('#form_data_import')[0];
            var data = new FormData(form);

            $.ajax({
                type: 'POST',
                url: "<?php echo site_url('pengaturan/hari-libur/import') ?>",
                data: data,
                async: false,
                cache: false,
                contentType: false,
                enctype: 'multipart/form-data',
                processData: false,
                dataType: "json",
                success: function (result) {
                    if(result.status === 'success') {
                        $("#message-success-import").text('Berhasil proses data');
                        $("#alert-success-import").show();
                    }else{
                        $("#message-danger-import").text('Gagal proses data');
                        $("#alert-danger-import").show();
                    }

                    $('#btn_save-import').prop('disabled', false);
                    loading.stop();
                },
                error: function () {
                    $("#message-danger-import").text('Gagal proses data');
                    $("#alert-danger-import").show();
                    $('#btn_save-import').prop('disabled', false);
                    loading.stop();
                }
            });

        });

    });
</script>

<script type="text/javascript">
        function checkAvailability() {
            $("#user-availability-status").hide();
            $("#loaderIcon").show();
            jQuery.ajax({
                url: "<?= site_url('pengaturan/hari-libur/cek-tanggal') ?>",
                data:'tanggal='+$("#tanggal").val(),
                type: "POST",
                success:function(data){
                    if (data == 'sudah') {
                        $("#user-availability-status").show();
                        $("#user-availability-status").html("<span class='status-not-available' style='color: red;'> Tanggal Libur sudah digunakan.</span>");
                        $("#loaderIcon").hide();
                        $(".btn_save").prop('disabled', true);
                    } else{
                        $("#user-availability-status").show();
                        $("#user-availability-status").html("<span class='status-not-available' style='color: green;'> Tanggal Libur belum digunakan.</span>");
                        $("#loaderIcon").hide();
                        $(".btn_save").prop('disabled', false);
                    }
                },
            })
        }
</script>


