<script type="text/javascript"> 
    $(document).ready(function () {
        $("#periode").datepicker( {
            format: "mm-yyyy",
            autoclose: true,
            viewMode: "months", 
            orientation: 'bottom',
            minViewMode: "months"
        });

        dropdown_karyawan();
        dropdown_cabang();
        dropdown_departemen();

        // BEGIN HAPUS
        $(document).on('click','.btn_delete',function(){
            var id = $(this).attr('id');
            $('#modal_hapus').modal('show');
            $("#modal_hapus .card-body").show();
            $("#modal_hapus .card-footer").show();

            $('.btn_hapus').on('click',function(){
                var loading = Ladda.create(this);
                loading.start();
                $.ajax({
                    type: 'POST',
                    url: "<?= route('informasi.gaji.delete') ?>",
                    data: 'id='+id,
                    dataType:'JSON',
                    success: function(result){
                        $("#modal_hapus .card-body").hide();
                        $("#modal_hapus .card-footer").hide();
                        $("#modal_hapus .title").html(result.message);
                        loading.stop();
                        
                    },
                    error:function(){
                        loading.stop();
                        $("#modal_hapus .card-body").hide();
                        $("#modal_hapus .card-footer").hide();
                        $("#modal_hapus .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                    }
                });
            });
        });
        //END HAPUS

        // BEGIN PUBLISH
        $(document).on('click','.btn_publish',function(){
            var loading = Ladda.create(this);
            loading.start();
            var params = "id="+$("#form_input #id").val()+
                        "&publish="+$("#form_input #publish").val();
            $.ajax({
                type: 'POST',
                url: "<?= route('informasi.gaji.publishunpublish') ?>",
                data: params,
                dataType:'JSON',
                success: function(result){
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message);
                },
                error:function(){
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
        //END BEGIN PUBLISH

        // BEGIN PUBLISH ALL
        $(document).on('click','.btn_publish_all',function(){
            var periode = $(".filter #periode").val();
            $('#modal_publish_all').modal('show');
            $("#modal_publish_all .card-body").show();
            $("#modal_publish_all .card-footer").show();
            $(".title").text("Apakah Anda ingin publish semua data periode "+periode+"?");             

            $('.btn_confrim_publish_all').on('click',function(){
                var loading = Ladda.create(this);
                loading.start();
                $.ajax({
                    type: 'POST',
                    url: "<?= route('informasi.gaji.publishall') ?>",
                    data: 'periode='+periode,
                    dataType:'JSON',
                    success: function(result){
                        $("#modal_publish_all .card-body").hide();
                        $("#modal_publish_all .card-footer").hide();
                        $("#modal_publish_all .title").html(result.message);
                        loading.stop();
                    },
                    error:function(){
                        loading.stop();
                        $("#modal_publish_all .card-body").hide();
                        $("#modal_publish_all .card-footer").hide();
                        $("#modal_publish_all .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                    }
                });
            });
        });
        // END BEGIN PUBLISH ALL

         // BEGIN UNPUBLISH ALL
        $(document).on('click','.btn_unpublish_all',function(){
            var periode = $(".filter #periode").val();
            $('#modal_unpublish_all').modal('show');
            $("#modal_unpublish_all .card-body").show();
            $("#modal_unpublish_all .card-footer").show();
            $(".title").text("Apakah Anda ingin publish semua data periode "+periode+"?"); 

            $('.btn_confrim_unpublish_all').on('click',function(){
                var loading = Ladda.create(this);
                loading.start();
                $.ajax({
                    type: 'POST',
                    url: "<?= route('informasi.gaji.unpublishall') ?>",
                    data: 'periode='+periode,
                    dataType:'JSON',
                    success: function(result){
                        $("#modal_unpublish_all .card-body").hide();
                        $("#modal_unpublish_all .card-footer").hide();
                        $("#modal_unpublish_all .title").html(result.message);
                        loading.stop();
                    },
                    error:function(){
                        loading.stop();
                        $("#modal_unpublish_all .card-body").hide();
                        $("#modal_unpublish_all .card-footer").hide();
                        $("#modal_unpublish_all .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                    }
                });
            });
        });
        // END BEGIN UNPUBLISH ALL
    });

    function dropdown_karyawan() {
        $('#karyawan').select2({
            placeholder: 'Semua Karyawan',
            allowClear: true,
            ajax: {
                url: '<?= route("informasi.gaji.dropdown.karyawan")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function dropdown_cabang(){
        $('#cabang').select2({
            placeholder: 'Semua Cabang',
            allowClear: true,
            ajax: {
                url: '<?= route("informasi.gaji.dropdown.cabang")  ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: false
            },
            minLength: 3
        });
    }

    function dropdown_departemen() {
        $("#departemen").val('').trigger('change');

        var kode_cabang = $("#cabang").val();
        $("#departemen").select2({
            placeholder: "Semua Departemen",
            allowClear: true,
            ajax: {
                url: '<?= route("informasi.gaji.dropdown.departemen") ?>/'+ kode_cabang,
                dataType: 'json',
                delay: 250,
                processResults:function(data) {
                    return {
                            results: data
                        };
                },
                cache: false
            }
        });
    }

    function publish_unpublish(id){
        var publish = $("#"+id).attr('publish');        
        
        if(publish == "0"){
            var title = "Apakah Anda ingin publish gaji ini?";
            var val_publish = "1";
        }else{
            var title = "Apakah Anda ingin unpublish gaji ini?";
            var val_publish = "0";
            var swicth = $("#1a2c812ca2629dc510138ce558b004c7").removeAttr("checked");
        }
        $('#modal_form #tampil_form').load("<?= route('informasi.gaji.form.publish') ?>"+"/"+id,function(){
            $('#modal_form').modal('show');
            $("#modal_form .title").text(title);

            $("#modal_form #id").val(id);
            $("#modal_form #publish").val(val_publish);

            if(publish == "0"){
                $("#modal_form .btn_publish").append('<i class="fa icon-check"></i> PUBLISH');
                $("#modal_form .btn_publish").removeClass("btn_publish").addClass("btn_publish btn btn-primary pull-right ladda-button");
            }else{
                $("#modal_form .btn_publish").append('<i class="fa fa-remove"></i> UNPUBLISH');
                $("#modal_form .btn_publish").removeClass("btn_publish").addClass("btn_publish btn btn-danger pull-right ladda-button");
            }

        });
    }

    function cancel_publish_unpublish(){
        list_data.ajax.reload(null,false);
        $('#modal_form').modal('hide');
    }    

</script>

<style>
    th, td { 
        white-space: nowrap; 
    }
    div.dataTables_wrapper {
        margin: 0 auto;
    }
</style>


<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Informasi</a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
            <div class="float-md-right">
                <?php
                    if(in_array($this->session->userdata("level_user"),['1','6'])){
                ?>
                        <a href="<?= route('informasi.gaji.import.home'); ?>">
                            <button type="button" class="btn_tambah btn btn-biru">
                                <i class="fa fa-upload"></i> Import Data
                            </button>
                        </a>
                <?php
                    }
                ?>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body filter">    
            <div class="row">
                <div class="col-md-1">
                    <label>PERIODE</label>
                </div>
                <div class="col-md-2">
                    <?php
                        if ($tanggal != "") {
                            $tgl = $tanggal;
                        }else{
                            $tgl = date("m-Y");
                        }
                    ?>
                    <input type="text" id="periode" class="form-control" value="<?= $tgl; ?>" autocomplete="off" required>
                </div>
            </div>

            <div class="row mt-1">
                <div class="col-md-1">
                    <label>KARYAWAN</label>
                </div>
                <div class="col-md-5">
                    <select class="form-control" id="karyawan"></select>
                </div>       
                <div class="col-md-2">
                    <button type="button" id="btn_cari" class="btn btn-primary ml-1 ladda-button" data-style="expand-left">CARI</button>
                </div>
            </div>

            <div class="row mt-1">
                <?php
                    if(in_array($this->session->userdata('level_user'), array("1","4","6"))){
                ?>
                        <div class="col-md-1">
                            <label>CABANG</label>
                        </div>
                        <div class="col-md-2">
                            <select class="form-control" id="cabang" onchange="dropdown_departemen()"></select>
                        </div>
                <?php 
                    }
                ?>
                <div class="col-md-1 text-right">
                    <label>DEPARTEMEN</label>
                </div>
                <div class="col-md-2">
                    <select class="form-control" id="departemen"></select>
                </div>       
                <div class="col-md-1">
                    <button type="button" id="btn_filter" class="btn btn-primary ml-1 ladda-button" data-style="expand-left">Filter</button>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="content" class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12 text-right">
                    <?php
                        if(in_array($this->session->userdata("level_user"),['1','6'])){
                    ?>
                            <button class="btn_publish_all btn btn-primary ladda-button"><i class="fa icon-check"></i> PUBLISH SEMUA</button>
                            <button class="btn_unpublish_all btn btn-danger ladda-button"><i class="fa fa-remove"></i> UNPUBLISH SEMUA</button>
                    <?php
                        }
                    ?>
                </div>
            </div>
            <div class="row mt-1">
                <div class="col-md-12">
                    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
                        <thead>
                            <tr class="bg-tr">
                                <th class="text-center">NO</th>
                                <th class="text-left">NAMA KARYAWAN</th>
                                <th class="text-center">PERIODE</th>
                                <th class="text-left">CABANG</th>
                                <th class="text-left">DEPARTEMEN</th>
                                <th class="text-left">JABATAN</th>
                                <th class="text-center">GAJI POKOK</th>
                                <th class="text-center">TOTAL TUNJANGAN</th>
                                <th class="text-center">TOTAL TUNJANGAN <br> YANG<br> DIBIAYAI PERUSAHAAN</th>
                                <th class="text-center">TOTAL PENERIMAAN</th>
                                <th class="text-center">TOTAL POTONGAN</th>
                                <th class="text-center">GAJI DITERIMA</th>
                                <?php
                                    if(in_array($this->session->userdata("level_user"),['1'])){
                                ?>
                                        <th class="text-center">PUBLISH</th>
                                <?php
                                    }
                                ?>
                                <th class="text-center">AKSI</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- START TAMPIL MODAL HAPUS-->
<div id="modal_hapus" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title">Apakah Anda ingin menghapus data ini?</h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_hapus btn btn-danger ladda-button" data-style="expand-left"><i class="fa fa-trash"></i> HAPUS</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL HAPUS-->

<!-- START TAMPIL MODAL PUBLISH ALL-->
<div id="modal_publish_all" class="modal fade in">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_confrim_publish_all btn btn-primary ladda-button" data-style="expand-left"><i class="fa icon-check"></i> PUBLISH SEMUA</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL PUBLISH ALL-->

<!-- START TAMPIL MODAL UNPUBLISH ALL-->
<div id="modal_unpublish_all" class="modal fade in">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="card-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <h3 class="title modal-title"></h3>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col-md-7 text-left">
                        <div id="message"></div>
                    </div>
                    <div class="col-md-5 text-right">
                        <button class="btn_confrim_unpublish_all btn btn-danger ladda-button" data-style="expand-left"><i class="fa icon-remove"></i> UNPUBLISH SEMUA</button>
                    </div>
                </div><!-- ./row -->
            </div>
        </div>
    </div>
</div>
<!-- END TAMPIL MODAL UNPUBLISH ALL-->


<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({
                'searching'     : false,
                'paging'        : true,
                'lengthChange'  : true,
                'ordering'      : true,
                'info'          : true,
                'scrollX'       :true,
                'scrollCollapse': true,
                'fixedColumns'  :{
                    'leftColumns': 3,
                    <?php
                        if(in_array($this->session->userdata("level_user"),['1'])){
                            echo "'rightColumns': 3";
                        }else{
                            echo "'rightColumns': 2";
                        }
                    ?>
                },
                'language'    :{
                                'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                'sEmptyTable' : 'Tidak ada data untuk ditampilkan'
                                },
                "processing"  : true, 
                "serverSide"  : true, 
                "order"       : [], 
                
                "ajax"        : {
                                    "url": "<?= route('informasi.gaji.listdata') ?>"+"/"+$(".filter #periode").val()+"/0/0/0",
                                    "type": "POST",
                                    "complete" : function(data){
                                            reconfigure(data);
                                        }
                                },
        
                "aoColumnDefs": [
                                    { "aTargets": [0], "bSortable": false},
                                    { "aTargets": [-1], "bSortable": false },
                                    <?php
                                        if(in_array($this->session->userdata("level_user"),['1'])){
                                    ?>
                                            { "aTargets": [-2], "bSortable": false }
                                    <?php
                                        }
                                    ?>
                                ],
                "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                    $('td:eq(0)', nRow).css({'text-align':'center'});
                    $('td:eq(2)', nRow).css({'text-align':'center'});
                    $('td:eq(6)', nRow).css({'text-align':'right'});
                    $('td:eq(7)', nRow).css({'text-align':'right'});
                    $('td:eq(8)', nRow).css({'text-align':'right'});
                    $('td:eq(9)', nRow).css({'text-align':'right'});
                    $('td:eq(10)', nRow).css({'text-align':'center'});
                    $('td:eq(11)', nRow).css({'text-align':'center'});
                }
        
        });

        $('#btn_cari').click(function(){
            var loading = Ladda.create(this);
            loading.start();

            var periode         = ($("#periode").val() == null)?"0":$("#periode").val();
            var id_karyawan     = ($("#karyawan").val() == null)?"0":$("#karyawan").val();
            var kode_cabang     = 0;
            var kode_departemen = 0;

            list_data.ajax.url("<?= route('informasi.gaji.listdata') ?>"+"/"+periode+"/"+id_karyawan+"/"+kode_cabang+"/"+kode_departemen)
            list_data.ajax.reload(function(){
                loading.stop();
            });
        });

        $('#btn_filter').click(function(){
            var loading = Ladda.create(this);
            loading.start();

            var periode         = ($("#periode").val() == null)?"0":$("#periode").val();
            var id_karyawan     = 0
            var kode_cabang     = ($("#cabang").val() == null)?"0":$("#cabang").val();
            var kode_departemen = ($("#departemen").val() == null)?"0":$("#departemen").val();

            list_data.ajax.url("<?= route('informasi.gaji.listdata') ?>"+"/"+periode+"/"+id_karyawan+"/"+kode_cabang+"/"+kode_departemen)
            list_data.ajax.reload(function(){
                loading.stop();
            });
        });
        
    });
    
</script>



