<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Atasan_khusus_m extends CI_Model {
    var $table = 'p_atasan';

    function get_datatables(){
        $this->_get_datatables_query();
        if($_POST['length'] != -1){
            $this->db->limit($_POST['length'], $_POST['start']);
        }
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
    
    public function count_all(){
        $this->db->select("p_atasan.id")->from($this->table);
        if ($this->session->userdata('level_user') == "5") {
            $this->db->where("p_atasan.id_cabang",$this->session->userdata("id_cabang"));
        }
         $this->db->where("p_atasan.id_company",$this->session->userdata("id_company"));
        return $this->db->count_all_results();
    }
    private function _get_datatables_query(){
        $this->db->select("p_atasan.id, p_atasan.id_cabang, p_atasan.id_departemen, p_atasan.id_jabatan, p_atasan.atasan, p_atasan.id_company, master_cabang.kode as kode_cabang, master_departemen.kode as kode_departemen, a.kode_jabatan as kode_jabatan_a, b.kode_jabatan as kode_jabatan_b")->from($this->table);
        $this->db->join('master_cabang', 'master_cabang.id_cabang = p_atasan.id_cabang');
        $this->db->join('master_departemen', 'master_departemen.id_departemen = p_atasan.id_departemen');
        $this->db->join('master_jabatan a', 'a.id_jabatan = p_atasan.id_jabatan');
        $this->db->join('master_jabatan b', 'b.id_jabatan = p_atasan.atasan');
        $this->db->where("p_atasan.id_company",$this->session->userdata("id_company"));

        if ($this->session->userdata('level_user') == "5") {
            $this->db->where("p_atasan.id_cabang",$this->session->userdata("id_cabang"));
        }

        $column_search = array('master_cabang.nama','master_departemen.nama','a.nama','b.nama');
        $i = 0;
    
        foreach ($column_search as $item){  // looping awal
            if($_POST['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST
    
                if($i===0){ // looping awal
                    $this->db->group_start();
                    $this->db->like($item, $_POST['search']['value']);
                }else{
                    $this->db->or_like($item, $_POST['search']['value']);
                }
    
                if(count($column_search) - 1 == $i){
                    $this->db->group_end();
                }
            }
            $i++;
        }
    
        $column_order = array('','p_atasan.id_cabang','p_atasan.id_departemen','p_atasan.id_jabatan','p_atasan.atasan');
    
        if(isset($_POST['order'])){
            $this->db->order_by($column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } 
        else{
            $order_by = array("p_atasan.id"=>"DESC");
            $this->db->order_by(key($order_by), $order_by[key($order_by)]);
        }
    }

    public function getDataById($id=null){
        $select = $this->db->query("SELECT id_cabang,
                                            id_departemen,
                                            id_jabatan,
                                            atasan,
                                            id
                                    FROM $this->table
                                    WHERE MD5(id) = '$id'
                                    AND id_company = '".$_SESSION["id_company"]."'")->row();
        return $select;
    }

    public function save($data,$id = null){
        if($id != null){
            $this->db->where(array('md5(id)'=>$id, 'id_company'=>$_SESSION['id_company']));
            $update = $this->db->update($this->table,$data);
            return  __response_update($update);
        }else{
            $nextId = $this->fungsi->getNextId($this->table,'id',$_SESSION['id_company'],3);
            $id_atasan_khusus = array('id' => $nextId);
            $save = $this->db->insert($this->table, array_merge($data,$id_atasan_khusus));
            return __response_save($save);
    
        }
        
    }

    public function delete($id=null){

        $this->db->where(array('md5(id)'=>$id));
        $delete =$this->db->delete($this->table);

        return  __response_delete($delete);
    
        
    }

     public function get_atasan($id = null, $search = null){
        $level = $this->db->select("level_user")->from("master_jabatan")->where("id_jabatan", $id)->get()->row()->level_user;
        // $this->db->query("SELECT level_user FROM master_jabatan WHERE id_jabatan = '$id'")->row()->level_user;
        $this->db->select('nama, id_jabatan');
        $this->db->like('nama', $search);
        $this->db->order_by('id_jabatan', 'ASC');
        $this->db->where('level_user', $level);
        $this->db->where('id_jabatan !=', $id);

        $result = $this->db->get('master_jabatan')->result();
        $json = [];
        //$json[] = ['id'=> 0, 'text'=>'Semua Cabang'];
        foreach ($result as $rows) {
          $json[] = ['id'=>$rows->id_jabatan, 'text'=>$rows->nama];
        }
        echo json_encode($json);
    }
}