<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Quick_setup_staff extends MY_Controller{

  public function __construct()
  {
    parent::__construct();
    $this->load->model('quick_setup_staff_m', 'q_setup_staff_m');
    $this->load->model('wizard_m');
  }

  function index()
  {
    $data['aktif'] = 'kelola_mudah';
    $data['judul'] = 'Quick Setup Staff';
    $data['jenis'] = 'staff';
    $data['menu'] = $this->load->view('main_menu', $data, true);
    $data['menu_quick_setup'] = $this->load->view('quick_setup/menu', $data, true);
    $data['main'] = $this->load->view('quick_setup/staff/main', $data, true);
    $data['table'] = $this->load->view('quick_setup/staff/table', $data, true);
    $data['content'] = $this->load->view('quick_setup/main', $data, true);
    $this->load->view('main_template', $data, false);
  }

  public function list_data(){
		$list = $this->q_setup_staff_m->get_datatables();
		$data = array();
    $no = $_POST['start'];
		foreach ($list as $field) {
      $no++;
			$row = array();
      $row[] = $no;
			$row[] = $field->nik;
			$row[] = $field->nama_lengkap;
			$row[] = $field->kode_cabang.' - '.$field->cabang;
			$row[] = $field->kode_departemen.' - '.$field->departemen;
      $row[] = '<a href="#" data-target="tooltip" title="Edit" style="color:#434343;" class="text-warning"
                  onclick="edit(\''.$field->id_karyawan.'\')">
                  <i id="" class="btn_edit fa fa-edit"></i>
                </a>&nbsp;
                <a href="#" data-target="tooltip" title="Delete" style="color:#434343;" class="text-danger"
                  onclick="hapus(\''.$field->id_karyawan.'\')">
                    <i id="" class="btn_delete fa fa-trash"></i>
                </a>';

			$data[] = $row;
		}

		$output = array("draw"            => $_POST['draw'],
						"recordsTotal"    => $this->q_setup_staff_m->count_all(),
						"recordsFiltered" => $this->q_setup_staff_m->count_filtered(),
						"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

  function cek_jabatan_staff() {
    $cek = $this->q_setup_staff_m->cek_jabatan_staff();
    if($cek->num_rows() == 0) {
      //create jabatan kepala cabang
      return $this->q_setup_staff_m->create_jabatan_staff();
    } else {
      return $cek->row()->id_jabatan;
    }
  }

  function save() {
    $cek_jabatan_staff = $this->cek_jabatan_staff();

    $nik          = trim($this->input->post('nik'));
    $nama         = $this->input->post('nama');
    $cabang       = $this->input->post('cabang');
    $departemen   = $this->input->post('departemen');
    $username     = trim($this->input->post('username'));
    $id_company   = $this->session->userdata('id_company');
    $id_karyawan  = $this->wizard_m->generate_id('data_karyawan','id_karyawan', 4, $id_company);
    $id_user	    = $this->wizard_m->generate_id('users','id_user', 4, $id_company, 3);

    $data = array(
      'id_cabang'     => $cabang,
      'id_jabatan'    => $cek_jabatan_staff,
      'id_departemen' => $departemen,
      'nik'           => $nik,
      'nama'          => $nama,
      'username'      => $username,
      'password'      => $username,
      'id_company'    => $id_company,
      'id_karyawan'   => $id_karyawan,
      'id_user'       => $id_user
    );

    $buat_karyawan	= $this->wizard_m->buat_karyawan($data);
    $data_karyawan	= $buat_karyawan['data_karyawan'];
    $data_users		  = $buat_karyawan['data_users'];

    $this->db->trans_start();
    $this->db->insert('data_karyawan', $data_karyawan);
    $this->db->insert('users', $data_users);
    $this->db->trans_complete();

    if ($this->db->trans_status() === FALSE)
    {
      return __response_save(false);
    } else {
      return __response_save(true);
    }
  }
}
