<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Pengajuan_lembur extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Pengajuan_lembur_m');
        $this->load->model('Db_model', 'db_model');
        $this->load->model('Master_plan_m');

        $this->level_user           = $this->session->userdata('level_user');
        $this->id_company           = $this->session->userdata('id_company');
        $this->multi_cabang         = $this->session->userdata('multi_cabang');
        $this->id_cabang            = $this->session->userdata('id_cabang');
        $this->id_cabang_arr        = $this->session->userdata('id_cabang_arr');
        $this->multi_departemen     = $this->session->userdata('multi_departemen');
        $this->id_departemen        = $this->session->userdata('id_departemen');
        $this->id_departemen_arr    = $this->session->userdata('id_departemen_arr');
        $this->id_karyawan          = $this->session->userdata('id_karyawan');
    }

    //CRUD
    public function index()
    {
        $data['judul'] = 'Pengajuan Lembur';
        $data['aktif'] = 'lembur';
        $data['level_user'] = $this->level_user;
		$data['multi_cabang'] = $this->multi_cabang;
		$data['multi_departemen'] = $this->multi_departemen;
        $data['periode_awal'] = date('d-m-Y',  strtotime(date('Y-m-').'01'));
		$data['periode_akhir'] = date('d-m-Y',  strtotime(date('Y-m-d')));
        $data['button_sso'] = $this->Master_plan_m->button_sso();
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('pengajuan_lembur/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function data_lembur($id_lembur)
    {
        $data['judul'] = 'Pengajuan Lembur';
        $data['aktif'] = 'lembur';

        $slq = 'id_lemmulai, id_karyawan, tgl_absen, jam_absen, lokasi_absen, timezone, gmt, latitude, longitude,
                keterangan, foto, id_company, approve, status, approval_spv, approval_kedep, approval_kacab, approval_hrd,
                approval_direksi, user_spv, user_kedep, user_kacab, user_hrd, user_direksi, tgl_apv_spv, tgl_apv_kedep, tgl_apv_kacab,
                tgl_apv_hrd, tgl_apv_direksi, tgl_input';

        $query = $this->db->select($slq)->from("lembur_mulai")->where("md5(id_lemmulai)", $id_lembur)->get()->row();

        $cabang = $this->db->select("id_cabang")->from("data_karyawan")->where("id_karyawan", $query->id_karyawan)->get()->row()->id_cabang;

        $departemen = $this->db->select("id_departemen")->from("data_karyawan")->where("id_karyawan", $query->id_karyawan)->get()->row()->id_departemen;

        $data['tgl_mulai'] = $this->fungsi->format_date_strip($query->tgl_absen);
        $data['tgl_selesai'] = $this->fungsi->format_date_strip($query->tgl_absen);
        $data['id_cabang'] = $cabang;
        $data['id_departemen'] = $departemen;
        $data['id_karyawan'] = $query->id_karyawan;

        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('pengajuan_lembur/home_data', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function view_data($tgl_mulai=0, $tgl_selesai=0, $status=0, $id_karyawan=0, $id_cabang=0, $id_departemen=0)
    {
        $data['judul']          = 'Pengajuan Lembur';
        $data['aktif']          = 'lembur';
        $data['status']         = $status;
        $data['id_karyawan']    = $id_karyawan;
        $data['id_cabang']      = $id_cabang;
        $data['id_departemen']  = $id_departemen;
        $data['tgl_mulai']      = date('Y-m-d', strtotime($tgl_mulai));
        $data['tgl_selesai']    = date('Y-m-d', strtotime($tgl_selesai));
        $this->load->view('pengajuan_lembur/list_data', $data, false);
    }

    public function list_data($tgl_mulai=0, $tgl_selesai=0, $status=0, $id_karyawan=0, $id_cabang=0, $id_departemen=0)
    {

        switch ($this->level_user) {
            case '1':
                $str = 'hrd';
                break;
            case '2':
                $str = 'kedep';
                break;
            case '4':
                $str = 'direksi';
                break;
            case '5':
                $str = 'kacab';
                break;
            case '7':
                $str = 'spv';
                break;

            default:
                $str = 'hrd';
                break;
        }

        $appv_sts = [];
        if ($status == '1') {
            $appv_sts = ['1'];
        } elseif ($status == '2') {
            $appv_sts = ['3'];
        } elseif ($status == '3') {
            $appv_sts = ['4'];
        } elseif ($status == '0') {
            $appv_sts = ['1', '2', '3', '4'];
        }
        $appv_lvl = 'lembur_mulai.approval_' . $str;
        $stts['appv_lvl'] = $appv_lvl;
        $stts['appv_sts'] = $appv_sts;
        $stts['appv_flt'] = $status;

        $recordsTotal       = $this->Pengajuan_lembur_m->count_all($tgl_mulai, $tgl_selesai, $stts, $id_karyawan, $id_cabang, $id_departemen);
        $recordsFiltered    = $this->Pengajuan_lembur_m->count_filtered($tgl_mulai, $tgl_selesai, $stts, $id_karyawan, $id_cabang, $id_departemen);
        $list = $this->Pengajuan_lembur_m->get_datatables($tgl_mulai, $tgl_selesai, $stts, $id_karyawan, $id_cabang, $id_departemen);
        $data = array();
        $no = $_POST['start'];

        foreach ($list as $field) {
            $no++;

            $lembur_mulai   = strtotime($field->jam_absen);
            $lembur_selesai = strtotime($field->jam_lembur_selesai);
            $selisih_detik  = $lembur_selesai - $lembur_mulai;
            $lama_lembur    = floor($selisih_detik/60);

            $row = array();

            $row[] = $no;
            $row[] = $field->nama_lengkap . '<br>' . $field->nik;
            $row[] = date('d-m-Y', strtotime($field->tgl_absen));
            $row[] = date_format(date_create($field->jam_absen),"d-m-Y H:i:s").
                '<br /><a data-toggle="modal" data-target="#modalViewDetail" href="javascript:;" data-uri="' . site_url("pengajuan/lembur/detail-lembur-mulai") . '/' . md5($field->id_lemmulai) . '"
				style="border-radius: 5px" class="btn btn-success btn-sm">Detail</a>';
            $row[] = date_format(date_create($field->jam_lembur_selesai),"d-m-Y H:i:s").
            '<br /><a data-toggle="modal" data-target="#modalViewDetail" href="javascript:;" data-uri="'.site_url("pengajuan/lembur/detail-lembur-selesai").'/'.md5($field->id_lemselesai).'"
            style="border-radius: 5px" class="btn btn-danger btn-sm">Detail</a>';
            $row[] = $lama_lembur;

            $row[] = $field->keterangan;
            $row[] = $field->ls_keterangan;
            $level_approval = $field->level_approval;

            $get_lev = explode(',', $level_approval);

            if (in_array($this->level_user,['1','7'])) {
                if ($field->approval_spv == 1) {
                    $spv = '<a href="#" id="' . md5($field->id_lemmulai) . '" class="btn_verif_spv btn-sm btn btn-primary" title="VERIFIKASI">
                            <i class="fa fa-check"> </i> VERIFIKASI</a>&nbsp;';
                } else {
                    $spv = $this->fungsi->get_approval($field->approval_spv);
                }
            } else {
                $spv = $this->fungsi->get_approval($field->approval_spv);
            }

            $row[] = $spv;

            if (in_array($this->level_user,['1','2'])) {
                if ($field->approval_kedep == 1) {
					$kedep = '<a href="#" id="' . md5($field->id_lemmulai) . '" class="btn_verif_kedep btn-sm btn btn-primary" title="VERIFIKASI">
                            <i class="fa fa-check"> </i> VERIFIKASI</a>&nbsp;';
				} else {
					$kedep = $this->fungsi->get_approval($field->approval_kedep);
				}
                // if ($field->approval_kedep == 1) {
                //     $key = array_search(2, $get_lev);
                //     $approv = $get_lev[$key - 1];

                //     if ($approv == '7') {
                //         $approv_col = $field->approval_spv;
                //     }

                //     if ($key != 0) {
                //         if ($approv_col == "4") {
                //             $kedep = '<a href="#" id="' . md5($field->id_lemmulai) . '" class="btn_verif_kedep btn-sm btn btn-primary" title="VERIFIKASI">
                //             <i class="fa fa-check"> </i> VERIFIKASI</a>&nbsp;';
                //         } else {
                //             $kedep = $this->fungsi->get_approval($field->approval_kedep);
                //         }
                //     } else {
                //         $kedep = '<a href="#" id="' . md5($field->id_lemmulai) . '" class="btn_verif_kedep btn-sm btn btn-primary" title="VERIFIKASI">
                //             <i class="fa fa-check"> </i> VERIFIKASI</a>&nbsp;';
                //     }
                // }else {
                //     $kedep = $this->fungsi->get_approval($field->approval_kedep);
                // }
            } else {
                $kedep = $this->fungsi->get_approval($field->approval_kedep);
            }

            $row[] = $kedep;

            if (in_array($this->level_user,['1','5'])) {
                if($field->approval_kacab == 1) {
                    $key = array_search(5, $get_lev);
                    $approv = $get_lev[$key - 1];

                    if ($approv == '7') {
                        $approv_col = $field->approval_spv;
                    } elseif ($approv == '2') {
                        $approv_col = $field->approval_kedep;
                    }

                    if ($key != 0) {
                        if ($approv_col == "4") {
                            $kacab = '<a href="javascript:;" id="' . md5($field->id_lemmulai) . '" class="btn_verif_kacab btn-sm btn btn-primary" title="VERIFIKASI">
                            <i class="fa fa-check"> </i> VERIFIKASI</a>&nbsp;';
                        } else {
                            $kacab = $this->fungsi->get_approval($field->approval_kacab);
                        }
                    } else {
                        $kacab = '<a href="javascript:;" id="' . md5($field->id_lemmulai) . '" class="btn_verif_kacab btn-sm btn btn-primary" title="VERIFIKASI">
                            <i class="fa fa-check"> </i> VERIFIKASI</a>&nbsp;';
                    }
                } else {
                    $kacab = $this->fungsi->get_approval($field->approval_kacab);
                }
            } else {
                $kacab = $this->fungsi->get_approval($field->approval_kacab);
            }

            $row[] = $kacab;

            if (in_array($this->level_user,['1','4'])) {
                if ($field->approval_direksi == 1) {
                    $key = array_search(4, $get_lev);
                    $approv = $get_lev[$key - 1];

                    if ($approv == '7') {
                        $approv_col = $field->approval_spv;
                    } elseif ($approv == '2') {
                        $approv_col = $field->approval_kedep;
                    } elseif ($approv == '5') {
                        $approv_col = $field->approval_kacab;
                    }

                    if ($key != 0) {
                        if ($approv_col == "4") {
                            $direksi = '<a href="javascript:;" id="' . md5($field->id_lemmulai) . '" class="btn_verif_direksi btn-sm btn btn-primary" title="VERIFIKASI">
                            <i class="fa fa-check"> </i> VERIFIKASI</a>&nbsp;';
                        } else {
                            $direksi = $this->fungsi->get_approval($field->approval_direksi);
                        }
                    } else {
                        $direksi = '<a href="javascript:;" id="' . md5($field->id_lemmulai) . '" class="btn_verif_direksi btn-sm btn btn-primary" title="VERIFIKASI">
                            <i class="fa fa-check"> </i> VERIFIKASI</a>&nbsp;';
                    }
                } else {
                    $direksi = $this->fungsi->get_approval($field->approval_direksi);
                }
            } else {
                $direksi = $this->fungsi->get_approval($field->approval_direksi);
            }

            $row[] = $direksi;

            if ($this->level_user == 1) {
                if ($field->approval_hrd == 1) {
                    $key = array_search(1, $get_lev);
                    $approv = $get_lev[$key - 1];

                    if ($approv == '7') {
                        $approv_col = $field->approval_spv;
                    } elseif ($approv == '2') {
                        $approv_col = $field->approval_kedep;
                    } elseif ($approv == '5') {
                        $approv_col = $field->approval_kacab;
                    }

                    if ($key != 0) {
                        if ($approv_col == "4") {
                            $hrd = '<a href="javascript:;" id="' . md5($field->id_lemmulai) . '" class="btn_verif_hrd btn-sm btn btn-primary" title="VERIFIKASI">
                            <i class="fa fa-check"> </i> VERIFIKASI</a>&nbsp;';
                        } else {
                            $hrd = $this->fungsi->get_approval($field->approval_hrd);
                        }
                    } else {
                        $hrd = '<a href="javascript:;" id="' . md5($field->id_lemmulai) . '" class="btn_verif_hrd btn-sm btn btn-primary" title="VERIFIKASI">
                            <i class="fa fa-check"> </i> VERIFIKASI</a>&nbsp;';
                    }
                } else {
                    $hrd = $this->fungsi->get_approval($field->approval_hrd);
                }
            } else {
                $hrd = $this->fungsi->get_approval($field->approval_hrd);
            }

            $row[] = $hrd;

            if (in_array($this->session->userdata('level_user'), array("1"))) {

                $row[] = '<a href="javascript:;" class="text-danger" title="HAPUS">
                                <i id="' . md5($field->id_lemmulai) . '" class="btn_delete fa fa-trash"></i>
                            </a>';
            }

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_POST['draw'],
            "recordsTotal"    => $recordsTotal,
            "recordsFiltered" => $recordsFiltered,
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }


    public function detail_lembur($id)
    {
        $data['judul'] = 'Pengajuan Lembur';
        $data['sub_judul'] = 'Detail Lembur';
        $data['aktif'] = 'lembur';

        $where = array('id_company' => $this->session->userdata('id_company'));
        $query = $this->db->select('id_company, nama')->get_where('master_company', $where)->row();
        $data['company'] = $query->nama;
        $data['id_company'] = $query->id_company;

        $coords = $this->db->select("
                                    k.nama_lengkap,
                                    k.nik,
                                    m.id_lemmulai,
                                    m.tgl_absen as tgl_mulai,
                                    m.jam_absen as jam_mulai,
                                    m.latitude as latitude_mulai,
                                    m.longitude as longitude_mulai,
                                    m.approve as approve_mulai,
                                    m.lokasi_absen as lokasi_mulai,
                                    m.keterangan as keterangan_mulai,
                                    m.foto as foto_mulai,
                                    s.tgl_absen as tgl_selesai,
                                    s.jam_absen as jam_selesai,
                                    s.latitude as latitude_selesai,
                                    s.longitude as longitude_selesai,
                                    s.lokasi_absen as lokasi_selesai,
                                    s.keterangan as keterangan_selesai,
                                    s.foto as foto_selesai,
                                    j.nama as nama_jabatan,
                                    d.nama as nama_departemen,
                                    c.nama as nama_cabang,
                                    cp.nama as nama_company,
                                    m.approval_spv,
                                    m.approval_kedep,
                                    m.approval_kacab,
                                    m.approval_hrd,
                                    m.approval_direksi
                                    ")
                        ->join("lembur_selesai s", 's.id_lemmulai=m.id_lemmulai')
                        ->join("data_karyawan k", "k.id_karyawan = m.id_karyawan")
                        ->join('master_jabatan j', 'j.id_jabatan=k.id_jabatan')
                        ->join('master_departemen d', 'd.id_departemen=k.id_departemen')
                        ->join('master_cabang c', 'c.id_cabang=k.id_cabang')
                        ->join('master_company cp', 'cp.id_company=k.id_company')
                        ->from("lembur_mulai m")
                        ->where("md5(m.id_lemmulai)", $id)
                        ->get()
                        ->row();

        $map_mulai['nama_lengkap'] = $coords->nama_lengkap;
        $map_mulai['latitude'] = $coords->latitude_mulai;
        $map_mulai['longitude'] = $coords->longitude_mulai;
        $data['map_mulai'] = $this->draw_map('map_mulai', $map_mulai);

        $map_selesai['nama_lengkap'] = $coords->nama_lengkap;
        $map_selesai['latitude'] = $coords->latitude_selesai;
        $map_selesai['longitude'] = $coords->longitude_selesai;
        $data['map_selesai'] = $this->draw_map('map_selesai', $map_selesai);

        $data['data'] = $coords;

        switch ($this->level_user) {
            case '1':
                $str = 'hrd';
                break;
            case '2':
                $str = 'kedep';
                break;
            case '4':
                $str = 'direksi';
                break;
            case '5':
                $str = 'kacab';
                break;
            case '7':
                $str = 'spv';
                break;

            default:
                $str = 'hdr';
                break;
        }

        $data['lv_appv'] = $str;

        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('pengajuan_lembur/detail_lembur', $data, true);
        $this->load->view('main_template', $data, false);
    }

    private function draw_map($map_id = 'map', $data)
    {
        $this->load->library('Leaflet');
        $lat  = $data['latitude'];
        $long = $data['longitude'];

        $config = array(
            'center'         =>  $lat . ',' . $long, // Center of the map
            'zoom'           =>  15, // Map zoom
        );
        $this->leaflet->initialize($config);

        $marker = array(
            'latlng'        => $lat . ',' . $long, // Marker Location
            'popupContent'  => $data['nama_lengkap'], // Popup Content
            'single_marker' => true,
        );
        $this->leaflet->add_marker($marker);
        return $this->leaflet->create_map($map_id);
    }

    public function detail_lembur_mulai($id)
    {
        $data['judul'] = 'Detail Lembur Mulai';
        $data['aktif'] = 'lembur';

        $where = array('id_company' => $this->session->userdata('id_company'));
        $query = $this->db->select('id_company, nama')->get_where('master_company', $where)->row();
        $data['company'] = $query->nama;
        $data['id_company'] = $query->id_company;

        $this->load->library('Leaflet');

        $get_one  = $this->db->select("latitude, longitude")->from("lembur_mulai")->where("md5(id_lemmulai)", $id)->get();
        //$this->db->query("SELECT latitude, longitude FROM lembur_mulai WHERE md5(id_lemmulai) = '$id'");

        if ($get_one->num_rows() > 0) {
            $lat  = $get_one->row()->latitude;
            $long = $get_one->row()->longitude;
        } else {
            $lat  = "-6.990581698473311";
            $long = "110.42295643957527";
        }

        $config = array(
            'center'         =>  $lat . ',' . $long, // Center of the map
            'zoom'           =>  15, // Map zoom
        );
        $this->leaflet->initialize($config);

        $coords = $this->db->select("lembur_mulai.tgl_absen, lembur_mulai.jam_absen, lembur_mulai.latitude, lembur_mulai.longitude, lembur_mulai.approve, lembur_mulai.lokasi_absen, lembur_mulai.keterangan, lembur_mulai.foto, data_karyawan.nama_lengkap")->from("lembur_mulai")->join("data_karyawan", "data_karyawan.id_karyawan = lembur_mulai.id_karyawan", "left")->where("md5(id_lemmulai)", $id)->get()->row();
        //$this->db->query("SELECT lembur_mulai.tgl_absen, lembur_mulai.jam_absen, lembur_mulai.latitude, lembur_mulai.longitude, lembur_mulai.approve, lembur_mulai.lokasi_absen, lembur_mulai.keterangan, lembur_mulai.foto, data_karyawan.nama_lengkap FROM lembur_mulai JOIN data_karyawan ON data_karyawan.id_karyawan = lembur_mulai.id_karyawan WHERE md5(id_lemmulai) = '$id'")->row();
        $data['nama'] = $coords->nama_lengkap;
        $data['lokasi'] = $coords->lokasi_absen;
        $data['jam_absen'] = $coords->jam_absen;
        $data['tanggal'] = date('d-m-Y', strtotime($coords->tgl_absen));
        $data['keterangan'] = $coords->keterangan;
        $data['foto'] = $coords->foto;

        $marker = array(
            'latlng'        => $coords->latitude . ',' . $coords->longitude, // Marker Location
            'popupContent'  => $coords->nama_lengkap, // Popup Content
        );

        $this->leaflet->add_marker($marker);

        $data['map'] =  $this->leaflet->create_map();

        // $data['menu'] = $this->load->view('main_menu', $data, true);
        $this->load->view('pengajuan_lembur/peta_lembur_mulai', $data);
        // $this->load->view('main_template', $data, false);
    }

    public function detail_lembur_selesai($id)
    {
        $data['judul'] = 'Detail Lembur Selesai';
        $data['aktif'] = 'lembur';

        $where = array('id_company' => $this->session->userdata('id_company'));
        $query = $this->db->select('id_company, nama')->get_where('master_company', $where)->row();
        $data['company'] = $query->nama;
        $data['id_company'] = $query->id_company;

        $this->load->library('Leaflet');

        $get_one  = $this->db->select("latitude, longitude")->from("lembur_mulai")->where("md5(id_lemmulai)", $id)->get();

        if ($get_one->num_rows() > 0) {
            $lat  = $get_one->row()->latitude;
            $long = $get_one->row()->longitude;
        } else {
            $lat  = "-6.990581698473311";
            $long = "110.42295643957527";
        }

        $config = array(
            'center'         =>  $lat . ',' . $long, // Center of the map
            'zoom'           =>  15, // Map zoom
        );
        $this->leaflet->initialize($config);

        $coords = $this->db->select("lembur_selesai.tgl_absen, lembur_selesai.jam_absen, lembur_selesai.latitude, lembur_selesai.longitude, lembur_selesai.lokasi_absen, lembur_selesai.keterangan, lembur_selesai.foto, data_karyawan.nama_lengkap")->from("lembur_selesai")->join("data_karyawan", "data_karyawan.id_karyawan = lembur_selesai.id_karyawan", "left")->where("md5(id_lemselesai)", $id)->get()->row();
        //$this->db->query("SELECT lembur_selesai.tgl_absen, lembur_selesai.jam_absen, lembur_selesai.latitude, lembur_selesai.longitude, lembur_selesai.approve, lembur_selesai.lokasi_absen, lembur_selesai.keterangan, lembur_selesai.foto, data_karyawan.nama_lengkap FROM lembur_selesai JOIN data_karyawan ON data_karyawan.id_karyawan = lembur_selesai.id_karyawan WHERE md5(id_lemselesai) = '$id'")->row();
        $data['nama'] = $coords->nama_lengkap;
        $data['lokasi'] = $coords->lokasi_absen;
        $data['jam_absen'] = $coords->jam_absen;
        $data['tanggal'] = date('d-m-Y', strtotime($coords->tgl_absen));
        $data['keterangan'] = $coords->keterangan;
        $data['foto'] = $coords->foto;

        $marker = array(
            'latlng'        => $coords->latitude . ',' . $coords->longitude, // Marker Location
            'popupContent'  => $coords->nama_lengkap, // Popup Content
        );
        $this->leaflet->add_marker($marker);

        $data['map'] =  $this->leaflet->create_map();

        $data['content'] = $this->load->view('pengajuan_lembur/peta_lembur_selesai', $data);
    }

    public function detail($id)
    {
        $slq = 'data_izin.id_izin, data_izin.id_karyawan, data_izin.id_cabang, data_izin.id_departemen, data_izin.tgl_pengajuan, data_izin.tgl_mulai_izin, data_izin.tgl_selesai_izin, data_izin.jml_izin, data_izin.kode_izin, data_izin.nama_izin, data_izin.jenis_izin, data_izin.ket_izin, data_izin.approval_spv, data_izin.approval_kedep, data_izin.approval_kacab, data_izin.approval_hrd, data_izin.approval_direksi, data_izin.file, data_izin.status, data_izin.user_spv, data_izin.user_kedep, data_izin.user_kacab, data_izin.user_hrd, data_izin.user_direksi, data_izin.tgl_apv_spv, data_izin.tgl_apv_kedep, data_izin.tgl_apv_kacab, data_izin.tgl_apv_hrd, data_izin.tgl_apv_direksi, data_izin.id_company, data_izin.tgl_input, data_izin.tgl_update';

        $data['data'] = $this->db_model->get('data_izin', 'data_izin.' . $slq . ', master_jabatan.level_user as usergroup, data_karyawan.nama_lengkap, ', 'md5(data_izin.id_izin) = "' . $id . '"', '', '', '', '',            array(
            array(
                'table' => 'data_karyawan',
                'on' => 'data_karyawan.id_karyawan = data_izin.id_karyawan AND data_karyawan.id_company = data_izin.id_company'
            ),
            array(
                'table' => 'master_jabatan',
                'on' => 'master_jabatan.id_jabatan = data_karyawan.id_jabatan AND master_jabatan.id_company = data_karyawan.id_company'
            )
        ))->row();
        $this->load->view('pengajuan_izin/detail', $data);
    }

    public function form()
    {
        $data['judul'] = 'Tambah Pengajuan Izin';
        $data['aktif'] = 'izin';
        $data['ref'] = 0;
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('pengajuan_izin/form', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function edit($id = 0)
    {
        $data['judul'] = 'Ubah Pengajuan Izin';
        $data['aktif'] = 'izin';
        if ($id != 0) {
            $data['data'] = $this->Pengajuan_lembur_m->getDataById($id);
        }
        $data['ref'] = $id;
        $data['menu'] = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('pengajuan_izin/form', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function modal($id)
    {
        $res = $this->db->select('m.id_lemmulai, m.id_karyawan, m.tgl_absen, m.jam_absen as absen_mulai, s.jam_absen as absen_selesai, m.keterangan as keterangan_mulai, s.keterangan as keterangan_selesai')
                                ->join('lembur_selesai s', 's.id_lemmulai=m.id_lemmulai')
                                ->from('lembur_mulai m')
                                ->where('md5(m.id_lemmulai)', $id)
                                ->get()->row();

        $data['id'] = $id;
        $data['jam_mulai'] = $res->absen_mulai;
        $data['jam_selesai'] = $res->absen_selesai;
        $data['tanggal'] = $res->tgl_absen;
        $data['ket_mulai'] = $res->keterangan_mulai;
        $data['ket_selesai'] = $res->keterangan_selesai;
        $data['id_karyawan'] = $res->id_karyawan;
        $this->load->view('pengajuan_lembur/modal', $data);
    }

    public function save()
    {
        $id = $this->input->post('id_lembur');
        $id_company = $this->session->userdata('id_company');
        $id_karyawan = $this->input->post('karyawan');
        $id_cabang = $this->input->post('cabang');
        $id_jenis = $this->input->post('jenis');

        $zona = $this->db->where('id_company', $id_company)->get('master_company')->row()->zona_waktu;

        if ($zona == 1) {
            date_default_timezone_set("Asia/Jakarta");
        } else if ($zona == 2) {
            date_default_timezone_set('Asia/Makassar');
        } else if ($zona == 3) {
            date_default_timezone_set('Asia/Jayapura');
        }

        $mulai = date('Y-m-d', strtotime($this->input->post('tanggal_mulai')));
        $selesai = date('Y-m-d', strtotime($this->input->post('tanggal_selesai')));
        $tgl_mulai = strtotime($mulai);
        $tgl_selesai = strtotime($selesai);
        $jumlah_hari = ($tgl_selesai - $tgl_mulai) / 60 / 60 / 24;
        $hari = $jumlah_hari + 1;

        /*print($hari);
        exit();*/

        $date = date("Ym");
        $time = date("dhis");


        $file1 = $_FILES['file'];
        if ($file1['name'] == "") {
            $image = 0;
            $file = $this->input->post('file_lama');
        } else {
            //$file1 = $_FILES['foto'];
            $image = 1;
            $explode1    = explode(".", $file1['name']);
            $ext_file1   = end($explode1);
            $times1      = strtotime(date('d his'));
            $path1 = "assets/images/" . $id_company . "/izin/" . $date;
            if (!is_dir($path1)) {
                mkdir($path1, 0777, TRUE);
                fopen($path1 . "/index.php", "w");
            }

            $nama_file1  = $id_karyawan . "_" . $time . "." . $ext_file1;
            $config1['file_name']        = $nama_file1;
            $config1['upload_path']      = $path1;
            $config1['allowed_types']    = 'jpg|png|jpeg|gif';
            $config1['max_size']         = 20000;
            $this->upload->initialize($config1);
            $this->load->library('upload', $config1);

            if ($this->upload->do_upload('file')) {
                $file    =   base_url() . $path1 . '/' . $nama_file1;
            }
        }

        $jenis_izin = $this->db_model->get('master_jenis_izin', 'nama, max_izin', array('kode_izin' => $id_jenis))->row();

        $id_jabatan = $this->db_model->get('data_karyawan', 'id_jabatan', array('id_karyawan' => $id_karyawan))->row()->id_jabatan;
        $level_user = $this->db_model->get('master_jabatan', 'level_user', array('id_jabatan' => $id_jabatan))->row()->level_user;
        //$level_user = $this->db_model->get('users', 'usergroup', array('id_karyawan' => $id_karyawan))->row()->usergroup;

        $approval = $this->db_model->get('p_approval_lembur', 'level_approval', array('level_user' => $level_user, 'id_cabang' => $id_cabang, 'id_company' => $id_company))->row()->level_approval;

        $data_approv = $this->fungsi->approve_data($approval);

        $data = array(
            'id_cabang'    => $this->input->post('cabang'),
            'id_departemen'        => $this->input->post('departemen'),
            'jenis_izin'        => $id_jenis,
            'jml_izin'            => $hari,
            'kode_izin'            => $id_jenis,
            'nama_izin'            => $jenis_izin->nama,
            'id_karyawan'        => $id_karyawan,
            'tgl_mulai_izin'    => date('Y-m-d', strtotime($this->input->post('tanggal_mulai'))),
            'tgl_selesai_izin'    => date('Y-m-d', strtotime($this->input->post('tanggal_selesai'))),
            'file'                 => $file,
            'ket_izin'               => $this->input->post('keterangan'),
            'id_company'        => $id_company
        );

        $result = array_merge($data_approv, $data);

        $this->Pengajuan_lembur_m->save($result, $id);
    }

    public function delete()
    {
        $id = $this->input->post("id_lembur");
        $this->Pengajuan_lembur_m->delete($id);
    }
    //CRUD

    public function approve_to_service($act, $id_lemmulai)
	{
		$res = $this->db->select('m.id_lemmulai, m.id_karyawan, m.jam_absen as absen_mulai, s.jam_absen as absen_selesai')
                                ->join('lembur_selesai s', 's.id_lemmulai=m.id_lemmulai')
                                ->from('lembur_mulai m')
                                ->where('md5(m.id_lemmulai)', $id_lemmulai)
                                ->get()->row();

        if($res != null)
        {
            $id_pengaprove = $this->session->userdata('id_karyawan');
            $id_company	   = $this->session->userdata('id_company');
            $base = $this->config->item('url_api');

            if($act == '4')
            {
                $ok = true;

                $t_mulai = date('Y-m-d H:i:s', strtotime($this->input->post('tgl_mulai').' '.$this->input->post('jam_mulai')));
                $t_selesai = date('Y-m-d H:i:s', strtotime($this->input->post('tgl_selesai').' '.$this->input->post('jam_selesai')));

                if((strtotime($t_selesai) < strtotime($t_mulai)) || strtotime($t_mulai) > strtotime($t_selesai))
                {
                    $ok = false;
                    $ms = 'Lembur selesai tidak boleh kurang dari lembur mulai, dan sebaliknya';
                }

                if((date('Y-m-d H:i', strtotime($res->absen_mulai)) == date('Y-m-d H:i', strtotime($t_mulai))) && (date('Y-m-d H:i', strtotime($res->absen_selesai)) == date('Y-m-d H:i', strtotime($t_selesai))))
                {
                    $u = false;
                }else{
                    $u = true;
                }


                if($ok)
                {
                    if($u == true)
                    {
                        $tgl_absen_mulai = date('Y-m-d', strtotime($this->input->post('tgl_mulai')));
                        $jam_absen_mulai = $t_mulai;
                        $tgl_absen_selesai = date('Y-m-d', strtotime($this->input->post('tgl_selesai')));
                        $jam_absen_selesai = $t_selesai;

                        $u_mulai = $this->db->where('id_lemmulai', $res->id_lemmulai)
                                            ->where('id_karyawan', $res->id_karyawan)
                                            ->set('tgl_absen', $tgl_absen_mulai)
                                            ->set('jam_absen', $jam_absen_mulai)
                                            ->update('lembur_mulai');

                        $u_selesai = $this->db->where('id_lemmulai', $res->id_lemmulai)
                                            ->where('id_karyawan', $res->id_karyawan)
                                            ->set('tgl_absen', $tgl_absen_selesai)
                                            ->set('jam_absen', $jam_absen_selesai)
                                            ->update('lembur_selesai');

                    }

                    #setujui
                    $url_act = $base.'/lembur/setujui/'.$res->id_lemmulai.'/'.$id_pengaprove.'/'.$id_company;
                }else{
                    $url_act = false;
                    $msg = $ms;
                }
            }elseif($act == '3')
            {
                #tolak
                $url_act = $base.'/lembur/tolak/'.$res->id_lemmulai.'/'.$id_pengaprove;
            }else{
                $url_act = false;
            }

            if($url_act !== false)
            {
                $curl = curl_init();
                curl_setopt_array($curl, array(
                CURLOPT_URL => $url_act,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'PATCH',
                ));
                $response = curl_exec($curl);
                curl_close($curl);

            //     echo '<pre>'.var_export($response, true).'</pre>';
            // exit;

                if($response != '')
                {
                    $json = json_decode($response);

                    $data['status'] = $json->success;
                    $data['message'] = $json->message;
                }else{
                    $data['status'] = false;
                    $data['message'] = (isset($msg)) ? $msg : 'Request tidak diketahui';
                }
            }else{
                $data['status'] = false;
                $data['message'] = (isset($msg)) ? $msg : 'Request tidak diketahui';
            }
        }else{
            $data['status'] = false;
			$data['message'] = 'Request tidak diketahui';
        }

		return $data;
	}

    public function approve_spv()
    {
        $id_lemmulai = $this->input->post('id');
		$con = $this->input->post('status');
		$res = $this->approve_to_service($con, $id_lemmulai);
        if ($res['status'] == true) {
			$color = '#009900';
			$status = true;
			$icon = 'fa-check-square';
		} else {
			$color = '#eb3a28';
			$status = false;
			$icon = 'fa-close';
		}

		$json['alert'] = '<font color="'.$color.'"><i class="fa '.$icon.'">&nbsp;</i> '.$res['message'].'</font>';
		$json['success'] = $status;

		$json = __response($this->MY_response, $json);
		echo json_encode($json);
    }

    public function approve_kedep()
    {
        $id_lemmulai = $this->input->post('id');
		$con = $this->input->post('status');
		$res = $this->approve_to_service($con, $id_lemmulai);
        if ($res['status'] == true) {
			$color = '#009900';
			$status = true;
			$icon = 'fa-check-square';
		} else {
			$color = '#eb3a28';
			$status = false;
			$icon = 'fa-close';
		}

		$json['alert'] = '<font color="'.$color.'"><i class="fa '.$icon.'">&nbsp;</i> '.$res['message'].'</font>';
		$json['success'] = $status;

		$json = __response($this->MY_response, $json);
		echo json_encode($json);
    }

    public function approve_kacab()
    {
        $id_lemmulai = $this->input->post('id');
		$con = $this->input->post('status');
		$res = $this->approve_to_service($con, $id_lemmulai);
        if ($res['status'] == true) {
			$color = '#009900';
			$status = true;
			$icon = 'fa-check-square';
		} else {
			$color = '#eb3a28';
			$status = false;
			$icon = 'fa-close';
		}

		$json['alert'] = '<font color="'.$color.'"><i class="fa '.$icon.'">&nbsp;</i> '.$res['message'].'</font>';
		$json['success'] = $status;

		$json = __response($this->MY_response, $json);
		echo json_encode($json);
    }

    public function approve_hrd()
    {
        $id_lemmulai = $this->input->post('id');
		$con = $this->input->post('status');
		$res = $this->approve_to_service($con, $id_lemmulai);
        if ($res['status'] == true) {
			$color = '#009900';
			$status = true;
			$icon = 'fa-check-square';
		} else {
			$color = '#eb3a28';
			$status = false;
			$icon = 'fa-close';
		}

		$json['alert'] = '<font color="'.$color.'"><i class="fa '.$icon.'">&nbsp;</i> '.$res['message'].'</font>';
		$json['success'] = $status;

		$json = __response($this->MY_response, $json);
		echo json_encode($json);
    }

    public function approve_direksi()
    {
        $id_lemmulai = $this->input->post('id');
		$con = $this->input->post('status');
		$res = $this->approve_to_service($con, $id_lemmulai);
        if ($res['status'] == true) {
			$color = '#009900';
			$status = true;
			$icon = 'fa-check-square';
		} else {
			$color = '#eb3a28';
			$status = false;
			$icon = 'fa-close';
		}

		$json['alert'] = '<font color="'.$color.'"><i class="fa '.$icon.'">&nbsp;</i> '.$res['message'].'</font>';
		$json['success'] = $status;

		$json = __response($this->MY_response, $json);
		echo json_encode($json);
    }

    public function download($tgl_mulai=0, $tgl_selesai=0, $status=0, $id_karyawan=0, $id_cabang=0, $id_departemen=0){

            switch ($this->level_user) {
                case '1':
                    $str = 'hrd';
                    break;
                case '2':
                    $str = 'kedep';
                    break;
                case '4':
                    $str = 'direksi';
                    break;
                case '5':
                    $str = 'kacab';
                    break;
                case '7':
                    $str = 'spv';
                    break;

                default:
                    $str = 'hrd';
                    break;
            }

            $appv_sts = [];
            if ($status == '1') {
                $appv_sts = ['1'];
            } elseif ($status == '2') {
                $appv_sts = ['3'];
            } elseif ($status == '3') {
                $appv_sts = ['4'];
            } elseif ($status == '0') {
                $appv_sts = ['1', '2', '3', '4'];
            }
            $appv_lvl = 'lembur_mulai.approval_' . $str;
            $stts['appv_lvl'] = $appv_lvl;
            $stts['appv_sts'] = $appv_sts;
            $stts['appv_flt'] = $status;

            $list = $this->Pengajuan_lembur_m->download($tgl_mulai, $tgl_selesai, $stts, $id_karyawan, $id_cabang, $id_departemen);
            // echo $this->db->last_query();
            // die();

            $data['data'] = $list;
            if($id_karyawan != "0") {
                $nama = $this->_nama_karyawan($id_karyawan);
                $filename = "Data Lembur " . $nama;
            }else{

                if($id_cabang == "0"){
                    $filename   = "Data Lembur Semua Cabang";
                }else{
                    if($id_departemen != "0") {
                        $nama_cab 	  = $this->_nama_cabang($id_cabang);
                        $nama_dep 	  = $this->_nama_departemen($id_departemen);
                        $nama 		  = " Cabang " . $nama_cab . ", Departemen " . $nama_dep;
                        $filename 	  = "Data Lembur " . $nama;
                    }else{
                        $nama 	  = $this->_nama_cabang($id_cabang);
                        $filename = "Data Lembur Cabang " . $nama . " Semua Departemen";
                    }
                }

            }

            $data["title"]              = $filename;
            $data["tanggal_mulai"]      = date_format(date_create($tgl_mulai),"d-m-Y");
            $data["tanggal_selesai"]    = date_format(date_create($tgl_selesai),"d-m-Y");
            $output = true;
            $data['is_excel'] = true;
			$sb_view = $this->load->view('pengajuan_lembur/download', $data, $output);
            // echo $sb_view;
            // exit();
			$tcol = (isset($addcol[0])) ? $addcol[0] : 0;
			$c_length = 16;

			$param = [
                        'download' => true,
                        'cLength'    => $c_length,
                        'file_name'    => strtoupper(str_replace("/","_",$filename)),
                        'paper_size'	=> 'LEGAL',
                        'font-size'		=> 9,
                        'pagebreak'		=> true,
                        'page_margin'	=> ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
                        'orientation'	=> 'landscape',
                        'header'    => [
                            '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                            '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                            '3' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],

                            '4' => ['weight' => 'bold'],
                            '5' => ['weight' => 'bold'],
                            '6' => ['weight' => 'bold'],
                        ],
                        // 'freezecolumn'	   => ['O6'],
                        'thead'        => ['8', '9'],
                        'tbody'        => [
                            'start' => '8',
                            'height'	=> 13,
                            'jarak_footer'	=> 2,
                            // 'runFunction'	=> ['highlightlibur' => 'P'],
                            'wrap' => ['A','B','C','D','E','F','G','H','I','J','K','L','M','N'],
                            'column' => [
                                'A'    => ['width' => 5, 'align' => 'center', 'valign' => 'middle'],
                                'B'    => ['width' => 10, 'align' => 'center', 'valign' => 'middle'],
                                'C'    => ['width' => 10,'align' => 'center'],
                                'D'    => ['width' => 10,'align' => 'center'],
                                'E'    => ['width' => 10,'align' => 'center'],
                                'F'    => ['width' => 9,'align' => 'center'],
                                'G'    => ['width' => 9,'align' => 'center'],
                                'H'    => ['width' => 9,'align' => 'center'],
                                'I'    => ['width' => 9,'align' => 'center'],
                                'J'    => ['width' => 9,'align' => 'center'],
                                'K'    => ['width' => 9,'align' => 'center'],
                                'L'    => ['width' => 9,'align' => 'center'],
                                'M'    => ['width' => 9,'align' => 'center'],
                                'N'    => ['width' => 9,'align' => 'center'],
                                'O'    => ['width' => 9,'align' => 'center'],
                                'P'    => ['width' => 9,'align' => 'center'],
                            ],
                        ],
                    ];
			$this->load->library('PHPExcel/Excel');
			if ($output) {
				$this->excel->generateExcel($sb_view, $param);
			}

    }

    private function _nama_cabang($id_cabang = "0"){
        $this->db->select("nama")
                ->from("master_cabang")
                ->where("id_cabang",$id_cabang)
                ->where("id_company",$this->id_company);

        $query = $this->db->get()->row();
        return $query->nama;
    }

    private function _nama_departemen($id_departemen = "0"){
        $this->db->select("nama")
                ->from("master_departemen")
                ->where("id_departemen",$id_departemen)
                ->where("id_company",$this->id_company);

        $query = $this->db->get()->row();
        return $query->nama;
    }

    private function _nama_karyawan($id_karyawan = "0"){
        $this->db->select("nama_lengkap")
                ->from("data_karyawan")
                ->where("id_karyawan",$id_karyawan)
                ->where("id_company",$this->id_company);

        $query = $this->db->get()->row();
        return $query->nama_lengkap;
    }
}
