<style>
    th,
    td {
        white-space: nowrap;
    }

    div.dataTables_wrapper {
        margin: 0 auto;
    }
</style>
<table id="list_data" class="table table-striped table-bordered" style="width:100%">
    <thead>
        <tr class="bg-tr">
            <th class="text-center" rowspan="2">NO</th>
            <th class="text-center" valign="middle" rowspan="2"><?= strtoupper($this->lang->line('nama_karyawan')); ?></th>
            <th class="text-center" rowspan="2"><?= strtoupper($this->lang->line('cabang')); ?></th>
            <th class="text-center" rowspan="2"><?= strtoupper($this->lang->line('departemen')); ?></th>
            <th class="text-center" rowspan="2"><?= strtoupper($this->lang->line('menu_jabatan')); ?></th>
            <th class="text-center" colspan="<?= ($ttl_periode > 0) ? count($kolom_header['data_tanggal']) : '' ?>"><?= strtoupper($this->lang->line('periode')); ?></th>
        </tr>
        <?php
        if ($ttl_periode > 0) {
            ?>
            <tr class="bg-tr">
                <?php
                $border_left = false;
                foreach ($kolom_header['data_tanggal'] as $row) {
                    if ($row['libur'] == true) {
                        if ($border_left == false) {
                            $border_left_style = $this->config->item('border_left_libur');
                            $border_left       = true;
                        } else {
                            $border_left_style = '';
                        }
                        ?>
                        <th style="background-color: <?= $row['warna'] ?>; color: <?= $row['warna_teks'] ?>; border-color: <?= $row['warna_teks'] ?>; <?= $border_left_style ?>"><?= $row['hari'] . '<br>' . $row['tanggal']; ?></th>
                    <?php } else {
                        $border_left = false; ?>
                        <th><?= $row['hari'] . '<br>' . $row['tanggal']; ?></th>
                    <?php }
                }
                ?>
            </tr>
            <?php
        }
        ?>
    </thead>
    <tbody>
    </tbody>
</table>

<script type="text/javascript">
    $(function () {
        list_data = $('#list_data').DataTable({
            'searching': true,
            'paging': true,
            'lengthChange': true,
            'ordering': false,
            'info': true,
            'scrollX': true,
            'scrollCollapse': true,
            'fixedColumns': {
                'leftColumns': 2,
            },
            'language': {
                'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                'sEmptyTable': 'Tidak ada data untuk ditampilkan'
            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('pengaturan.shift.import.listdata') ?>",
                "type": "POST",
                data: function (d) {
                    d.id_cabang = "<?= $id_cabang ?>";
                },
                "complete": function (data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [
                {
                    "aTargets": [1],
                    "bSortable": true
                },
                {
                    "targets": [<?= $targets_libur_sisa ?>],
                    "className": "dt-libur"
                },
                {
                    "targets": [<?= $targets_libur_left ?>],
                    "className": "dt-libur-left"
                }
            ],
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {

                $('td:eq(0)', nRow).css({
                    'text-align': 'center'
                });

                var kolom_header = "<?= count($kolom_header) ?>";
                for (i = 5; i <= kolom_header; i++) {
                    $('td:eq(' + i + ')', nRow).css({
                        'text-align': 'center'
                    });
                }
            },
        });
    });
</script>