<style>
    #modal-detail-pot-absensi.table-responsive {
        max-height: 490px;
        overflow-y: auto;
    }

    #modal-detail-pot-absensi.table-responsive table {
        font-size: 12px;
    }

    #modal-detail-pot-absensi.table th,
    #modal-detail-pot-absensi.table td {
        padding: 0;
    }

    .sticky-table {
        background-color: #babfc7;
        position: sticky;
    }

    .sticky-table-head {
        inset-block-start: 0;
    }

    .sticky-table-foot {
        inset-block-end: 0;
    }

    .bg-biru {
        background-color: #3d77d4;
        color: white;
    }

    .font-style {
        font-family: "Poppins SemiBold";
        font-size: 14px;
        letter-spacing: normal;
        font-weight: normal;
    }
</style>
<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div class="card-body" disabled>
    <?php if ($data_gapok || $data_upah_lembur || $data_tunj_tetap || $data_tunj_tdk_tetap || $data_tunj_kehadiran) : ?>
        <div>
            <label class="font-style">Pendapatan yang Diikutsertakan Potongan Absensi</label>
            <table class="mb-1" style="width: 95%">
                <?php
                $number = 1;
                $ttl_potongan = 0;

                if (isset($data_gapok)) :
                ?>
                    <tr>
                        <td width="25"><?= $number ?>.</td>
                        <td class="w-75">Gaji Pokok</td>
                        <td width="25">Rp</td>
                        <td class="text-right"><?= number_format($data_gapok, 0, ',', '.') ?></td>
                    </tr>
                <?php
                    $ttl_potongan += $data_gapok;
                    $number++;
                endif;

                if (isset($data_upah_lembur)) :
                ?>
                    <tr>
                        <td width="25"><?= $number ?>.</td>
                        <td class="w-75">Upah Lembur</td>
                        <td width="25">Rp</td>
                        <td class="text-right"><?= number_format($data_upah_lembur, 0, ',', '.') ?></td>
                    </tr>
                <?php
                    $ttl_potongan += $data_upah_lembur;
                    $number++;
                endif;

                foreach ($data_tunj_tetap as $tunj) :
                ?>
                    <tr>
                        <td width="25"><?= $number ?>.</td>
                        <td class="w-75"><?= $tunj->nm_tunjangan ?></td>
                        <td width="25">Rp</td>
                        <td class="text-right"><?= number_format($tunj->nominal_tunjangan, 0, ',', '.') ?></td>
                    </tr>
                <?php
                    $ttl_potongan += $tunj->nominal_tunjangan;
                    $number++;
                endforeach;

                foreach ($data_tunj_tdk_tetap as $tunj) :
                ?>
                    <tr>
                        <td width="25"><?= $number ?>.</td>
                        <td class="w-75"><?= $tunj->nm_tunjangan ?></td>
                        <td width="25">Rp</td>
                        <td class="text-right"><?= number_format($tunj->nominal_tunjangan, 0, ',', '.') ?></td>
                    </tr>
                <?php
                    $ttl_potongan += $tunj->nominal_tunjangan;
                    $number++;
                endforeach;

                foreach ($data_tunj_kehadiran as $tunj) :
                ?>
                    <tr>
                        <td width="25"><?= $number ?>.</td>
                        <td class="w-75"><?= $tunj->nm_tunjangan ?></td>
                        <td width="25">Rp</td>
                        <td class="text-right"><?= number_format($tunj->ttl_tunjangan, 0, ',', '.') ?></td>
                    </tr>
                <?php
                    $ttl_potongan += $tunj->ttl_tunjangan;
                    $number++;
                endforeach;
                ?>
                <tr>
                    <td colspan="2" class="w-75 py-1">Maksimal Potongan Absensi</td>
                    <td class="font-weight-bold" width="25">Rp</td>
                    <td class="font-weight-bold text-right border-top border-light"><?= number_format($ttl_potongan, 0, ',', '.') ?></td>
                </tr>
            </table>
        </div>
    <?php else : ?>
        <div class="alert alert-danger" role="alert">
            Tidak ada data tunjangan yang diikutsertakan potongan absensi
        </div>
    <?php endif; ?>
    <div id="modal-detail-pot-absensi" class="table-responsive">
        <table class="table table-striped table-bordered mb-0" style="width:100%">
            <thead class="text-black text-center sticky-table sticky-table-head">
                <th class="align-top text-uppercase">Tanggal</th>
                <th class="align-top text-uppercase">Terlambat</th>
                <th class="align-top text-uppercase">Pulang Cepat</th>
                <th class="align-top text-uppercase">TAP</th>
                <th class="align-top text-uppercase">Alpa</th>
            </thead>
            <tbody>
                <?php if ($data) : ?>
                    <?php
                    $ttl_t    = 0;
                    $ttl_pc   = 0;
                    $ttl_tap  = 0;
                    $ttl_alpa = 0;

                    foreach ($data as $value) :
                    ?>
                        <tr>
                            <td class="text-center" style="white-space: nowrap; width: 100px"><?= date('d-m-Y', strtotime($value->tgl_absen)) ?></td>
                            <td style="white-space: nowrap;">
                                <?php
                                echo $value->t_menit . ' menit';
                                echo '<br>';
                                if ($value->t_kelipatan_p == 1) {
                                    echo 'Rp ' . number_format($value->t_nominal, 0, ',', '.') . ' per ' . $value->t_menit_p . ' menit';
                                } else {
                                    echo '>' . $value->t_menit_p . ' menit = Rp ' . number_format($value->t_nominal, 0, ',', '.');
                                }
                                echo '<hr>';
                                echo 'Rp ' . number_format($value->t_ttl, 0, ',', '.');
                                $ttl_t += $value->t_ttl;
                                ?>
                            </td>
                            <td style="white-space: nowrap;">
                                <?php
                                echo $value->pc_menit . ' menit';
                                echo '<br>';
                                if ($value->pc_kelipatan_p == 1) {
                                    echo 'Rp ' . number_format($value->pc_nominal, 0, ',', '.') . ' per ' . $value->pc_menit_p . ' menit';
                                } else {
                                    echo '>' . $value->pc_menit_p . ' menit = Rp ' . number_format($value->pc_nominal, 0, ',', '.');
                                }
                                echo '<hr>';
                                echo 'Rp ' . number_format($value->pc_ttl, 0, ',', '.');
                                $ttl_pc += $value->pc_ttl;
                                ?>
                            </td>
                            <td style="white-space: nowrap;">
                                <?php
                                echo 'Rp <span class="float-right">' . number_format($value->tap_ttl, 0, ',', '.') . '</span>';
                                $ttl_tap += $value->tap_ttl;
                                ?>
                            </td>
                            <td style="white-space: nowrap;">
                                <?php
                                echo 'Rp <span class="float-right">' . number_format($value->alpa_ttl, 0, ',', '.') . '</span>';
                                $ttl_alpa += $value->alpa_ttl;
                                ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else : ?>
                    <tr class="text-center">
                        <td colspan="5" class="text-light"><i class="fa fa-info-circle"></i> Data tidak ditemukan</td>
                    </tr>
                <?php endif; ?>
            </tbody>
            <tfoot class="sticky-table-foot sticky-table">
                <tr class="text-black">
                    <td rowspan="2" class="text-center align-middle font-weight-bold text-uppercase">Total Potongan Absensi</td>
                    <td style="white-space: nowrap;">Rp <span class="float-right"><?= number_format($ttl_t, 0, ',', '.') ?></span></td>
                    <td style="white-space: nowrap;">Rp <span class="float-right"><?= number_format($ttl_pc, 0, ',', '.') ?></span></td>
                    <td style="white-space: nowrap;">Rp <span class="float-right"><?= number_format($ttl_tap, 0, ',', '.') ?></span></td>
                    <td style="white-space: nowrap;">Rp <span class="float-right"><?= number_format($ttl_alpa, 0, ',', '.') ?></span></td>
                </tr>
                <tr class="font-weight-bold text-black">
                    <td colspan="4" class="text-center align-middle" style="white-space: nowrap;font-size: 14px;">Rp <?= number_format(array_sum(array_column((array)$data, 'ttl_potongan')), 0, ',', '.') ?></td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>
