<script type="text/javascript">
    $(document).ready(function () {
        $('.filter #id_cabang').select2({
            placeholder: '<?= $this->lang->line('semua_cabang') ?>',
            allowClear:true,
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: true
            },
            minLength: 3,
        });
    });


    function tambah_jadwal(e){
       $('#modal_form #tampil_form').load("<?= route('patroli.jadwal.form.tambah') ?>",function(){
            $('#modal_form').modal('show');
            $(".title").text("<?= $this->lang->line('title_form_tambah_data') ?>");
            $(".btn_save").addClass("btn_save btn btn-primary");
            $(".btn_save").append('<i class="fa fa-save"></i> ');
            $(".btn_save").append('<?= $this->lang->line('button_form_simpan') ?>');
            $('.btn_save').attr('onClick','simpan(this)');
            $("#btn_new_input").hide();
        });
    }


    function edit_jadwal(e){
        $('#modal_form #tampil_form').load("<?= route('patroli.jadwal.form.edit') ?>"+"/"+$(e).attr('id'),function(){
            $('#modal_form').modal('show');
            $(".title").text("<?= $this->lang->line('title_form_edit_data') ?>");
            $(".btn_save").addClass("btn_save btn btn-warning");
            $(".btn_save").append('<i class="fa fa-edit (alias)"></i> ');
            $(".btn_save").append('<?= $this->lang->line('button_form_perbarui') ?>');
            $(".btn_save").removeClass("btn_save").addClass("btn_update btn btn-warning");
            $('.btn_update').attr('onClick','simpan(this)');
            $("#btn_new_input").hide();
        });
    }

    function delete_jadwal(e){
        $('#modal_form #tampil_form').load("<?= route('patroli.jadwal.form.hapus') ?>"+"/"+$(e).attr('id'),function(){
            $('#modal_form').modal('show');
            $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
            $("#form_input :input").prop("disabled", true);
            $("#jenis").prop("disabled", true);
            $(".btn_save").append('<i class="fa fa-trash"></i> ');
            $(".btn_save").append('<?= $this->lang->line('button_form_hapus') ?>');
            $(".btn_save").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
            $('.btn_hapus').attr('onClick','hapus_action(this)');
        });
    }

    function new_input(e){
        $("#form_input :input").prop("disabled", false);
        $('#form_input input[type=text]').prop("disabled",false);
        $("#form_input input[type=text]").val('');
        $("#form_input #id_cabang_form").select2("val","0");
        
        $('.btn_save').show();
        $('#btn_new_input').hide();
        $('#message').hide();
    }

    function simpan(e){
        $('#message').html("");
        var loading = Ladda.create(e);

        if($("#id_cabang_form").val()=="0"){
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_pilih_cabang') ?></font>");
            $("#id_cabang_form").focus();
            return false;
        }else if($("#nm_jadwal").val() ==""){
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_nama_jadwal') ?>");
            $('#nm_jadwal').focus();
            return false;
        }else if($("#min_absen").val() ==""){
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jam_mulai') ?></font>");
            $('#min_absen').focus();
            return false;
        }else if($("#max_absen").val() ==""){
            $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> <?= $this->lang->line('error_jam_selesai') ?></font>");
            $('#max_absen').focus();
            return false;
        }

        loading.start();

        var param = 'id_jadwal='+$("#id_jadwal").val()+
                    '&id_cabang='+$("#id_cabang_form").val()+
                    '&nm_jadwal='+$("#nm_jadwal").val()+
                    '&min_absen='+$("#min_absen").val()+
                    '&max_absen='+$("#max_absen").val();

        $.ajax({
            type: 'POST',
            url: "<?= route('patroli.jadwal.save') ?>",
            data: param,
            dataType:'JSON',
            success: function(result) {
                if(result.success == true){
                    if(result.type == 'save'){
                        $("#form_input :input").prop("disabled", true);
                        $("#jenis").prop("disabled", true);
                        $('.btn_save').hide();
                        $('#btn_new_input').show();
                    }
                }
                loading.stop();
                $('#message').show();
                $('#message').html(result.message);
            },
            error:function(){
                loading.stop();
                $('#message').show();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : <?= $this->lang->line('error') ?></strong></font>');
            }
        });
    }

    function hapus_action(e){
        var loading = Ladda.create(e);
        loading.start();
        var param = {};
        param.id_jadwal=$("#id_jadwal").val();
        $.ajax({
            type: 'POST',
            url: "<?= route('patroli.jadwal.delete') ?>",
            data: param,
            dataType:'JSON',
            success: function(result){
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html(result.message);
                
            },
            error:function(){
                loading.stop();
                $("#modal_form .card-body").hide();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    }
</script>
<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('patroli') ?></a>
                        </li>
                        <li class="breadcrumb-item active"><?= $judul ?>
                        </li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="content-header-right col-md-6 col-12">
             <?php
                if (in_array($this->level_user, array("1"))) {
            ?>
            <div class="float-md-right">
                <button type="button" class="btn_tambah_jadwal btn btn-biru" onclick="tambah_jadwal(this)">
                    <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_data') ?>
                </button>
            </div>
            <?php
                }
            ?>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="row filter">
                <?php
                    if(in_array($this->level_user, array("1","4")) || in_array($this->khusus, array("1")) || $this->multi_cabang == true) {
                ?>
                        <div class="col-md-4">
                            <select id="id_cabang" class="form-control select2"></select>
                        </div>
                        <div class="col-md-1">
                            <button type="button" id="btn_filter" class="btn btn-primary ladda-button" data-style="expand-left">FILTER</button>
                        </div>
                <?php
                    }
                ?>
            </div>
                <div class="row mt-2">
                    <div class="col-md-12">
                        <table id="list_data" class="table table-striped" style="width:100%">
                            <thead>
                                <tr>
                                    <th class="text-center">NO</th>
                                    <th class="text-left text-uppercase"><?= $this->lang->line('cabang') ?></th>
                                    <th class="text-left text-uppercase"><?= $this->lang->line('nama_jadwal') ?></th>
                                    <th class="text-center text-uppercase"><?= $this->lang->line('jam_mulai') ?></th>
                                    <th class="text-center text-uppercase"><?= $this->lang->line('jam_selesai') ?></th>
                                    <?php
                                        if(in_array($this->level_user, array("1"))) {
                                    ?>
                                    <th class="text-center text-uppercase"><?= $this->lang->line('aksi') ?></th>
                                    <?php
                                        }
                                    ?>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
        </div>
    </div>
</div>

<!-- START TAMPIL MODAL -->
<!-- <div id="modal_form" class="modal fade in">
    <div class="modal-dialog modal-md">
        <div id="tampil_form" class="modal-content"></div>
    </div>
</div> -->
<!-- END TAMPIL MODAL -->

<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({ 
                    'searching'   : true,
                    'paging'      : true,
                    'lengthChange': true,
                    'ordering'    : true,
                    'info'        : true,
                    'scrollX'     : true,
                    // 'lengthMenu'  : [1, 10],
                    // 'scrollCollapse': true,
                    // 'fixedColumns': true,
                    // 'fixedColumns': true,
                    'language': {
                        <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                            'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                            'searchPlaceholder': 'Nama Jadwal'
                        <?php else : ?> 'searchPlaceholder': 'Schedule Name'
                        <?php endif; ?>
                    },
                    "processing"  : true, 
                    "serverSide"  : true, 
                    "order"       : [], 
                    
                    "ajax"        : {
                                        "url": "<?= route('patroli.jadwal.list.data') ?>",
                                        "type": "GET",
                                        "data": { 
                                                    id_cabang : function() { 
                                                        return $(".filter #id_cabang").val() 
                                                    },
                                                },
                                        "complete" : function(data){
                                            reconfigure(data);
                                        }
                                    },
            
                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false }
                                        <?php
                                            if (in_array($this->level_user, array("1"))) {
                                        ?>
                                        , { "aTargets": [5], "bSortable": false }

                                        <?php }?>
                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                            $('td:eq(0)', nRow).css({'text-align':'center','width':'10px'});
                            $('td:eq(3)', nRow).css({'text-align':'center'});
                            $('td:eq(4)', nRow).css({'text-align':'center'});

                            <?php
                                if (in_array($this->level_user, array("1"))) {
                            ?>

                            $('td:eq(5)', nRow).css({'text-align':'center','width':'50px'});

                            <?php }?>
                    }
        
        });

        $(document).on('click','.filter #btn_filter',function(){
            var loading = Ladda.create(this);
            loading.start();
            list_data.ajax.reload(function(){
                loading.stop();
            });
        });
    });
</script>