<script type="text/javascript">
    $(function() {
        // Datatable
        list_data = $('#list_data').DataTable({
            'searching': true,
            'paging': true,
            'lengthChange': true,
            'ordering': true,
            'info': true,
            'scrollX': true,
            // 'scrollCollapse': true,
            // 'fixedColumns': true,
            'language'    :{
                                'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                'searchPlaceholder': 'Karyawan'
                            },
            "processing": true,
            "serverSide": true,
            "order": [],

            "ajax": {
                "url": "<?= route('kpi.pengaturan.approver.data') ?>",
                "type": "GET",
                "data": {
                    status_atasan: function() {
                        return $('input[name="status_atasan"]:checked').val();
                    },
                },
                "complete": function(data) {
                    reconfigure(data);
                }
            },

            "aoColumnDefs": [{
                    "aTargets": [0,1,2,3,4,5],
                    "bSortable": false
                },

            ],
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                $('td:eq(0)', nRow).css({
                    'text-align': 'center',
                    'width': '10px'
                });

                $('td:eq(1)', nRow).css({
                    'width': '300px'
                });

                $('td:eq(2)', nRow).css({
                    'text-align': 'center',
                    'width': '150px'
                });

                $('td:eq(3)', nRow).css({
                    'text-align': 'center',
                    'width': '150px'
                });

                $('td:eq(5)', nRow).css({
                    'text-align': 'center',
                     'width': '50px'
                });
            }

        });
    });

    function change_filter(){
        list_data.ajax.reload();
    }

    // START CRUD
    function edit(e){
        $('#tampil_form').load("<?= route('kpi.pengaturan.approver.form.edit') ?>"+ "/" + $(e).attr('id'), function() {
            $('#modal_form').modal('show');
            $(".title").text("Form Edit Data");
            $(".btn_update").addClass("btn_update btn btn-warning");
            $(".btn_update").append('<i class="fa fa-edit (alias)"></i> ');
            $(".btn_update").append('Perbarui');
            $('.btn_update').attr('onClick','perbarui(this)');
            $("#btn_new_input").hide();
        });
    }

    function perbarui(e){
        $('#message').html("");
        var loading = Ladda.create(e);
        // if ($("#id_atasan").val() == "") {
        //     $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Approver belum dipilih</font>");
        //     $("#id_atasan").focus();
        //     return false;
        // }

        loading.start();
        var param = 'id_karyawan=' + $("#id_karyawan").val() +
                    '&id_atasan=' + $("#id_atasan").val()+
                    '&action=' + $("#action").val();

        $.ajax({
            type: 'POST',
            url: "<?= route('kpi.pengaturan.approver.update') ?>",
            data: param,
            dataType: 'JSON',
            success: function(result) {
                if (result.success == true) {
                    if (result.type == 'update') {
                        $("#form_input :input").prop("disabled", true);
                        $('.btn_update').hide();
                    }

                    setTimeout(() => {
                        $("#modal_form").modal("hide");
                    }, 2000);
                }

                loading.stop();
                $('#message').show();
                $('#message').html(result.message);
            },
            error: function() {
                loading.stop();
                $('#message').show();
                $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    }
    // END CRUD
</script>

<div class="row align-items-center mt-1">
    <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
        <h5 class="dark-blue-color">Approver</h5>
    </div>
</div> 
<hr>

<div class="filter mt-2">
    <div class="row">
        <div class="col-md-2 align-self-center">
            <label class="font-weight-bold">STATUS ATASAN</label>
        </div>
        <div class="col-md-6">
            <div class="row custom-radio-blue">
                <div class="col-md-3">
                    <section class="light">
                        <label id="label">
                            <input type="radio" name="status_atasan" value="all" onclick="change_filter()" checked>
                            <span class="design"></span>
                            <span class="text">Semua</span>
                        </label>
                    </section>
                </div>
                <div class="col-md-4">
                    <section class="light">
                        <label id="label">
                            <input type="radio" name="status_atasan" value="sudah" onclick="change_filter()">
                            <span class="design"></span>
                            <span class="text">Sudah Disetting</span>
                        </label>
                    </section>
                </div>
                <div class="col-md-4">
                    <section class="light">
                        <label id="label">
                            <input type="radio" name="status_atasan" value="belum" onclick="change_filter()">
                            <span class="design"></span>
                            <span class="text">Belum Disetting</span>
                        </label>
                    </section>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="table-responsive mt-3">
    <table id="list_data" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th class="text-center">No</th>
                <th class="text-left">Karyawan</th>
                <th class="text-center">Jabatan</th>
                <th class="text-center">Departemen</th>
                <th class="text-left">Approver</th>
                <th class="text-center">Aksi</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
