<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Import_m extends CI_Model {
    var $table = 'pkwt_data_temp';

    public function __construct(){
      parent::__construct();
    }

    function get_datatables(){
      $this->_get_datatables_query();
      if($_GET['length'] != -1){
          $this->db->limit($_GET['length'], $_GET['start']);
      }
      $query = $this->db->get();
      return $query->result();
    }

    function count_filtered(){
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }

  public function count_all(){
      $this->_get_datatables_query();
      return $this->db->count_all_results();
  }

  private function _get_datatables_query(){
      $this->db->select(" data.id_pkwt_temp,
                          data.id_karyawan,
                          data.nik,
                          data.nm_karyawan,
                          data.lahir_tempat,
                          data.lahir_tgl,
                          data.alamat,
                          data.nm_lvl_user,
                          data.nm_jabatan,
                          data.nm_departemen,
                          data.nm_cabang,
                          data.tgl_pkwt,
                          data.tgl_pkwt_mulai,
                          data.tgl_pkwt_selesai,
                          data.nm_direktur,
                          data.ttd_direktur,
                          data.ttd_karyawan,
                          data.nm_draft_pkwt,
                          data.status,
                          data.apv_karyawan,
                          data.apv_direksi,
                          data.tgl_apv_karyawan,
                          data.tgl_apv_direksi,
                          data.user_apv_karyawan,
                          data.user_apv_direksi,
                          data.flag,
                          data.id_company,
                          data.user_input,
                          data.tgl_input,
                          data.user_update,
                          data.tgl_update")
                  ->from('pkwt_data_temp AS data')
                  ->where("data.id_company",$this->id_company)
                  ->where("data.jenis_pkwt", "perpanjangan");

      $column_search = array('nik');
      $i = 0;

      foreach ($column_search as $item){  // looping awal
          if($_GET['search']['value']){ // jika datatable mengirimkan pencarian dengan metode POST

              if($i===0){ // looping awal
                  $this->db->group_start();
                  $this->db->like($item, $_GET['search']['value']);
              }else{
                  $this->db->or_like($item, $_GET['search']['value']);
              }

              if(count($column_search) - 1 == $i){
                  $this->db->group_end();
              }
          }
          $i++;
      }

      $column_order = array('','nik');

      if(isset($_GET['order'])){
          $this->db->order_by($column_order[$_GET['order']['0']['column']], $_GET['order']['0']['dir']);
      }
      else{
          $order_by = array("tgl_input"=>"DESC");
          $this->db->order_by(key($order_by), $order_by[key($order_by)]);
      }
  }

  public function total_tunjangan($id_pkwt=''){
      $ttl_tunjangan = $this->db->select("SUM(tunj.nominal_komp) AS total_nominal")
                          ->from("pkwt_komp_tunj_trx_temp AS tunj")
                          ->where("tunj.id_company",$this->id_company)
                          ->where('id_pkwt_temp', $id_pkwt)
                          ->get()
                          ->row()
                          ->total_nominal;

      return $ttl_tunjangan;
  }

  function nama_karyawan_arr($id_karyawan) {
    return $this->db->select('nama_lengkap')
        ->where_in('id_karyawan', $id_karyawan)
        ->where('id_company', $this->id_company)
        ->from('data_karyawan')->get()->result();
    }

    public function getDataById($id){
        $this->db->select(" data.id_pkwt_temp AS id_pkwt,
                            data.id_karyawan,
                            data.nik,
                            data.nm_karyawan AS nama_lengkap,
                            data.lahir_tempat AS tempat_lahir,
                            data.lahir_tgl AS tgl_lahir,
                            data.alamat AS alamat_domisili,
                            data.nm_lvl_user AS nama_level_user,
                            data.nm_jabatan AS nama_jabatan,
                            data.nm_departemen AS nama_departemen,
                            data.nm_cabang AS nama_cabang,
                            data.lahir_tgl,
                            data.alamat,
                            data.nm_lvl_user,
                            data.nm_jabatan,
                            data.nm_departemen,
                            data.nm_cabang,
                            data.tgl_pkwt_mulai,
                            data.tgl_pkwt_selesai,
                            data.tgl_pkwt,
                            data.nm_direktur,
                            data.ttd_direktur,
                            data.ttd_karyawan,
                            data.nm_draft_pkwt,
                            data.draft_pkwt_parameter,
                            data.draft_pkwt_value,
                            data.status,
                            data.apv_karyawan,
                            data.apv_direksi,
                            data.tgl_apv_karyawan,
                            data.tgl_apv_direksi,
                            data.user_apv_karyawan,
                            data.user_apv_direksi,
                            data.flag,
                            data.id_company,
                            data.user_input,
                            data.tgl_input,
                            data.user_update,
                            data.tgl_update");
        $this->db->from('pkwt_data_temp AS data');
        $this->db->where("MD5(data.id_pkwt_temp)",$id);
        $this->db->where("data.id_company",$this->id_company);
        
        $query = $this->db->get();
        return $query->row();
    }

    public function getDataExisting($id_karyawan = ''){
        $this->db->select("id_karyawan");
        $this->db->from("pkwt_data");
        $this->db->where("id_company",$this->id_company);
        $this->db->where("id_karyawan",$id_karyawan);
		$this->db->where("status !=", "3");
        
        $result = $this->db->get();
        return $result->num_rows();
    }
}