<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Data_keluarga_pengajuan_m extends CI_Model {
    var $table = 'data_keluarga_p';

    public function list_data($id_karyawan = null){
        $id_company = $this->session->userdata("id_company");
        $query = "SELECT id_keluarga,
                        nama,
                        tempat_lahir,
                        tanggal_lahir,
                        jenis_kelamin,
                        agama,
                        telepon,
                        pekerjaan,
                        hub_keluarga,
                        status_perkawinan,
                        nik,
                        no_bpjs,
                        pendidikan_terakhir,
                        tanggal_perkawinan,
                        status,
                        status_pengajuan,
                        ket_revisi,
                        action
                FROM {$this->table}
                WHERE id_karyawan = ?
                AND id_company = ?
                ORDER BY (CASE hub_keluarga

                                WHEN 'Ayah'
                                THEN 1

                                WHEN 'Ibu'
                                THEN 2

                                WHEN 'Suami'
                                THEN 3

                                WHEN 'Istri'
                                THEN 4

                                WHEN 'Anak'
                                THEN 5

                                WHEN 'Saudara Kandung'
                                THEN 6

                                END) ASC";
        return $this->db->query($query, array($id_karyawan,$id_company))->result();
    }

    function get_data_pengajuan($id_karyawan_md5) {
      $this->db->where('id_karyawan', $id_karyawan_md5);
      $this->db->where('id_company', $this->session->userdata('id_company'));
      $this->db->where_in('status_pengajuan', array('1','3','4'));
      return $this->db->get($this->table);
    }

    function total_pengajuan() {
      $this->db->where('id_company', $this->session->userdata('id_company'));
      $this->db->where_in('status_pengajuan', array('1','3','4'));
      return $this->db->get($this->table);
    }

    function get_data($id_karyawan_md5) {
      $this->db->where('id_karyawan', $id_karyawan_md5);
      $this->db->where('id_company', $this->session->userdata('id_company'));
      return $this->db->get($this->table);
    }

    function delete($id) {
      $this->db->where('id_keluarga', $id);
      $this->db->where('id_company', $this->session->userdata('id_company'));
      return $this->db->delete($this->table);
    }

    function approve($id, $status, $keterangan = '') {

      $this->db->set('status_pengajuan', $status);
      if($keterangan != '') {
        $this->db->set('ket_revisi', $keterangan);
      }
      $this->db->where('id_keluarga', $id);
      $this->db->where('id_company', $this->session->userdata('id_company'));
      return $this->db->update($this->table);
    }

    function insert_history($id) {
      $sql = "INSERT INTO data_keluarga_h (id_keluarga,
                                          id_karyawan,
                                          nama,
                                          tempat_lahir,
                                          tanggal_lahir,
                                          jenis_kelamin,
                                          agama,
                                          telepon,
                                          pekerjaan,
                                          hub_keluarga,
                                          status_perkawinan,
                                          nik,
                                          no_bpjs,
                                          pendidikan_terakhir,
                                          tanggal_perkawinan,
                                          status,
                                          action,
                                          id_company
                                        )
                                   SELECT data_keluarga.id_keluarga,
                                          data_keluarga.id_karyawan,
                                          data_keluarga.nama,
                                          data_keluarga.tempat_lahir,
                                          data_keluarga.tanggal_lahir,
                                          data_keluarga.jenis_kelamin,
                                          data_keluarga.agama,
                                          data_keluarga.telepon,
                                          data_keluarga.pekerjaan,
                                          data_keluarga.hub_keluarga,
                                          data_keluarga.status_perkawinan,
                                          data_keluarga.nik,
                                          data_keluarga.no_bpjs,
                                          data_keluarga.pendidikan_terakhir,
                                          data_keluarga.tanggal_perkawinan,
                                          data_keluarga_p.status,
                                          data_keluarga_p.action,
                                          data_keluarga.id_company
              FROM data_keluarga JOIN data_keluarga_p ON data_keluarga_p.id_keluarga = data_keluarga.id_keluarga 
              WHERE data_keluarga.id_keluarga = ? AND data_keluarga.id_company = ?";
      return $this->db->query($sql, array($id, $this->session->userdata('id_company')));
    }

    function update_data($id_keluarga) {
      $sql = "UPDATE data_keluarga a
              JOIN data_keluarga_p b ON b.id_keluarga = a.id_keluarga AND a.id_karyawan = b.id_karyawan AND a.id_company = b.id_company
              SET a.nama = b.nama,
              a.tempat_lahir = b.tempat_lahir,
              a.tanggal_lahir = b.tanggal_lahir,
              a.jenis_kelamin = b.jenis_kelamin,
              a.agama = b.agama,
              a.telepon = b.telepon,
              a.pekerjaan = b.pekerjaan,
              a.hub_keluarga = b.hub_keluarga,
              a.status_perkawinan = b.status_perkawinan,
              a.nik = b.nik,
              a.no_bpjs = b.no_bpjs,
              a.pendidikan_terakhir = b.pendidikan_terakhir,
              a.tanggal_perkawinan = b.tanggal_perkawinan,
              a.status = b.status
              WHERE a.id_keluarga = ? AND a.id_company = ?";
      return $this->db->query($sql, array($id_keluarga, $this->session->userdata('id_company')));
    }

    function cek_id($id) {
      $this->db->join('data_keluarga','data_keluarga.id_keluarga = data_keluarga_p.id_keluarga');
      $this->db->where('data_keluarga_p.id_keluarga', $id);
      return $this->db->get('data_keluarga_p')->num_rows();
    }

    function insert_master($id) {
      $sql = "INSERT INTO data_keluarga (id_keluarga,
                                          id_karyawan,
                                          nama,
                                          tempat_lahir,
                                          tanggal_lahir,
                                          jenis_kelamin,
                                          agama,
                                          telepon,
                                          pekerjaan,
                                          hub_keluarga,
                                          status_perkawinan,
                                          nik,
                                          no_bpjs,
                                          pendidikan_terakhir,
                                          tanggal_perkawinan,
                                          status,
                                          id_company
                                        )
                                  SELECT id_keluarga,
                                          id_karyawan,
                                          nama,
                                          tempat_lahir,
                                          tanggal_lahir,
                                          jenis_kelamin,
                                          agama,
                                          telepon,
                                          pekerjaan,
                                          hub_keluarga,
                                          status_perkawinan,
                                          nik,
                                          no_bpjs,
                                          pendidikan_terakhir,
                                          tanggal_perkawinan,
                                          status,
                                          id_company
              FROM data_keluarga_p WHERE id_keluarga = ? AND id_company = ?";
      return $this->db->query($sql, array($id, $this->session->userdata('id_company')));
    }

    function hapus_data($id) {
      $this->db->where('id_keluarga', $id);
      return $this->db->delete('data_keluarga');
    }

    function getDataById($id) {
      $this->db->where('data_keluarga_p.id_keluarga', $id);
      return $this->db->get('data_keluarga_p')->row();
    }
}
