<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Habis_masa_kerja extends MY_Controller {

	public function __construct(){
        parent::__construct();
        $this->load->model('pkwt/perpanjang/Habis_masa_kerja_m', 'habis_masa_kerja_m');
    }

    public function list_data($tanggal_mulai="0000-00-00", $tanggal_selesai="0000-00-00", $id_cabang="", $id_departemen="", $id_karyawan=""){
		$list = $this->habis_masa_kerja_m->get_datatables($tanggal_mulai, $tanggal_selesai, $id_cabang, $id_departemen, $id_karyawan);
		$data = array();
		$no = $_GET['start'];
		foreach ($list as $field) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $field->nama_lengkap. "<br><b>". $field->nik.'</b>';
			$row[] = $field->nama_jabatan. "<br><b>". $field->level_user.'</b>';
			$row[] = $field->kode_cabang. " - ". $field->nama_cabang. "<br>". $field->kode_departemen. " - ". $field->nama_departemen;
			$row[] = indo_date(strtotime($field->tgl_berhenti_bekerja), "d F Y");
			
            $btn_hapus = '<a href="#" class="btn_tambah_pkwt" id="'.MD5($field->id_karyawan).'">
                            <button type="button" class="btn btn-success">
                                <i class="fa fa-check"></i> PERPANJANG
                            </button>
                            </a>';

            $row[] = $btn_hapus;

			$data[] = $row;
		}

		$output = array("draw"            => $_GET['draw'],
						"recordsTotal"    => $this->habis_masa_kerja_m->count_all($tanggal_mulai, $tanggal_selesai, $id_cabang, $id_departemen, $id_karyawan),
						"recordsFiltered" => $this->habis_masa_kerja_m->count_filtered($tanggal_mulai, $tanggal_selesai, $id_cabang, $id_departemen, $id_karyawan),
						"data"            => $data);

		$output = __response($this->MY_response, $output);

		echo json_encode($output);
	}

	public function tambah_pkwt($id=null){
		$data['data'] = $this->habis_masa_kerja_m->getDataById($id);
		$this->load->view('pkwt/perpanjang/form',$data);
	}

	public function save(){
		$this->nama_lengkap = $this->session->userdata('nama_user');
		$this->nik 			= $this->session->userdata('nik');

		$id_karyawan 		= $this->input->post('id_karyawan');
		$nik 				= $this->input->post('nik');
		$nm_karyawan 		= $this->input->post('nm_karyawan');
		$lahir_tempat 		= $this->input->post('lahir_tempat');
		$lahir_tgl 			= $this->input->post('lahir_tgl');
		$alamat 			= $this->input->post('alamat');
		$nm_level_user		= $this->input->post('nm_level_user');
		$nm_jabatan 		= $this->input->post('nm_jabatan');
		$nm_departemen 		= $this->input->post('nm_departemen');
		$nm_cabang 			= $this->input->post('nm_cabang');
		$tgl_pkwt 			= $this->input->post('tgl_pkwt');
		$tgl_pkwt_mulai 	= $this->input->post('tgl_pkwt_mulai');
		$tgl_pkwt_selesai 	= $this->input->post('tgl_pkwt_selesai');
		$nm_draft_pkwt 		= $this->input->post('nm_draft_pkwt');
		$draft_pkwt_parameter = $this->input->post('draft_pkwt_parameter');

		$draft_pkwt_value = [];
		foreach(json_decode($draft_pkwt_parameter, 1) as $key => $value) {
			$draft_pkwt_value[$key] = $value == 'nominal' ? str_replace('.','',htmlentities($this->input->post('param_'.$key))) : htmlentities($this->input->post('param_'.$key));
		}

		$tgl_pkwt 			= date('Y-m-d', strtotime($tgl_pkwt));
		$tgl_pkwt_mulai 	= date('Y-m-d', strtotime($tgl_pkwt_mulai));
		$tgl_pkwt_selesai 	= date('Y-m-d', strtotime($tgl_pkwt_selesai));

		$id_pkwt			= $this->input->post('id_pkwt');
		if(empty($id_pkwt)){
			$id_pkwt_decrypt = $this->fungsi->getNextId('pkwt_data', 'id_pkwt', $this->id_company, 4);
		}else{
			$id_pkwt_decrypt = $this->_get_id_pkwt($id_pkwt);
		}

		$data_pkwt	= array('id_pkwt'			=> $id_pkwt_decrypt,
							'no_pkwt'              => '',
							'id_karyawan'          => $id_karyawan,
							'nik'                  => $nik,
							'nm_karyawan'          => $nm_karyawan,
							'lahir_tempat'         => $lahir_tempat,
							'lahir_tgl'            => $lahir_tgl,
							'alamat'               => $alamat,
							'nm_lvl_user'          => $nm_level_user,
							'nm_jabatan'           => $nm_jabatan,
							'nm_departemen'        => $nm_departemen,
							'nm_cabang'            => $nm_cabang,
							'tgl_pkwt'             => $tgl_pkwt,
							'tgl_pkwt_mulai'       => $tgl_pkwt_mulai,
							'tgl_pkwt_selesai'     => $tgl_pkwt_selesai,
							'status'               => '0',
							'apv_karyawan'         => '0',
							'apv_direksi'          => '0',
							'jenis_pkwt'           => 'perpanjangan',
							'nm_draft_pkwt'        => $nm_draft_pkwt,
							'id_template'          => htmlentities($this->input->post('id_template')),
							'draft_pkwt_parameter' => $this->input->post('draft_pkwt_parameter'),
							'draft_pkwt_value'     => json_encode($draft_pkwt_value),
							'id_company'           => $this->id_company,
							'tgl_input'            => date("Y-m-d H:i:s"),
							'user_input'           => $this->nik. " - ". $this->nama_lengkap,
						);
		
		if(empty($id_pkwt)){
			// PROSES SAVE
			$this->db->trans_start();
			$this->db->insert('pkwt_data', $data_pkwt);
			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$message = '<font color="#FFFFF"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal disimpan</font>';
				return __response_save(false,["message"=>$message]);
			}else{
				$this->db->trans_commit();
				$message = '<font color="#FFFFF"><i class="fa fa-check-square">&nbsp;</i>Data berhasil disimpan</font>';
				return __response_save(true,["message"=>$message]);
			}
		}else{
			// PROSES UPDATE
			$this->db->trans_start();

			$this->db->where('MD5(id_pkwt)', $id_pkwt);
			$this->db->where('id_company', $this->id_company);
			$this->db->update('pkwt_data', $data_pkwt);

			$this->db->trans_complete();

			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
				$message = '<font color="#FF0000"><i class="fa fa-exclamation-triangle">&nbsp;</i>Data gagal diperbahurui</font>';
				return __response_update(false,["message"=>$message]);
			}else{
				$this->db->trans_commit();
				$message = '<font color="#008000"><i class="fa fa-check-square">&nbsp;</i>Data berhasil diperbahurui</font>';
				return __response_update(true,["message"=>$message]);
			}
		}
	}

	// Get Id PKWT Untuk Save
	private function _get_id_pkwt($id){
		$query = $this->db->select('id_pkwt')
							->from('pkwt_data')
							->where('id_company', $this->id_company)
							->where('MD5(id_pkwt)', $id)
							->get()
							->row()
							->id_pkwt;
		return $query;
	}
}