<?php
class Bpjs_config extends MY_Controller {

        public function __construct(){
                parent::__construct();

                $this->load->model('payroll/bpjs/Bpjs_kes_m');
                $this->load->model('payroll/bpjs/Bpjs_tk_m');
                $this->load->helper('payroll');
        }

        public function index()
        {       
                $data['data_bpjs_kes'] = $this->Bpjs_kes_m->get_config();
                $data['data_bpjs_tk']  = $this->Bpjs_tk_m->get_config();
                $this->load->view('payroll/bpjs/config/home', $data);
        }

        public function form($jenis, $name = null) {
                if($jenis == 'bpjs_kes') {
                        $data['data'] = $this->Bpjs_kes_m->get_config();
                        $this->load->view('payroll/bpjs/config/form_bpjs_kes', $data);
                } elseif($jenis == 'bpjs_tk') {
                        $data['tipe'] = strtoupper(str_replace('flag_', '', $name));
                        $data['data'] = $this->Bpjs_tk_m->get_config();
                        $data['name'] = $name;
                        $this->load->view('payroll/bpjs/config/form_bpjs_tk', $data);
                }
        }

        public function input_nominal($name) {
                $data['data'] = $this->Bpjs_tk_m->get_config();
                $data['name'] = $name;
                echo $this->load->view('payroll/bpjs/config/input_nominal', $data, TRUE);
        }

        public function save_nominal() {
                $params = [];
                $save       = $this->Bpjs_tk_m->save_nominal();
                if($save) {
                        $data['data']       = $this->Bpjs_tk_m->get_config();
                        $data['name']       = $this->input->post('name');
                        $params['new_params'] = ['html' => $this->load->view('payroll/bpjs/config/value_nominal', $data, TRUE)];
                }
                __response_save($save, $params);
        }

        public function save($jenis) {
                if($jenis == 'bpjs_kes') {
                        $this->save_bpjs_kes();
                } elseif($jenis == 'bpjs_tk') {
                        $this->save_bpjs_tk();
                }
        }

        private function save_bpjs_kes() {
                $flag_temp = $this->input->post('flag_temp');
                $flag   = $this->input->post('flag');
                $params = [];

                if($flag_temp == '0') {
                        $flag = '1';
                } else {
                        $flag = '0';
                }

                $save = $this->Bpjs_kes_m->save($flag);
                if($save) {
                        $params['new_params'] = ['new_flag' => $flag];
                }
                __response_save($save, $params);
        }

        private function save_bpjs_tk() {
                $params = [];
		$temp   = $this->input->post('temp');

                if($temp == '0') {
			$flag = '1';
		} else {
			$flag = '0';
		}
                $save = $this->Bpjs_tk_m->save($flag);
                if($save) {
                        $params['new_params'] = ['new_flag' => $flag];
                }
                __response_save($save, $params);  
        }
}