<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Dropdown extends MY_Controller {

    public function obyektives() {
        $this->db->select('id_object_m, nm_object, no_urut');
        $this->db->from('kpi_object_m');
        $this->db->where('id_company', $this->id_company);
        $this->db->like('nm_object', htmlentities($this->input->get('q')));
        $this->db->order_by('no_urut ASC');
        $result = $this->db->get()->result();
        foreach($result as $row) {
            $json[] = [
                'id'      => $row->id_object_m,
                'text'    => $row->nm_object,
                'no_urut' => $row->no_urut
            ];
        }
        echo json_encode($json);
    }

    public function kpiBawahan($input = null) {
        $this->load->helper('kpi/kpi');
        $tahun = htmlentities($this->input->get('tahun'));
        $bulan = htmlentities($this->input->get('bulan'));
        $search = htmlentities($this->input->get('search'));

        if($input == null) {
            $periode = periodeTarget($tahun, $bulan);
        } else {
            $periode['isPeriodeInput'] = false;
        }
        
        if($periode['isPeriodeInput']) {
            $this->db->select('dk.id_karyawan, dk.nik, dk.nama_lengkap');
            $this->db->from('data_karyawan dk');
            $this->db->join('kpi_approver_p apv', 'apv.id_karyawan = dk.id_karyawan');
            $this->db->where('dk.id_company', $this->id_company);
            $this->db->where_in('dk.status', ['1', '2', '3', '4']);
            $this->db->where('apv.id_atasan', $this->id_karyawan);
            $this->db->like('dk.nama_lengkap', $search);
        } else {
            $this->db->select('dk.id_karyawan, dk.nik, dk.nama_lengkap');
            $this->db->from('data_karyawan dk');
            $this->db->join('kpi_trx apv', "apv.id_karyawan = dk.id_karyawan and apv.id_atasan = '$this->id_karyawan' and apv.tahun = $tahun and apv.bulan = $bulan");
            $this->db->where('dk.id_company', $this->id_company);
            $this->db->where_in('dk.status', ['1', '2', '3', '4']);
            $this->db->like('dk.nama_lengkap', $search);
        }
        $result = $this->db->get()->result();
        foreach($result as $row) {
            $json[] = [
                'id'      => $row->id_karyawan,
                'text'    => "$row->nik - $row->nama_lengkap"
            ];
        }
        echo json_encode($json);
    }
}