<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Saldo_cuti extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Saldo_cuti_m', 'model');
    }

    public function index()
    {
        $data['judul']   = $this->lang->line('menu_saldo_cuti');
        $data['aktif']   = 'saldo_cuti';
        $data['menu']    = $this->load->view('main_menu', $data, true);
        $data['content'] = $this->load->view('saldo_cuti/home', $data, true);
        $this->load->view('main_template', $data, false);
    }

    public function list_data($cabang = 'all', $departemen = 'all')
    {
        $list = $this->model->get_datatables($cabang, $departemen);
        $data = array();
        $no = $_GET['start'];

        foreach ($list as $field) {
            $no++;

            $row = array();
            $row[] = $no;
            $row[] = $field->nama_lengkap . '<br><b>' . $field->nik . '</b>';
            $row[] = $field->kode_cabang . ' - ' . $field->nama_cabang;
            $row[] = $field->kode_departemen . ' - ' . $field->nama_departemen;
            $row[] = $field->kode_jabatan . ' - ' . $field->nama_jabatan;
            $row[] = ($field->jatah_cuti + $field->carry_forward);
            $row[] = '
                <a href="' . route('history.cuti.index', ['id_karyawan' => md5($field->id_karyawan)]) . '" class="text-secondary" title="DETAIL">
                    <i class="fa fa-info-circle (alias) "> </i>
                </a>';

            $data[] = $row;
        }

        $output = array(
            "draw"            => $_GET['draw'],
            "recordsTotal"    => $this->model->count_all($cabang, $departemen),
            "recordsFiltered" => $this->model->count_filtered($cabang, $departemen),
            "data"            => $data
        );

        $output = __response($this->MY_response, $output);

        echo json_encode($output);
    }

    public function form($id = null)
    {
        if ($id == null) {
            $this->load->view('saldo_cuti/form');
        } else {
            $data['data'] = $this->model->getDataById($id);
            $this->load->view('saldo_cuti/form', $data);
        }
    }

    public function save()
    {
        $saldo                    = $this->input->post('saldo');
        $keterangan               = $this->input->post('keterangan');
        $jenis                    = $this->input->post('jenis');
        $target                   = $this->input->post('target');
        $target_select_cabang     = $this->input->post('target_select_cabang');
        $target_select_departemen = $this->input->post('target_select_departemen');
        $target_select_karyawan   = $this->input->post('target_select_karyawan');
        // validasi
        if ($saldo === '') {
            $message = ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_jumlah_saldo') . '</font>'];
            return __response_save(false, $message);
        }
        if (empty($keterangan)) {
            $message = ['message' => '<font color="#eb3a28"><i class="fa fa-exclamation-triangle">&nbsp;</i>' . $this->lang->line('error_keterangan') . '</font>'];
            return __response_save(false, $message);
        }

        $data = array(
            'saldo'                    => $saldo,
            'keterangan'               => $keterangan,
            'jenis'                    => $jenis,
            'target'                   => $target,
            'target_select_cabang'     => $target_select_cabang,
            'target_select_departemen' => $target_select_departemen,
            'target_select_karyawan'   => $target_select_karyawan,
        );
        $this->model->save($data);
    }

    public function delete()
    {
        $id = $this->input->post("id_jenis_izin");
        $this->model->delete($id);
    }

    public function download($cabang = "all", $departemen = "all")
    {
        // FILENAME
        if ($cabang == "all" && $departemen == "all") {
            $filename = $this->lang->line('daftar_saldo_cuti') . $this->lang->line('filename_semua_cabang');
        } else {
            $filename = $this->lang->line('daftar_saldo_cuti');
        }

        if ($cabang != "all") {
            $nama_cabang = $this->db->select("nama")
                ->from("master_cabang")
                ->where("id_cabang", $cabang)
                ->where("id_company", $this->id_company)
                ->get()
                ->row("nama");

            $filename .= " " . $this->lang->line('filename_cabang') . " " . $nama_cabang;
        }

        if ($departemen != "all") {
            $nama_departemen = $this->db->select("nama")
                ->from("master_departemen")
                ->where("id_departemen", $departemen)
                ->where("id_company", $this->id_company)
                ->get()
                ->row("nama");

            $filename .= " " . $this->lang->line('filename_departemen') . " " . str_replace("/", "-", $nama_departemen);
        }
        // dd($filename);
        $data["filename"] = $filename;
        $data["data"]     = $this->model->get_datatables($cabang, $departemen);
        $sb_view          = $this->load->view('saldo_cuti/download_excel', $data, true);

        $param  = [
            'download'   => true,
            'cLength'    => 7,
            'file_name'  => strtoupper(str_replace(" ", "_", $filename)),
            'paper_size' => 'A4',
            'font-size'  => 9,
            // 'pagebreak'   => true,
            'page_margin' => ['top' => 0, 'right' => 0.75, 'left' => 0.75, 'botom' => 0],
            'orientation' => 'potrait',
            'header'      => [
                '1' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
                '2' => ['merge' => true, 'align' => 'center', 'weight' => 'bold'],
            ],
            'freezecolumn' => ['A5'],
            'thead'        => ['3', '4'],
            'tbody'        => [
                'start'  => '3',
                'height' => 15,
                'wrap'   => ['B', 'C', 'D', 'E'],
                'column' => [
                    'A' => ['width' => 6, 'align' => 'center', 'valign' => 'middle'],
                    'B' => ['format' => 'text', 'bentuk' => 'bentuk-text', 'valign' => 'middle'],
                    'C' => ['format' => 'text', 'valign' => 'middle'],
                    'D' => ['format' => 'text', 'valign' => 'middle'],
                    'E' => ['format' => 'text', 'valign' => 'middle'],
                    'F' => ['format' => 'text', 'valign' => 'middle'],
                    'G' => ['width' => 15, 'align' => 'center', 'format' => 'text', 'valign' => 'middle'],
                    'H' => ['width' => 15, 'align' => 'center', 'format' => 'text', 'valign' => 'middle'],
                ],
            ],
        ];

        $this->load->library('PHPExcel/Excel');
        $this->excel->generateExcel($sb_view, $param);
    }

    // public function getJenis_izinByName($id = null)
    // {
    //     $search = $this->input->get("q");
    //     $nama_paket = $this->model->max_karyawan()->nama;
    //     $this->model->getCabangByName($id, $search, $nama_paket);
    // }
}
