<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-10 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">PKWT</li>
                        <li class="breadcrumb-item active"><?= $judul ?></li>
                    </ol>
                </div>
            </div>
        </div>
        <div class="col-2 text-right">
            <a href="<?= route('pkwt.master.template.form.tambah') ?>">
                <button type="button" class="btn_tambah btn btn-biru">
                    <i class="fa fa-plus"></i> Tambah Data
                </button>
            </a>
        </div>
    </div>
</div>
<div class="card card-rounded">
    <div class="card-content">
        <div class="card-body">
            <div class="table-responsive">
                <table id="list_data" class="table table-striped table-bordered" style="width:100%">
                    <thead>
                        <tr>
                            <th class="no-sort text-center _center" width="50">NO</th>
                            <th class="no-sort text-center">NAMA TEMPLATE</th>
                            <th class="no-sort text-center _center" width="100">AKSI</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    $(document).on('click', '.btn_delete', function() {
        $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
        $("#modal_form .ladda-button").html('');
        $("#modal_form .card-footer").show();
        $("#modal_form .ladda-button").append('<i class="fa fa-trash"></i> ');
        $("#modal_form .ladda-button").append('<?= $this->lang->line('button_form_hapus') ?>');
        $("#modal_form .ladda-button").removeClass("btn_save").addClass("btn_hapus btn btn-danger");
        $('#modal_form .ladda-button').attr('id', $(this).attr('id'));
        $('#modal_form').modal('show');
    });

    $(document).on('click', '.btn_hapus', function() {
        var loading = Ladda.create(this);
        loading.start();

        var param = {
            id_template : $(this).attr('id')
        };

        $.ajax({
            type: 'POST',
            url: "<?= route('pkwt.master.template.delete') ?>",
            data: param,
            dataType: 'JSON',
            success: function(result) {
                loading.stop();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html(result.message.replace("009900", "FFFFFF"));
            },
            error: function() {
                loading.stop();
                $("#modal_form .card-footer").hide();
                $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong><?= $this->lang->line('error') ?></strong></font>');
            }
        });
    });
    
    $(function() {
        // datatables
        list_data = $('#list_data').DataTable({
            'searching'   : false,
            'searchDelay' : 1000,
            'paging'      : true,
            'lengthChange': true,
            'ordering'    : true,
            'info'        : true,
            'scrollX'     : true,
            'language'    : {
                <?php if ($this->code_lang == 'id') : ?> 'url': '<?= base_url("assets/plugins/datatables/dataTables-language-id.json") ?>',
                    'sEmptyTable': 'Tidak ada data untuk ditampilkan',
                    'searchPlaceholder': 'Kode/Nama'
                <?php else : ?> 'searchPlaceholder': 'Code/Name'
                <?php endif; ?>
            },
            "processing": true,
            "serverSide": true,
            "order": [],
            "ajax": {
                "url" : "<?= route('pkwt.master.template.list-data') ?>",
                "type": "GET"
            },
            columnDefs : [
                { targets : 'no-sort', sortable: false },
                { targets : '_center', className: 'text-center' }
            ]
        });
    });
</script>