<script type="text/javascript">
    $(document).ready(function() {
        $('#form_input #id_cabang_form').select2({
            placeholder: '<?= $this->lang->line('pilih_cabang') ?>',
            ajax: {
                // type: 'POST',
                url: '<?= route("dropdown.cabang") ?>',
                dataType: 'json',
                delay: 250,
                processResults: function (data) {
                return {
                        results: data
                    };
                },
                cache: true
            },
            minLength: 3,
        });
    });
</script>

<div class="card-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h3 class="title modal-title"></h3>
</div>
<div id="form_input" class="card-body" disabled>
    <input type="hidden" id="id_jadwal" class="form-control" value="<?= ((isset($data))?md5($data->id):'') ?>">
    <div class="form-group">
        <label><?= $this->lang->line('cabang') ?> <i class="text-danger">*</i></label>
        <select id="id_cabang_form" class="form-control select2" style="width:100%">
            <option value="0"><?= $this->lang->line('pilih_cabang') ?></option>
            <?php
                if(isset($data)){
                    echo '<option value="'.$data->id_cabang.'" selected>'.$data->kode_cabang.' - '.$data->nama_cabang.'</option>';
                }
            ?>
        </select>
    </div>
        
    <div class="form-group">
        <label><?= $this->lang->line('nama_jadwal') ?> <i class="text-danger">*</i></label>
        <input type="text" id="nm_jadwal" class="form-control" value="<?= ((isset($data))?$data->nm_jadwal:'') ?>">
    </div>
    <div class="form-group">
        <label><?= $this->lang->line('jam_mulai') ?> <i class="text-danger">*</i></label>
        <input id="min_absen" type="text" class="form-control" data-inputmask="'alias': 'datetime','inputFormat': 'HH:MM'" placeholder="HH:MM" value="<?= ((isset($data))?$data->min_absen:'') ?>">
    </div>
    <div class="form-group">
        <label><?= $this->lang->line('jam_selesai') ?> <i class="text-danger">*</i></label>
        <input id="max_absen" type="text" class="form-control" data-inputmask="'alias': 'datetime','inputFormat': 'HH:MM'" placeholder="HH:MM" value="<?= ((isset($data))?$data->max_absen:'') ?>">
    </div>
</div>
<div class="card-footer">
    <div class="row">
        <div class="col-md-7 text-left">
            <div id="message"></div>
        </div>
        <div class="col-md-5 text-right">
            <button id="btn_new_input" class="btn" onclick="new_input(this)" style="display:none"><?= $this->lang->line('button_form_tambah_baru') ?></button>
            <button class="btn_save ladda-button" data-style="expand-left"></button>
        </div>
    </div>
</div>