<script type="text/javascript">
    $(document).ready(function() {
        list_data();

        // form tambah data
        $('.btn_tambah_sertifikat').click(function() {
            $('#tampil_form').load("<?= route('master.karyawan.sertifikat.form.tambah') . '/' . $id_karyawan_md5 ?>", function() {
                $('#modal_form').modal('show');
                $(".title").text("<?= $this->lang->line('title_form_tambah_data') ?>");
                $(".btn_save_sertifikat").addClass("btn_save_sertifikat btn btn-primary");
                $(".btn_save_sertifikat").append('<i class="fa fa-save"></i> ');
                $(".btn_save_sertifikat").append('<?= $this->lang->line('button_form_simpan') ?>');
                $("#btn_new_input").hide();
                simpan_data();
            });
        });
    });

    function list_data() {
        $("#list_data").load("<?= route('master.karyawan.sertifikat.data') . '/' . $id_karyawan_md5 ?>", function() {

            //btn_edit
            $('.btn_edit_sertifikat').click(function() {
                $('#tampil_form').load("<?= route('master.karyawan.sertifikat.form.edit') . '/' . $id_karyawan_md5 . '/' ?>" + $(this).attr('id'), function() {
                    $('#modal_form').modal('show');
                    $(".title").text("<?= $this->lang->line('title_form_edit_data') ?>");
                    $(".btn_save_sertifikat").addClass("btn_save_sertifikat btn btn-warning");
                    $(".btn_save_sertifikat").append('<i class="fa fa-edit (alias)"></i> ');
                    $(".btn_save_sertifikat").append('<?= $this->lang->line('button_form_perbarui') ?>');
                    $("#btn_new_input").hide();
                    simpan_data();
                });
            });

            $('.btn_delete_sertifikat').click(function() {
                $('#tampil_form').load("<?= route('master.karyawan.sertifikat.form.delete') . '/' . $id_karyawan_md5 . '/' ?>" + $(this).attr('id'), function() {
                    $('#modal_form').modal('show');
                    $(".title").text("<?= $this->lang->line('title_form_hapus_data') ?>");
                    $('#form_input input[type=text]').prop("disabled", true);
                    $('#form_input input[type=date]').prop("disabled", true);
                    $('#form_input input[type=file]').prop("disabled", true);
                    $('#jenjang, #lulusan_asal').prop("disabled", true);
                    $(".btn_save_sertifikat").append('<i class="fa fa-trash"></i> ');
                    $(".btn_save_sertifikat").append('<?= $this->lang->line('hapus') ?>');
                    $(".btn_save_sertifikat").removeClass("btn_save_sertifikat").addClass("btn_hapus_sertifikat btn btn-danger");
                    hapus_data();
                });
            });
        });
    }

    //btn_save
    function simpan_data() {
        $('.btn_save_sertifikat').click(function(e) {
            e.preventDefault();
            $('#message').html("");
            var loading = Ladda.create(this);

            if ($("#nama_sertifikat").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Nama Sertifikat/Pelatihan belum diisi</font>");
                $("#nama_sertifikat").focus();
                return false;
            } else if ($("#penyelenggara").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Penyelenggara belum diiisi</font>");
                $('#penyelenggara').focus();
                return false;
            } else if ($("#tgl_berlaku").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal Berlaku belum diiisi</font>");
                $('#tgl_berlaku').focus();
                return false;
            } else if ($("#tgl_berakhir").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Tanggal Berakhir belum diiisi</font>");
                $('#tgl_berakhir').focus();
                return false;
            } else if ($("#deskripsi").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Deskripsi belum diiisi</font>");
                $('#deskripsi').focus();
                return false;
            }
            if (document.getElementById("sertifikat").files.length == 0 && $("#sertifikat_lama").val() == "") {
                $('#message').html("<font style='color:Crimson'><i class='fa fa-exclamation-triangle'></i> Sertifikat belum diupload</font>");
                $('#sertifikat').focus();
                return false;
            }


            loading.start();

            var param = new FormData();
            param.append('nama_sertifikat', $("#nama_sertifikat").val());
            param.append('penyelenggara', $("#penyelenggara").val());
            param.append('tgl_berlaku', $("#tgl_berlaku").val());
            param.append('tgl_berakhir', $("#tgl_berakhir").val());
            param.append('deskripsi', $("#deskripsi").val());
            param.append('file', $('#sertifikat').prop('files')[0]);
            param.append('file_lama', $("#sertifikat_lama").val());
            param.append('id_sertifikat', $("#id_sertifikat").val());
            param.append('id_karyawan', $("#id_karyawan").val());

            $.ajax({
                type: 'POST',
                url: "<?= route('master.karyawan.sertifikat.save') ?>",
                data: param,
                dataType: 'JSON',
                contentType: false,
                processData: false,
                cache: false,
                success: function(result) {
                    if (result.success == true) {
                        if (result.type == 'save') {
                            btn_new_input();
                            $("#form_input :input").prop("disabled", true);
                            $('#form_input input[type=file]').prop("disabled", true);
                            $('.btn_save_sertifikat').hide();
                            $('#btn_new_input').show();
                        } else {
                            $("#form_input #sertifikat_lama").val(result.sertifikat);
                        }
                        list_data();
                    }
                    loading.stop();
                    $('#message').show();
                    $('#message').html(result.message);
                },
                error: function() {
                    loading.stop();
                    $('#message').show();
                    $('#message').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
    }

    function hapus_data() {
        $('.btn_hapus_sertifikat').click(function(e) {
            var loading = Ladda.create(this);
            loading.start();
            $.ajax({
                type: 'POST',
                url: "<?= route('master.karyawan.sertifikat.delete') ?>",
                data: 'id_sertifikat=' + $("#id_sertifikat").val(),
                dataType: 'JSON',
                success: function(result) {
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html(result.message);
                    if (result.success == true) {
                        list_data();
                    }
                },
                error: function() {
                    loading.stop();
                    $("#modal_form .card-body").hide();
                    $("#modal_form .card-footer").hide();
                    $("#modal_form .title").html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        });
    }

    function btn_new_input() {
        $('#btn_new_input').click(function() {
            var sertifikat = $('#form_input #sertifikat').dropify();
            sertifikat = sertifikat.data('dropify');
            sertifikat.resetPreview();
            sertifikat.clearElement();

            $('#form_input input[type=file]').prop("disabled", false);
            $("#form_input input[type=file]").val('');

            $('#form_input input[type=text]').prop("disabled", false);
            $("#form_input input[type=text]").val('');

            $('.btn_save_sertifikat').show();
            $('#btn_new_input').hide();
            $('#message').hide();
        });
    }
</script>
<?php if ($this->session->userdata('level_user') == 1) {
    echo $tab . "<br>";
} ?>

<div class="row">
    <div class="col-md-12 text-right">
        <button type="button" class="btn_tambah_sertifikat btn btn-biru btn-min-width mb-1" id="tambah_sertifikat">
            <i class="fa fa-plus"></i> <?= $this->lang->line('button_tambah_sertifikat_pelatihan') ?>
        </button>
    </div>
</div>
<div class="row">
    <div id="list_data" class="col-md-12"></div>
</div>
