<div class="content-header">
    <div class="row align-items-center">
        <div class="content-header-left col-md-6 col-12 mb-md-0 mb-1">
            <h3 class="content-header-title"><?= $judul ?></h3>
            <div class="row breadcrumbs-top">
                <div class="breadcrumb-wrapper col-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#"><?= $this->lang->line('menu_pengaturan') ?></a></li>
                        <li class="breadcrumb-item"><a href="#"><?= $judul ?></a></li>
                        <li class="breadcrumb-item active"><?= $nama_cabang ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card card-rounded">
    <div class="card-content">
        <form id="update_form" method="post">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table dataTable no-footer table-striped">
                        <thead>
                            <tr>
                                <th class="text-center text-uppercase"><?= strtoupper($this->lang->line('hari')); ?></th>
                                <th class="text-center text-uppercase"><?= $this->lang->line('jam_masuk_shift'); ?></th>
                                <th class="text-center text-uppercase"><?= $this->lang->line('jam_pulang_shift'); ?></th>
                                <th class="text-center text-uppercase"><?= $this->lang->line('min_jam_masuk_shift'); ?></th>
                                <th class="text-center text-uppercase"><?= $this->lang->line('max_jam_pulang_shift'); ?></th>
                                <?php
                                if ($this->level_user == '1') {
                                ?>
                                    <th style="text-align: center;"><?= $this->lang->line('aksi'); ?></th>
                                <?php } ?>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php
                if (in_array($this->level_user,  array("1","4"))) { ?>
                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" id="update" name='update' class="btn btn-success pull-right ladda-button" data-style="expand-left"><i class="fa fa-save"></i> <?= $this->lang->line('button_form_simpan'); ?></button>
                            <label id="message_form" class="pull-right p-1"></label>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </form>
    </div>
</div>


<script type="text/javascript">
    $(document).ready(function() {
        var level_user = '<?= $this->level_user ?>';
        var libur_lang = '<?= $this->lang->line('libur'); ?>';
        var libur_lang_tc = toTitleCase(libur_lang);

        $.ajaxSetup({
            headers: {
                'Csrf-Token': $('meta[name="csrf-token"]').attr('content')
            }
        });

        fetch_data();

        function fetch_data() {
            var param = {};
            param.id_cabang = "<?= $id_cabang ?>";

            $.ajax({
                type: 'POST',
                url: "<?= route('pengaturan.jamkerja.jadwal') ?>",
                data: param,
                dataType: 'JSON',
                success: function(result) {

                    var html = '';
                    for (var count = 0; count < result.data.length; count++) {
                        // multi bahasa
                        var lang = '<?= $this->code_lang ?>';
                        if (lang == "id") {
                            var nama_hari = result.data[count].nama;
                        } else {
                            var nama_hari = result.data[count].nama_english;
                        }

                        html += '<tr>';

                        if (result.data[count].libur == 1) {
                            html += '<td style="text-align: center;">' + nama_hari + '</td>';
                            html += '<td style="text-align: center;">' + "-" + '</td>';
                            html += '<td style="text-align: center;">' + "-" + '</td>';
                            html += '<td style="text-align: center;">' + "-" + '</td>';
                            html += '<td style="text-align: center;">' + "-" + '</td>';

                            // if(level_user == '1'){

                            // 	// html += '<td style="text-align: center;"><div class="badge badge-danger">LIBUR</div>&nbsp;&nbsp;&nbsp;';
                            // }

                            if (level_user == '1') {

                                html += '<td style="text-align: center;">';
                                html += '<div class="badge badge-danger">' + libur_lang + '</div>&nbsp;&nbsp;&nbsp;';
                                html += '<input type="checkbox" id="' + result.data[count].id_jam_kerja + '" data-nama="' + nama_hari + '" data-masuk="' +
                                    result.data[count].masuk + '" data-pulang="' + result.data[count].pulang + '" data-start-absen-masuk="' + result.data[count].start_absen_masuk + '" data-batas-absen-pulang="' + result.data[count].batas_absen_pulang + '" data-libur="' + result.data[count].libur +
                                    '" class="check_box" style="position: initial; opacity: 1" /> Edit</td>';
                            }
                        } else {
                            html += '<td class="text-center">' + nama_hari + '</td>';
                            html += '<td class="text-center">' + result.data[count].masuk + '</td>';
                            html += '<td class="text-center">' + result.data[count].pulang + '</td>';
                            html += '<td class="text-center">' + result.data[count].start_absen_masuk + '</td>';
                            html += '<td class="text-center">' + result.data[count].batas_absen_pulang + '</td>';
                            if (level_user == '1') {

                                html += '<td style="text-align: center;">';
                                html += '<input type="checkbox" id="' + result.data[count].id_jam_kerja + '" data-nama="' + nama_hari + '" data-masuk="' +
                                    result.data[count].masuk + '" data-pulang="' + result.data[count].pulang + '" data-start-absen-masuk="' + result.data[count].start_absen_masuk + '" data-batas-absen-pulang="' + result.data[count].batas_absen_pulang + '" data-libur="' + result.data[count].libur +
                                    '" class="check_box" style="position: initial; opacity: 1" /> Edit</td>';
                            }
                        }


                        html += '</tr>';

                    }
                    $('tbody').html(html);
                },
                error: function() {
                    loading.stop();
                    $('#message_form').show();
                    $('#message_form').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                }
            });
        }

        $(document).on('click', '.check_box', function() {
            var html = '';
            var id_jam_kerja = $(this).attr('id');
            var hari = $(this).data('nama');
            var jam_masuk = $(this).data('masuk');
            var jam_pulang = $(this).data('pulang');
            var start_absensi_masuk = $(this).data('start-absen-masuk');
            var batas_absen_pulang = $(this).data('batas-absen-pulang');
            var libur = $(this).data('libur');

            var btn_libur_unchecked = '<input type="checkbox" id="' + id_jam_kerja + '" data-nama="' + hari + '" data-masuk="' + jam_masuk + '" data-pulang="' + jam_pulang + '" data-start-absen-masuk="' + start_absensi_masuk + '" data-batas-absen-pulang="' + batas_absen_pulang + '" data-libur="' + libur + '" class="libur text-center" style="position: initial; opacity: 1"/> ' + libur_lang_tc;
            var btn_libur_checked = '<input type="checkbox" id="' + id_jam_kerja + '" data-nama="' + hari + '" data-masuk="' + jam_masuk + '" data-pulang="' + jam_pulang + '" data-start-absen-masuk="' + start_absensi_masuk + '" data-batas-absen-pulang="' + batas_absen_pulang + '" data-libur="' + libur + '" class="libur text-center" style="position: initial; opacity: 1" checked/> ' + libur_lang_tc;

            var btn_edit_unchecked = '<input type="checkbox" id="' + id_jam_kerja + '" data-nama="' + hari + '" data-masuk="' + jam_masuk + '" data-pulang="' + jam_pulang + '" data-start-absen-masuk="' + start_absensi_masuk + '" data-batas-absen-pulang="' + batas_absen_pulang + '" data-libur="' + libur + '"  class="check_box text-center" style="position: initial; opacity: 1"/> Edit';
            var btn_edit_checked = '<input type="checkbox" id="' + id_jam_kerja + '" data-nama="' + hari + '" data-masuk="' + jam_masuk + '" data-pulang="' + jam_pulang + '" data-start-absen-masuk="' + start_absensi_masuk + '" data-batas-absen-pulang="' + batas_absen_pulang + '" data-libur="' + libur + '"  class="check_box text-center" style="position: initial; opacity: 1" checked/> Edit';

            if (this.checked) {
                if ($(this).data('libur') == 0) {

                    html += '<input type="hidden" name="hidden_id[]" value="' + id_jam_kerja + '" />';
                    html += '<input type="hidden" name="libur[]" value="' + libur + '" />';
                    html += '<td class="text-center">' + hari + '</td>';
                    html += '<td class="text-center"><input type="text" name="masuk[]" class="form-control text-center" value="' + jam_masuk + '" / step="1"></td>';
                    html += '<td class="text-center"><input type="text" name="pulang[]" id="phone" class="form-control text-center"  value="' + jam_pulang + '" step="1" /></td>';
                    html += '<td class="text-center"><input type="text" name="start_absen_masuk[]" class="form-control text-center" value="' + start_absensi_masuk + '" / step="1"></td>';
                    html += '<td class="text-center"><input type="text" name="batas_absen_pulang[]" class="form-control text-center" value="' + batas_absen_pulang + '" / step="1"></td>';
                    if (level_user == '1') {
                        html += '<td class="text-center">' + btn_libur_unchecked + '&nbsp;&nbsp;&nbsp;' + btn_edit_checked + '</td>';
                    }

                } else {
                    html += '<td class="text-center">' + hari + '</td>';
                    html += '<td class="text-center"><input type="text" name="masuk[]" class="form-control text-center" value="00:00:00" / step="1" readonly><input type="hidden" name="hidden_id[]" value="' + id_jam_kerja + '" /></td>';
                    html += '<td class="text-center"><input type="text" name="pulang[]" class="form-control text-center" value="00:00:00" step="1" readonly /><input type="hidden" name="libur[]" value="1" /></td>';
                    html += '<td class="text-center"><input type="text" name="start_absen_masuk[]" class="form-control text-center" value="00:00:00" / step="1" readonly></td>';
                    html += '<td class="text-center"><input type="text" name="batas_absen_pulang[]" class="form-control text-center" value="00:00:00" / step="1" readonly></td>';
                    if (level_user == '1') {
                        html += '<td class="text-center">' + btn_libur_checked + '&nbsp;&nbsp;&nbsp;' + btn_edit_checked + '</td>';
                    }

                }
            } else {
                if (libur == 1) {
                    html += '<td style="text-align: center;">' + hari + '</td>';
                    html += '<td style="text-align: center;">' + "-" + '</td>';
                    html += '<td style="text-align: center;">' + "-" + '</td>';
                    html += '<td style="text-align: center;">' + "-" + '</td>';
                    html += '<td style="text-align: center;">' + "-" + '</td>';
                    if (level_user == '1') {
                        html += '<td class="text-center"><div class="badge badge-danger">' + libur_lang + '</div>&nbsp;&nbsp;&nbsp;' + btn_edit_unchecked + '</td>';
                    }
                } else {
                    html += '<td class="text-center">' + hari + '</td>';
                    html += '<td class="text-center">' + jam_masuk + '</td>';
                    html += '<td class="text-center">' + jam_pulang + '</td>';
                    html += '<td class="text-center">' + start_absensi_masuk + '</td>';
                    html += '<td class="text-center">' + batas_absen_pulang + '</td>';
                    if (level_user == '1') {
                        html += '<td class="text-center">' + btn_edit_unchecked + '</td>';
                    }
                }

            }
            $(this).closest('tr').html(html);
            $("input[type=text]").inputmask({
                'alias': 'datetime',
                'inputFormat': 'HH:MM'
            });
        });


        $(document).on('click', '.libur', function() {
            var html = '';
            var id_jam_kerja = $(this).attr('id');
            var hari = $(this).data('nama');
            var jam_masuk = $(this).data('masuk');
            var jam_pulang = $(this).data('pulang');
            var start_absensi_masuk = $(this).data('start-absen-masuk');
            var batas_absen_pulang = $(this).data('batas-absen-pulang');
            var libur = $(this).data('libur');

            var btn_libur_unchecked = '<input type="checkbox" id="' + id_jam_kerja + '" data-nama="' + hari + '" data-masuk="' + jam_masuk + '" data-pulang="' + jam_pulang + '" data-start-absen-masuk="' + start_absensi_masuk + '" data-batas-absen-pulang="' + batas_absen_pulang + '" data-libur="' + libur + '" class="libur text-center" style="position: initial; opacity: 1"/> ' + libur_lang_tc;
            var btn_libur_checked = '<input type="checkbox" id="' + id_jam_kerja + '" data-nama="' + hari + '" data-masuk="' + jam_masuk + '" data-pulang="' + jam_pulang + '" data-start-absen-masuk="' + start_absensi_masuk + '" data-batas-absen-pulang="' + batas_absen_pulang + '" data-libur="' + libur + '" class="libur text-center" style="position: initial; opacity: 1" checked/> ' + libur_lang_tc;

            var btn_edit_unchecked = '<input type="checkbox" id="' + id_jam_kerja + '" data-nama="' + hari + '" data-masuk="' + jam_masuk + '" data-pulang="' + jam_pulang + '" data-start-absen-masuk="' + start_absensi_masuk + '" data-batas-absen-pulang="' + batas_absen_pulang + '" data-libur="' + libur + '"  class="check_box text-center" checked style="position: initial; opacity: 1"/> Edit';
            var btn_edit_checked = '<input type="checkbox" id="' + id_jam_kerja + '" data-nama="' + hari + '" data-masuk="' + jam_masuk + '" data-pulang="' + jam_pulang + '" data-start-absen-masuk="' + start_absensi_masuk + '" data-batas-absen-pulang="' + batas_absen_pulang + '" data-libur="' + libur + '"  class="check_box text-center" checked style="position: initial; opacity: 1" checked/> Edit';

            if (this.checked) {
                html += '<td class="text-center">' + hari + '</td>';
                html += '<td class="text-center"><input type="text" name="masuk[]" class="form-control text-center" value="00:00:00" / step="1" readonly><input type="hidden" name="hidden_id[]" value="' + id_jam_kerja + '" /></td>';
                html += '<td class="text-center"><input type="text" name="pulang[]" class="form-control text-center" value="00:00:00" step="1" readonly /><input type="hidden" name="libur[]" value="1" /></td>';
                html += '<td class="text-center"><input type="text" name="start_absen_masuk[]" class="form-control text-center" value="00:00:00" / step="1" readonly></td>';
                html += '<td class="text-center"><input type="text" name="batas_absen_pulang[]" class="form-control text-center" value="00:00:00" / step="1" readonly></td>';
                if (level_user == '1') {
                    html += '<td class="text-center">' + btn_libur_checked + '&nbsp;&nbsp;&nbsp;' + btn_edit_checked + '</td>';
                }

            } else {
                html += '<td class="text-center">' + hari + '</td>';
                html += '<td class="text-center"><input type="text" name="masuk[]" class="form-control text-center" value="' + jam_masuk + '" / step="1"><input type="hidden" name="hidden_id[]" value="' + id_jam_kerja + '" /></td>';
                html += '<td class="text-center"><input type="text" name="pulang[]" class="form-control text-center" value="' + jam_pulang + '" step="1" /><input type="hidden" name="libur[]" value="' + libur + '" /></td>';
                html += '<td class="text-center"><input type="text" name="start_absen_masuk[]" class="form-control text-center" value="' + $(this).data("min_masuk") + '" / step="1"></td>';
                html += '<td class="text-center"><input type="text" name="batas_absen_pulang[]" class="form-control text-center" value="' + $(this).data("max_masuk") + '" / step="1"></td>';
                if (level_user == '1') {
                    html += '<td class="text-center">' + btn_libur_unchecked + '&nbsp;&nbsp;&nbsp;' + btn_edit_unchecked + '</td>';
                }

            }

            $(this).closest('tr').html(html);
            $("input[type=text]").inputmask({
                'alias': 'datetime',
                'inputFormat': 'HH:MM'
            });
        });

        $('#update_form').on('submit', function(event) {
            event.preventDefault();
            $('#message_form').html("");
            var button_simpan = document.getElementById("update");
            var loading = Ladda.create(button_simpan);
            if ($('.check_box:checked').length > 0) {

                loading.start();

                $.ajax({
                    url: "<?= route('pengaturan.jamkerja.update') ?>",
                    method: "POST",
                    dataType: "json",
                    data: $(this).serialize(),
                    success: function(result) {
                        if (result.success == true) {
                            $.ajaxSetup({
                                headers: {
                                    'Csrf-Token': $('meta[name="csrf-token"]').attr('content')
                                }
                            });
                            setTimeout(function() {
                                fetch_data();
                            }, 200);

                        }
                        loading.stop();
                        $('#message_form').show();
                        $('#message_form').html(result.message);
                    },
                    error: function() {
                        loading.stop();
                        $('#message_form').show();
                        $('#message_form').html('<font color="#eb3a28"><i class="fa fa-close(alias)">&nbsp;</i><strong>Gagal : Terjadi Kesalahan</strong></font>');
                    }
                })
            }
        });
    });


    function toTitleCase(str) {
        str = str.toLowerCase();
        return str.replace(/\b\w/g, l => l.toUpperCase());
    }
</script>
