<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Informasi_karyawan_m extends CI_Model
{
    public function get_data_diri_by_id($id_karyawan)
    {
        return $this->db->select('
                nik,
                nama_lengkap,
                tanggungan,
                npwp,
                jml_anak,
                bank_atas_nama,
                bank_rek,
                bank_nama
            ')
            ->from('data_karyawan')
            ->where('md5(id_karyawan)', $id_karyawan)
            ->where('id_company', $this->id_company)
            ->get()
            ->row();
    }

    public function get_data_by_data_karyawan($id, $id_karyawan)
    {
        return $this->db->select($id)
            ->from('data_karyawan')
            ->where('md5(id_karyawan)', $id_karyawan)
            ->where('id_company', $this->id_company)
            ->get()
            ->row()
            ->$id;
    }

    public function get_data_ptkp()
    {
        $ptkp = $this->db->from('ptkp')->order_by('no_urut', 'asc')->get();
        $option = [];
        foreach ($ptkp->result() as $row) {
            $option[$row->kode] = $row->keterangan;
        }

        return $option;
    }

    public function save($set, $where)
    {
        $save = $this->db->update('data_karyawan', $set, $where);
        if ($save) {
            return __response_update(true);
        } else {
            return __response_update(false);
        }
    }
}
